/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Realm;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.request.body.multipart.FilePart;
import org.asynchttpclient.request.body.multipart.Part;
import org.asynchttpclient.request.body.multipart.StringPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zendesk.client.v2.FixedUri;
import org.zendesk.client.v2.TemplateUri;
import org.zendesk.client.v2.Uri;
import org.zendesk.client.v2.ZendeskException;
import org.zendesk.client.v2.ZendeskResponseException;
import org.zendesk.client.v2.ZendeskResponseRateLimitException;
import org.zendesk.client.v2.model.AgentRole;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Audit;
import org.zendesk.client.v2.model.Automation;
import org.zendesk.client.v2.model.Brand;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.ComplianceDeletionStatus;
import org.zendesk.client.v2.model.Field;
import org.zendesk.client.v2.model.Forum;
import org.zendesk.client.v2.model.Group;
import org.zendesk.client.v2.model.GroupMembership;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.JobStatus;
import org.zendesk.client.v2.model.Macro;
import org.zendesk.client.v2.model.Metric;
import org.zendesk.client.v2.model.Organization;
import org.zendesk.client.v2.model.OrganizationField;
import org.zendesk.client.v2.model.OrganizationMembership;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.SearchResultEntity;
import org.zendesk.client.v2.model.Status;
import org.zendesk.client.v2.model.SuspendedTicket;
import org.zendesk.client.v2.model.Ticket;
import org.zendesk.client.v2.model.TicketForm;
import org.zendesk.client.v2.model.TicketImport;
import org.zendesk.client.v2.model.TicketResult;
import org.zendesk.client.v2.model.Topic;
import org.zendesk.client.v2.model.Trigger;
import org.zendesk.client.v2.model.TwitterMonitor;
import org.zendesk.client.v2.model.User;
import org.zendesk.client.v2.model.UserField;
import org.zendesk.client.v2.model.UserRelatedInfo;
import org.zendesk.client.v2.model.hc.Article;
import org.zendesk.client.v2.model.hc.ArticleAttachments;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Subscription;
import org.zendesk.client.v2.model.hc.Translation;
import org.zendesk.client.v2.model.schedules.Holiday;
import org.zendesk.client.v2.model.schedules.Schedule;
import org.zendesk.client.v2.model.targets.BasecampTarget;
import org.zendesk.client.v2.model.targets.CampfireTarget;
import org.zendesk.client.v2.model.targets.EmailTarget;
import org.zendesk.client.v2.model.targets.PivotalTarget;
import org.zendesk.client.v2.model.targets.Target;
import org.zendesk.client.v2.model.targets.TwitterTarget;
import org.zendesk.client.v2.model.targets.UrlTarget;

public class Zendesk
implements Closeable {
    private static final String JSON = "application/json; charset=UTF-8";
    private final boolean closeClient;
    private final AsyncHttpClient client;
    private final Realm realm;
    private final String url;
    private final String oauthToken;
    private final ObjectMapper mapper;
    private final Logger logger = LoggerFactory.getLogger(Zendesk.class);
    private boolean closed = false;
    private static final Map<String, Class<? extends SearchResultEntity>> searchResultTypes = Zendesk.searchResultTypes();
    private static final Map<String, Class<? extends Target>> targetTypes = Zendesk.targetTypes();
    private static final Pattern RESTRICTED_PATTERN = Pattern.compile("%2B", 16);
    private static final String NEXT_PAGE = "next_page";
    private static final String END_TIME = "end_time";
    private static final String COUNT = "count";
    private static final int INCREMENTAL_EXPORT_MAX_COUNT_BY_REQUEST = 1000;
    private static final long FIVE_MINUTES = TimeUnit.MINUTES.toMillis(5L);
    private static final String UTF_8 = "UTF-8";

    private static Map<String, Class<? extends SearchResultEntity>> searchResultTypes() {
        HashMap<String, Class> result = new HashMap<String, Class>();
        result.put("ticket", Ticket.class);
        result.put("user", User.class);
        result.put("group", Group.class);
        result.put("organization", Organization.class);
        result.put("topic", Topic.class);
        result.put("article", Article.class);
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, Class<? extends Target>> targetTypes() {
        HashMap<String, Class> result = new HashMap<String, Class>();
        result.put("url_target", UrlTarget.class);
        result.put("email_target", EmailTarget.class);
        result.put("basecamp_target", BasecampTarget.class);
        result.put("campfire_target", CampfireTarget.class);
        result.put("pivotal_target", PivotalTarget.class);
        result.put("twitter_target", TwitterTarget.class);
        return Collections.unmodifiableMap(result);
    }

    private Zendesk(AsyncHttpClient client, String url, String username, String password) {
        this.closeClient = client == null;
        this.oauthToken = null;
        this.client = client == null ? new DefaultAsyncHttpClient() : client;
        String string = this.url = url.endsWith("/") ? url + "api/v2" : url + "/api/v2";
        if (username != null) {
            this.realm = new Realm.Builder(username, password).setScheme(Realm.AuthScheme.BASIC).setUsePreemptiveAuth(true).build();
        } else {
            if (password != null) {
                throw new IllegalStateException("Cannot specify token or password without specifying username");
            }
            this.realm = null;
        }
        this.mapper = Zendesk.createMapper();
    }

    private Zendesk(AsyncHttpClient client, String url, String oauthToken) {
        this.closeClient = client == null;
        this.realm = null;
        this.client = client == null ? new DefaultAsyncHttpClient() : client;
        String string = this.url = url.endsWith("/") ? url + "api/v2" : url + "/api/v2";
        if (oauthToken == null) {
            throw new IllegalStateException("Cannot specify token or password without specifying username");
        }
        this.oauthToken = oauthToken;
        this.mapper = Zendesk.createMapper();
    }

    public boolean isClosed() {
        return this.closed || this.client.isClosed();
    }

    @Override
    public void close() {
        if (this.closeClient && !this.client.isClosed()) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                this.logger.warn("Unexpected error on client close", (Throwable)e);
            }
        }
        this.closed = true;
    }

    public <T> JobStatus<T> getJobStatus(JobStatus<T> status) {
        return Zendesk.complete(this.getJobStatusAsync(status));
    }

    public <T> ListenableFuture<JobStatus<T>> getJobStatusAsync(JobStatus<T> status) {
        return this.submit(this.req("GET", this.tmpl("/job_statuses/{id}.json").set("id", status.getId())), this.handleJobStatus(status.getResultsClass()));
    }

    public List<JobStatus<HashMap<String, Object>>> getJobStatuses(List<JobStatus> statuses) {
        return Zendesk.complete(this.getJobStatusesAsync(statuses));
    }

    public ListenableFuture<List<JobStatus<HashMap<String, Object>>>> getJobStatusesAsync(List<JobStatus> statuses) {
        ArrayList<String> ids = new ArrayList<String>(statuses.size());
        for (JobStatus status : statuses) {
            ids.add(status.getId());
        }
        Class<JobStatus> clazz = JobStatus.class;
        return this.submit(this.req("GET", this.tmpl("/job_statuses/show_many.json{?ids}").set("ids", ids)), this.handleList(clazz, "job_statuses"));
    }

    public List<Brand> getBrands() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/brands.json")), this.handleList(Brand.class, "brands")));
    }

    public TicketForm getTicketForm(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/ticket_forms/{id}.json").set("id", id)), this.handle(TicketForm.class, "ticket_form", new Class[0])));
    }

    public List<TicketForm> getTicketForms() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/ticket_forms.json")), this.handleList(TicketForm.class, "ticket_forms")));
    }

    public TicketForm createTicketForm(TicketForm ticketForm) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/ticket_forms.json"), JSON, this.json(Collections.singletonMap("ticket_form", ticketForm))), this.handle(TicketForm.class, "ticket_form", new Class[0])));
    }

    public Ticket importTicket(TicketImport ticketImport) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/imports/tickets.json"), JSON, this.json(Collections.singletonMap("ticket", ticketImport))), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public JobStatus<Ticket> importTickets(TicketImport ... ticketImports) {
        return this.importTickets(Arrays.asList(ticketImports));
    }

    public JobStatus<Ticket> importTickets(List<TicketImport> ticketImports) {
        return Zendesk.complete(this.importTicketsAsync(ticketImports));
    }

    public ListenableFuture<JobStatus<Ticket>> importTicketsAsync(List<TicketImport> ticketImports) {
        return this.submit(this.req("POST", this.cnst("/imports/tickets/create_many.json"), JSON, this.json(Collections.singletonMap("tickets", ticketImports))), this.handleJobStatus(Ticket.class));
    }

    public Ticket getTicket(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{id}.json").set("id", id)), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public List<Ticket> getTicketIncidents(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{id}/incidents.json").set("id", id)), this.handleList(Ticket.class, "tickets")));
    }

    public List<User> getTicketCollaborators(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{id}/collaborators.json").set("id", id)), this.handleList(User.class, "users")));
    }

    public JobStatus permanentlyDeleteTicket(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        return this.permanentlyDeleteTicket(ticket.getId());
    }

    public void deleteTicket(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        this.deleteTicket(ticket.getId());
    }

    public void deleteTicket(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/tickets/{id}.json").set("id", id)), this.handleStatus()));
    }

    public JobStatus permanentlyDeleteTicket(long id) {
        this.deleteTicket(id);
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/deleted_tickets/{id}.json").set("id", id)), this.handleJobStatus(JobStatus.class)));
    }

    public ListenableFuture<JobStatus<Ticket>> queueCreateTicketAsync(Ticket ticket) {
        return this.submit(this.req("POST", this.cnst("/tickets.json?async=true"), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handleJobStatus(Ticket.class));
    }

    public ListenableFuture<Ticket> createTicketAsync(Ticket ticket) {
        return this.submit(this.req("POST", this.cnst("/tickets.json"), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handle(Ticket.class, "ticket", new Class[0]));
    }

    public Ticket createTicket(Ticket ticket) {
        return Zendesk.complete(this.createTicketAsync(ticket));
    }

    public JobStatus<Ticket> createTickets(Ticket ... tickets) {
        return this.createTickets(Arrays.asList(tickets));
    }

    public JobStatus<Ticket> createTickets(List<Ticket> tickets) {
        return Zendesk.complete(this.createTicketsAsync(tickets));
    }

    public ListenableFuture<JobStatus<Ticket>> createTicketsAsync(List<Ticket> tickets) {
        return this.submit(this.req("POST", this.cnst("/tickets/create_many.json"), JSON, this.json(Collections.singletonMap("tickets", tickets))), this.handleJobStatus(Ticket.class));
    }

    public Ticket updateTicket(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}.json").set("id", ticket.getId()), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public ListenableFuture<JobStatus<Ticket>> updateTicketsAsync(List<Ticket> tickets) {
        return this.submit(this.req("PUT", this.cnst("/tickets/update_many.json"), JSON, this.json(Collections.singletonMap("tickets", tickets))), this.handleJobStatus(Ticket.class));
    }

    public void markTicketAsSpam(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        this.markTicketAsSpam(ticket.getId());
    }

    public void markTicketAsSpam(long id) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}/mark_as_spam.json").set("id", id)), this.handleStatus()));
    }

    public void deleteTickets(long id, long ... ids) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/tickets/destroy_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleStatus()));
    }

    public JobStatus permanentlyDeleteTickets(long id, long ... ids) {
        this.deleteTickets(id, ids);
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/deleted_tickets/destroy_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleJobStatus(JobStatus.class)));
    }

    public Iterable<Ticket> getTickets() {
        return new PagedIterable<Ticket>(this.cnst("/tickets.json"), this.handleList(Ticket.class, "tickets"));
    }

    @Deprecated
    public Iterable<Ticket> getTicketsByStatus(Status ... ticketStatus) {
        return new PagedIterable<Ticket>(this.tmpl("/tickets.json{?status}").set("status", Zendesk.statusArray(ticketStatus)), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getTicketsByExternalId(String externalId, boolean includeArchived) {
        PagedIterable<Ticket> results = new PagedIterable<Ticket>(this.tmpl("/tickets.json{?external_id}").set("external_id", externalId), this.handleList(Ticket.class, "tickets"));
        if (!includeArchived || results.iterator().hasNext()) {
            return results;
        }
        return new PagedIterable<Ticket>(this.tmpl("/search.json{?query}{&type}").set("query", "external_id:" + externalId).set("type", "ticket"), this.handleList(Ticket.class, "results"));
    }

    public Iterable<Ticket> getTicketsByExternalId(String externalId) {
        return this.getTicketsByExternalId(externalId, false);
    }

    public Iterable<Ticket> getTicketsFromSearch(String searchTerm) {
        return new PagedIterable<Ticket>(this.tmpl("/search.json{?query}").set("query", searchTerm + "+type:ticket"), this.handleList(Ticket.class, "results"));
    }

    public Iterable<Article> getArticleFromSearch(String searchTerm) {
        return new PagedIterable<Article>(this.tmpl("/help_center/articles/search.json{?query}").set("query", searchTerm), this.handleList(Article.class, "results"));
    }

    public Iterable<Article> getArticleFromSearch(String searchTerm, Long sectionId) {
        return new PagedIterable<Article>(this.tmpl("/help_center/articles/search.json{?section,query}").set("query", searchTerm).set("section", sectionId), this.handleList(Article.class, "results"));
    }

    public List<ArticleAttachments> getAttachmentsFromArticle(Long articleID) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/articles/{id}/attachments.json").set("id", articleID)), this.handleArticleAttachmentsList("article_attachments")));
    }

    public List<Ticket> getTickets(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/show_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleList(Ticket.class, "tickets")));
    }

    public Iterable<Ticket> getRecentTickets() {
        return new PagedIterable<Ticket>(this.cnst("/tickets/recent.json"), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getTicketsIncrementally(Date startTime) {
        return new PagedIterable<Ticket>(this.tmpl("/incremental/tickets.json{?start_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())), this.handleIncrementalList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getTicketsIncrementally(Date startTime, Date endTime) {
        return new PagedIterable<Ticket>(this.tmpl("/incremental/tickets.json{?start_time,end_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())).set(END_TIME, Zendesk.msToSeconds(endTime.getTime())), this.handleIncrementalList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getOrganizationTickets(long organizationId) {
        return new PagedIterable<Ticket>(this.tmpl("/organizations/{organizationId}/tickets.json").set("organizationId", organizationId), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<Ticket> getUserRequestedTickets(long userId) {
        return new PagedIterable<Ticket>(this.tmpl("/users/{userId}/tickets/requested.json").set("userId", userId), this.handleList(Ticket.class, "tickets"));
    }

    public Iterable<ComplianceDeletionStatus> getComplianceDeletionStatuses(long userId) {
        return new PagedIterable<ComplianceDeletionStatus>(this.tmpl("/users/{userId}/compliance_deletion_statuses.json").set("userId", userId), this.handleList(ComplianceDeletionStatus.class, "compliance_deletion_statuses"));
    }

    public Iterable<Ticket> getUserCCDTickets(long userId) {
        return new PagedIterable<Ticket>(this.tmpl("/users/{userId}/tickets/ccd.json").set("userId", userId), this.handleList(Ticket.class, "tickets"));
    }

    public UserRelatedInfo getUserRelatedInfo(long userId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{userId}/related.json").set("userId", userId)), this.handle(UserRelatedInfo.class, "user_related", new Class[0])));
    }

    public Iterable<Metric> getTicketMetrics() {
        return new PagedIterable<Metric>(this.cnst("/ticket_metrics.json"), this.handleList(Metric.class, "ticket_metrics"));
    }

    public Metric getTicketMetricByTicket(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{ticketId}/metrics.json").set("ticketId", id)), this.handle(Metric.class, "ticket_metric", new Class[0])));
    }

    public Metric getTicketMetric(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/ticket_metrics/{ticketMetricId}.json").set("ticketMetricId", id)), this.handle(Metric.class, "ticket_metric", new Class[0])));
    }

    public Iterable<Audit> getTicketAudits(Ticket ticket) {
        Zendesk.checkHasId(ticket);
        return this.getTicketAudits(ticket.getId());
    }

    public Iterable<Audit> getTicketAudits(Long id) {
        return new PagedIterable<Audit>(this.tmpl("/tickets/{ticketId}/audits.json").set("ticketId", id), this.handleList(Audit.class, "audits"));
    }

    public Audit getTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        return this.getTicketAudit(ticket, (long)audit.getId());
    }

    public Audit getTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        return this.getTicketAudit(ticket.getId(), id);
    }

    public Audit getTicketAudit(long ticketId, long auditId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{ticketId}/audits/{auditId}.json").set("ticketId", ticketId).set("auditId", auditId)), this.handle(Audit.class, "audit", new Class[0])));
    }

    public void trustTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        this.trustTicketAudit(ticket, (long)audit.getId());
    }

    public void trustTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        this.trustTicketAudit(ticket.getId(), id);
    }

    public void trustTicketAudit(long ticketId, long auditId) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{ticketId}/audits/{auditId}/trust.json").set("ticketId", ticketId).set("auditId", auditId)), this.handleStatus()));
    }

    public void makePrivateTicketAudit(Ticket ticket, Audit audit) {
        Zendesk.checkHasId(audit);
        this.makePrivateTicketAudit(ticket, (long)audit.getId());
    }

    public void makePrivateTicketAudit(Ticket ticket, long id) {
        Zendesk.checkHasId(ticket);
        this.makePrivateTicketAudit(ticket.getId(), id);
    }

    public void makePrivateTicketAudit(long ticketId, long auditId) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{ticketId}/audits/{auditId}/make_private.json").set("ticketId", ticketId).set("auditId", auditId)), this.handleStatus()));
    }

    public List<Field> getTicketFields() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/ticket_fields.json")), this.handleList(Field.class, "ticket_fields")));
    }

    public Field getTicketField(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/ticket_fields/{id}.json").set("id", id)), this.handle(Field.class, "ticket_field", new Class[0])));
    }

    public Field createTicketField(Field field) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/ticket_fields.json"), JSON, this.json(Collections.singletonMap("ticket_field", field))), this.handle(Field.class, "ticket_field", new Class[0])));
    }

    public Field updateTicketField(Field field) {
        Zendesk.checkHasId(field);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/ticket_fields/{id}.json").set("id", field.getId()), JSON, this.json(Collections.singletonMap("ticket_field", field))), this.handle(Field.class, "ticket_field", new Class[0])));
    }

    public void deleteTicketField(Field field) {
        Zendesk.checkHasId(field);
        this.deleteTicket(field.getId());
    }

    public void deleteTicketField(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/ticket_fields/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<SuspendedTicket> getSuspendedTickets() {
        return new PagedIterable<SuspendedTicket>(this.cnst("/suspended_tickets.json"), this.handleList(SuspendedTicket.class, "suspended_tickets"));
    }

    public void deleteSuspendedTicket(SuspendedTicket ticket) {
        Zendesk.checkHasId(ticket);
        this.deleteSuspendedTicket(ticket.getId());
    }

    public void deleteSuspendedTicket(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/suspended_tickets/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Attachment.Upload createUpload(String fileName, byte[] content) {
        return this.createUpload(null, fileName, "application/binary", content);
    }

    public Attachment.Upload createUpload(String fileName, String contentType, byte[] content) {
        return this.createUpload(null, fileName, contentType, content);
    }

    public Attachment.Upload createUpload(String token, String fileName, String contentType, byte[] content) {
        TemplateUri uri = this.tmpl("/uploads.json{?filename,token}").set("filename", fileName);
        if (token != null) {
            uri.set("token", token);
        }
        return Zendesk.complete(this.submit(this.req("POST", uri, contentType, content), this.handle(Attachment.Upload.class, "upload", new Class[0])));
    }

    public void associateAttachmentsToArticle(String idArticle, List<Attachment> attachments) {
        TemplateUri uri = this.tmpl("/help_center/articles/{article_id}/bulk_attachments.json").set("article_id", idArticle);
        ArrayList<Long> attachmentsIds = new ArrayList<Long>();
        for (Attachment item : attachments) {
            attachmentsIds.add(item.getId());
        }
        Zendesk.complete(this.submit(this.req("POST", uri, JSON, this.json(Collections.singletonMap("attachment_ids", attachmentsIds))), this.handleStatus()));
    }

    public ArticleAttachments createUploadArticle(long articleId, File file) throws IOException {
        return this.createUploadArticle(articleId, file, false);
    }

    public ArticleAttachments createUploadArticle(long articleId, File file, boolean inline) throws IOException {
        BoundRequestBuilder builder = this.client.preparePost(this.tmpl("/help_center/articles/{id}/attachments.json").set("id", articleId).toString());
        if (this.realm != null) {
            builder.setRealm(this.realm);
        } else {
            builder.addHeader((CharSequence)"Authorization", "Bearer " + this.oauthToken);
        }
        builder.setHeader((CharSequence)"Content-Type", "multipart/form-data");
        if (inline) {
            builder.addBodyPart((Part)new StringPart("inline", "true"));
        }
        builder.addBodyPart((Part)new FilePart("file", file, "application/octet-stream", Charset.forName(UTF_8), file.getName()));
        org.asynchttpclient.Request req = builder.build();
        return Zendesk.complete(this.submit(req, this.handle(ArticleAttachments.class, "article_attachment", new Class[0])));
    }

    public void deleteUpload(Attachment.Upload upload) {
        Zendesk.checkHasToken(upload);
        this.deleteUpload(upload.getToken());
    }

    public void deleteUpload(String token) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/uploads/{token}.json").set("token", token)), this.handleStatus()));
    }

    public Attachment getAttachment(Attachment attachment) {
        Zendesk.checkHasId(attachment);
        return this.getAttachment(attachment.getId());
    }

    public Attachment getAttachment(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/attachments/{id}.json").set("id", id)), this.handle(Attachment.class, "attachment", new Class[0])));
    }

    public void deleteAttachment(Attachment attachment) {
        Zendesk.checkHasId(attachment);
        this.deleteAttachment(attachment.getId());
    }

    public void deleteAttachment(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/attachments/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Target> getTargets() {
        return new PagedIterable<Target>(this.cnst("/targets.json"), this.handleTargetList("targets"));
    }

    public Target getTarget(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/targets/{id}.json").set("id", id)), this.handle(Target.class, "target", new Class[0])));
    }

    public Target createTarget(Target target) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/targets.json"), JSON, this.json(Collections.singletonMap("target", target))), this.handle(Target.class, "target", new Class[0])));
    }

    public void deleteTarget(long targetId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/targets/{id}.json").set("id", targetId)), this.handleStatus()));
    }

    public Iterable<Trigger> getTriggers() {
        return new PagedIterable<Trigger>(this.cnst("/triggers.json"), this.handleList(Trigger.class, "triggers"));
    }

    public Trigger getTrigger(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/triggers/{id}.json").set("id", id)), this.handle(Trigger.class, "trigger", new Class[0])));
    }

    public Trigger createTrigger(Trigger trigger) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/triggers.json"), JSON, this.json(Collections.singletonMap("trigger", trigger))), this.handle(Trigger.class, "trigger", new Class[0])));
    }

    public Trigger updateTrigger(Long triggerId, Trigger trigger) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/triggers/{id}.json").set("id", triggerId), JSON, this.json(Collections.singletonMap("trigger", trigger))), this.handle(Trigger.class, "trigger", new Class[0])));
    }

    public void deleteTrigger(long triggerId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/triggers/{id}.json").set("id", triggerId)), this.handleStatus()));
    }

    public Iterable<Automation> getAutomations() {
        return new PagedIterable<Automation>(this.cnst("/automations.json"), this.handleList(Automation.class, "automations"));
    }

    public Automation getAutomation(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/automations/{id}.json").set("id", id)), this.handle(Automation.class, "automation", new Class[0])));
    }

    public Automation createAutomation(Automation automation) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/automations.json"), JSON, this.json(Collections.singletonMap("automation", automation))), this.handle(Automation.class, "automation", new Class[0])));
    }

    public Automation updateAutomation(Long automationId, Automation automation) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/automations/{id}.json").set("id", automationId), JSON, this.json(Collections.singletonMap("automation", automation))), this.handle(Automation.class, "automation", new Class[0])));
    }

    public void deleteAutomation(long automationId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/automations/{id}.json").set("id", automationId)), this.handleStatus()));
    }

    public Iterable<TwitterMonitor> getTwitterMonitors() {
        return new PagedIterable<TwitterMonitor>(this.cnst("/channels/twitter/monitored_twitter_handles.json"), this.handleList(TwitterMonitor.class, "monitored_twitter_handles"));
    }

    public Iterable<User> getUsers() {
        return new PagedIterable<User>(this.cnst("/users.json"), this.handleList(User.class, "users"));
    }

    public Iterable<User> getUsersByRole(String role, String ... roles) {
        StringBuilder uriBuilder = new StringBuilder("/users.json");
        if (roles.length == 0) {
            uriBuilder.append("?role=").append(Zendesk.encodeUrl(role));
        } else {
            uriBuilder.append("?role[]=").append(Zendesk.encodeUrl(role));
        }
        for (String curRole : roles) {
            uriBuilder.append("&role[]=").append(Zendesk.encodeUrl(curRole));
        }
        return new PagedIterable<User>(this.cnst(uriBuilder.toString()), this.handleList(User.class, "users"));
    }

    public Iterable<User> getUsersIncrementally(Date startTime) {
        return new PagedIterable<User>(this.tmpl("/incremental/users.json{?start_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())), this.handleIncrementalList(User.class, "users"));
    }

    public Iterable<User> getGroupUsers(long id) {
        return new PagedIterable<User>(this.tmpl("/groups/{id}/users.json").set("id", id), this.handleList(User.class, "users"));
    }

    public Iterable<User> getOrganizationUsers(long id) {
        return new PagedIterable<User>(this.tmpl("/organizations/{id}/users.json").set("id", id), this.handleList(User.class, "users"));
    }

    public User getUser(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}.json").set("id", id)), this.handle(User.class, "user", new Class[0])));
    }

    public User getAuthenticatedUser() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/users/me.json")), this.handle(User.class, "user", new Class[0])));
    }

    public Iterable<UserField> getUserFields() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/user_fields.json")), this.handleList(UserField.class, "user_fields")));
    }

    public User createUser(User user) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/users.json"), JSON, this.json(Collections.singletonMap("user", user))), this.handle(User.class, "user", new Class[0])));
    }

    public JobStatus<User> createUsers(User ... users) {
        return this.createUsers(Arrays.asList(users));
    }

    public JobStatus<User> createUsers(List<User> users) {
        return Zendesk.complete(this.createUsersAsync(users));
    }

    public User createOrUpdateUser(User user) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/users/create_or_update.json"), JSON, this.json(Collections.singletonMap("user", user))), this.handle(User.class, "user", new Class[0])));
    }

    public ListenableFuture<JobStatus<User>> createUsersAsync(List<User> users) {
        return this.submit(this.req("POST", this.cnst("/users/create_many.json"), JSON, this.json(Collections.singletonMap("users", users))), this.handleJobStatus(User.class));
    }

    public User updateUser(User user) {
        Zendesk.checkHasId(user);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{id}.json").set("id", user.getId()), JSON, this.json(Collections.singletonMap("user", user))), this.handle(User.class, "user", new Class[0])));
    }

    public void deleteUser(User user) {
        Zendesk.checkHasId(user);
        this.deleteUser(user.getId());
    }

    public void deleteUser(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{id}.json").set("id", id)), this.handleStatus()));
    }

    public User permanentlyDeleteUser(User user) {
        Zendesk.checkHasId(user);
        return this.permanentlyDeleteUser(user.getId());
    }

    public User permanentlyDeleteUser(long id) {
        this.deleteUser(id);
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/deleted_users/{id}.json").set("id", id)), this.handle(User.class)));
    }

    public User suspendUser(long id) {
        User user = new User();
        user.setId(id);
        user.setSuspended(true);
        return this.updateUser(user);
    }

    public User unsuspendUser(long id) {
        User user = new User();
        user.setId(id);
        user.setSuspended(false);
        return this.updateUser(user);
    }

    public Iterable<User> lookupUserByEmail(String email) {
        return new PagedIterable<User>(this.tmpl("/users/search.json{?query}").set("query", email), this.handleList(User.class, "users"));
    }

    public Iterable<User> lookupUserByExternalId(String externalId) {
        return new PagedIterable<User>(this.tmpl("/users/search.json{?external_id}").set("external_id", externalId), this.handleList(User.class, "users"));
    }

    public User getCurrentUser() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/users/me.json")), this.handle(User.class, "user", new Class[0])));
    }

    public void resetUserPassword(User user, String password) {
        Zendesk.checkHasId(user);
        this.resetUserPassword(user.getId(), password);
    }

    public void resetUserPassword(long id, String password) {
        Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{id}/password.json").set("id", id), JSON, this.json(Collections.singletonMap("password", password))), this.handleStatus()));
    }

    public void changeUserPassword(User user, String oldPassword, String newPassword) {
        Zendesk.checkHasId(user);
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("previous_password", oldPassword);
        req.put("password", newPassword);
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{id}/password.json").set("id", user.getId()), JSON, this.json(req)), this.handleStatus()));
    }

    public List<Identity> getUserIdentities(User user) {
        Zendesk.checkHasId(user);
        return this.getUserIdentities(user.getId());
    }

    public List<Identity> getUserIdentities(long userId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}/identities.json").set("id", userId)), this.handleList(Identity.class, "identities")));
    }

    public Identity getUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.getUserIdentity(user, (long)identity.getId());
    }

    public Identity getUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.getUserIdentity(user.getId(), identityId);
    }

    public Identity getUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{userId}/identities/{identityId}.json").set("userId", userId).set("identityId", identityId)), this.handle(Identity.class, "identity", new Class[0])));
    }

    public List<Identity> setUserPrimaryIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.setUserPrimaryIdentity(user, (long)identity.getId());
    }

    public List<Identity> setUserPrimaryIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.setUserPrimaryIdentity(user.getId(), identityId);
    }

    public List<Identity> setUserPrimaryIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/make_primary.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handleList(Identity.class, "identities")));
    }

    public Identity verifyUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.verifyUserIdentity(user, (long)identity.getId());
    }

    public Identity verifyUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.verifyUserIdentity(user.getId(), identityId);
    }

    public Identity verifyUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/verify.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Identity requestVerifyUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        return this.requestVerifyUserIdentity(user, (long)identity.getId());
    }

    public Identity requestVerifyUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        return this.requestVerifyUserIdentity(user.getId(), identityId);
    }

    public Identity requestVerifyUserIdentity(long userId, long identityId) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}/request_verification.json").set("userId", userId).set("identityId", identityId), JSON, null), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Identity updateUserIdentity(long userId, Identity identity) {
        Zendesk.checkHasId(identity);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{userId}/identities/{identityId}.json").set("userId", userId).set("identityId", identity.getId()), JSON, null), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Identity updateUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(user);
        return this.updateUserIdentity(user.getId(), identity);
    }

    public void deleteUserIdentity(User user, Identity identity) {
        Zendesk.checkHasId(identity);
        this.deleteUserIdentity(user, (long)identity.getId());
    }

    public void deleteUserIdentity(User user, long identityId) {
        Zendesk.checkHasId(user);
        this.deleteUserIdentity(user.getId(), identityId);
    }

    public void deleteUserIdentity(long userId, long identityId) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{userId}/identities/{identityId}.json").set("userId", userId).set("identityId", identityId)), this.handleStatus()));
    }

    public Identity createUserIdentity(long userId, Identity identity) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{userId}/identities.json").set("userId", userId), JSON, this.json(Collections.singletonMap("identity", identity))), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Identity createUserIdentity(User user, Identity identity) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{userId}/identities.json").set("userId", user.getId()), JSON, this.json(Collections.singletonMap("identity", identity))), this.handle(Identity.class, "identity", new Class[0])));
    }

    public Iterable<AgentRole> getCustomAgentRoles() {
        return new PagedIterable<AgentRole>(this.cnst("/custom_roles.json"), this.handleList(AgentRole.class, "custom_roles"));
    }

    public Iterable<Request> getRequests() {
        return new PagedIterable<Request>(this.cnst("/requests.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getOpenRequests() {
        return new PagedIterable<Request>(this.cnst("/requests/open.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getSolvedRequests() {
        return new PagedIterable<Request>(this.cnst("/requests/solved.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getCCRequests() {
        return new PagedIterable<Request>(this.cnst("/requests/ccd.json"), this.handleList(Request.class, "requests"));
    }

    public Iterable<Request> getUserRequests(User user) {
        Zendesk.checkHasId(user);
        return this.getUserRequests(user.getId());
    }

    public Iterable<Request> getUserRequests(long id) {
        return new PagedIterable<Request>(this.tmpl("/users/{id}/requests.json").set("id", id), this.handleList(Request.class, "requests"));
    }

    public Request getRequest(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/requests/{id}.json").set("id", id)), this.handle(Request.class, "request", new Class[0])));
    }

    public Request createRequest(Request request) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/requests.json"), JSON, this.json(Collections.singletonMap("request", request))), this.handle(Request.class, "request", new Class[0])));
    }

    public Request updateRequest(Request request) {
        Zendesk.checkHasId(request);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/requests/{id}.json").set("id", request.getId()), JSON, this.json(Collections.singletonMap("request", request))), this.handle(Request.class, "request", new Class[0])));
    }

    public Iterable<Comment> getRequestComments(Request request) {
        Zendesk.checkHasId(request);
        return this.getRequestComments(request.getId());
    }

    public Iterable<Comment> getRequestComments(long id) {
        return new PagedIterable<Comment>(this.tmpl("/requests/{id}/comments.json").set("id", id), this.handleList(Comment.class, "comments"));
    }

    public Iterable<Comment> getTicketComments(long id) {
        return new PagedIterable<Comment>(this.tmpl("/tickets/{id}/comments.json").set("id", id), this.handleList(Comment.class, "comments"));
    }

    public Comment getRequestComment(Request request, Comment comment) {
        Zendesk.checkHasId(comment);
        return this.getRequestComment(request, (long)comment.getId());
    }

    public Comment getRequestComment(Request request, long commentId) {
        Zendesk.checkHasId(request);
        return this.getRequestComment(request.getId(), commentId);
    }

    public Comment getRequestComment(long requestId, long commentId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/requests/{requestId}/comments/{commentId}.json").set("requestId", requestId).set("commentId", commentId)), this.handle(Comment.class, "comment", new Class[0])));
    }

    public Ticket createComment(long ticketId, Comment comment) {
        Ticket ticket = new Ticket();
        ticket.setComment(comment);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}.json").set("id", ticketId), JSON, this.json(Collections.singletonMap("ticket", ticket))), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public Ticket createTicketFromTweet(long tweetId, long monitorId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("twitter_status_message_id", tweetId);
        map.put("monitored_twitter_handle_id", monitorId);
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/channels/twitter/tickets.json"), JSON, this.json(Collections.singletonMap("ticket", map))), this.handle(Ticket.class, "ticket", new Class[0])));
    }

    public Iterable<Organization> getOrganizations() {
        return new PagedIterable<Organization>(this.cnst("/organizations.json"), this.handleList(Organization.class, "organizations"));
    }

    public Iterable<Organization> getOrganizationsIncrementally(Date startTime) {
        return new PagedIterable<Organization>(this.tmpl("/incremental/organizations.json{?start_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())), this.handleIncrementalList(Organization.class, "organizations"));
    }

    public Iterable<OrganizationField> getOrganizationFields() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/organization_fields.json")), this.handleList(OrganizationField.class, "organization_fields")));
    }

    public Iterable<Organization> getAutoCompleteOrganizations(String name) {
        if (name == null || name.length() < 2) {
            throw new IllegalArgumentException("Name must be at least 2 characters long");
        }
        return new PagedIterable<Organization>(this.tmpl("/organizations/autocomplete.json{?name}").set("name", name), this.handleList(Organization.class, "organizations"));
    }

    public Organization getOrganization(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/organizations/{id}.json").set("id", id)), this.handle(Organization.class, "organization", new Class[0])));
    }

    public Organization createOrganization(Organization organization) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/organizations.json"), JSON, this.json(Collections.singletonMap("organization", organization))), this.handle(Organization.class, "organization", new Class[0])));
    }

    public JobStatus<Organization> createOrganizations(Organization ... organizations) {
        return this.createOrganizations(Arrays.asList(organizations));
    }

    public JobStatus createOrganizations(List<Organization> organizations) {
        return Zendesk.complete(this.createOrganizationsAsync(organizations));
    }

    public ListenableFuture<JobStatus<Organization>> createOrganizationsAsync(List<Organization> organizations) {
        return this.submit(this.req("POST", this.cnst("/organizations/create_many.json"), JSON, this.json(Collections.singletonMap("organizations", organizations))), this.handleJobStatus(Organization.class));
    }

    public Organization updateOrganization(Organization organization) {
        Zendesk.checkHasId(organization);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/organizations/{id}.json").set("id", organization.getId()), JSON, this.json(Collections.singletonMap("organization", organization))), this.handle(Organization.class, "organization", new Class[0])));
    }

    public void deleteOrganization(Organization organization) {
        Zendesk.checkHasId(organization);
        this.deleteOrganization(organization.getId());
    }

    public void deleteOrganization(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organizations/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Organization> lookupOrganizationsByExternalId(String externalId) {
        if (externalId == null || externalId.length() < 2) {
            throw new IllegalArgumentException("Name must be at least 2 characters long");
        }
        return new PagedIterable<Organization>(this.tmpl("/organizations/search.json{?external_id}").set("external_id", externalId), this.handleList(Organization.class, "organizations"));
    }

    public Iterable<OrganizationMembership> getOrganizationMemberships() {
        return new PagedIterable<OrganizationMembership>(this.cnst("/organization_memberships.json"), this.handleList(OrganizationMembership.class, "organization_memberships"));
    }

    public Iterable<OrganizationMembership> getOrganizationMembershipsForOrg(long organization_id) {
        return new PagedIterable<OrganizationMembership>(this.tmpl("/organizations/{organization_id}/organization_memberships.json").set("organization_id", organization_id), this.handleList(OrganizationMembership.class, "organization_memberships"));
    }

    public Iterable<OrganizationMembership> getOrganizationMembershipsForUser(long user_id) {
        return new PagedIterable<OrganizationMembership>(this.tmpl("/users/{user_id}/organization_memberships.json").set("user_id", user_id), this.handleList(OrganizationMembership.class, "organization_memberships"));
    }

    public OrganizationMembership getOrganizationMembershipForUser(long user_id, long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{user_id}/organization_memberships/{id}.json").set("user_id", user_id).set("id", id)), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public OrganizationMembership getOrganizationMembership(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/organization_memberships/{id}.json").set("id", id)), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public OrganizationMembership createOrganizationMembership(OrganizationMembership organizationMembership) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/organization_memberships.json"), JSON, this.json(Collections.singletonMap("organization_membership", organizationMembership))), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public void deleteOrganizationMembership(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organization_memberships/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Group> getGroups() {
        return new PagedIterable<Group>(this.cnst("/groups.json"), this.handleList(Group.class, "groups"));
    }

    public Iterable<Group> getAssignableGroups() {
        return new PagedIterable<Group>(this.cnst("/groups/assignable.json"), this.handleList(Group.class, "groups"));
    }

    public Group getGroup(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/groups/{id}.json").set("id", id)), this.handle(Group.class, "group", new Class[0])));
    }

    public Group createGroup(Group group) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/groups.json"), JSON, this.json(Collections.singletonMap("group", group))), this.handle(Group.class, "group", new Class[0])));
    }

    @Deprecated
    public List<Group> createGroups(Group ... groups) {
        return this.createGroups(Arrays.asList(groups));
    }

    @Deprecated
    public List<Group> createGroups(List<Group> groups) {
        throw new ZendeskException("API Endpoint for createGroups does not exist.");
    }

    public Group updateGroup(Group group) {
        Zendesk.checkHasId(group);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/groups/{id}.json").set("id", group.getId()), JSON, this.json(Collections.singletonMap("group", group))), this.handle(Group.class, "group", new Class[0])));
    }

    public void deleteGroup(Group group) {
        Zendesk.checkHasId(group);
        this.deleteGroup(group.getId());
    }

    public void deleteGroup(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/groups/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Macro> getMacros() {
        return new PagedIterable<Macro>(this.cnst("/macros.json"), this.handleList(Macro.class, "macros"));
    }

    public Macro getMacro(long macroId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/macros/{id}.json").set("id", macroId)), this.handle(Macro.class, "macro", new Class[0])));
    }

    public Macro createMacro(Macro macro) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/macros.json"), JSON, this.json(Collections.singletonMap("macro", macro))), this.handle(Macro.class, "macro", new Class[0])));
    }

    public Macro updateMacro(Long macroId, Macro macro) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/macros/{id}.json").set("id", macroId), JSON, this.json(Collections.singletonMap("macro", macro))), this.handle(Macro.class, "macro", new Class[0])));
    }

    public Ticket macrosShowChangesToTicket(long macroId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/macros/{id}/apply.json").set("id", macroId)), this.handle(TicketResult.class, "result", new Class[0]))).getTicket();
    }

    public Ticket macrosShowTicketAfterChanges(long ticketId, long macroId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/tickets/{ticket_id}/macros/{id}/apply.json").set("ticket_id", ticketId).set("id", macroId)), this.handle(TicketResult.class, "result", new Class[0]))).getTicket();
    }

    public List<String> addTagToTicket(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/tickets/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> addTagToTopics(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/topics/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> addTagToOrganisations(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/organizations/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> setTagOnTicket(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/tickets/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> setTagOnTopics(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/topics/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> setTagOnOrganisations(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/organizations/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> removeTagFromTicket(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/tickets/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> removeTagFromTopics(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/topics/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public List<String> removeTagFromOrganisations(long id, String ... tags) {
        return Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/organizations/{id}/tags.json").set("id", id), JSON, this.json(Collections.singletonMap("tags", tags))), this.handle(List.class, "tags", new Class[0])));
    }

    public Map getIncrementalTicketsResult(long unixEpochTime) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/exports/tickets.json?start_time={time}").set("time", unixEpochTime)), this.handle(Map.class)));
    }

    public Iterable<GroupMembership> getGroupMemberships() {
        return new PagedIterable<GroupMembership>(this.cnst("/group_memberships.json"), this.handleList(GroupMembership.class, "group_memberships"));
    }

    public List<GroupMembership> getGroupMembershipByUser(long user_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{user_id}/group_memberships.json").set("user_id", user_id)), this.handleList(GroupMembership.class, "group_memberships")));
    }

    public List<GroupMembership> getGroupMemberships(long group_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/groups/{group_id}/memberships.json").set("group_id", group_id)), this.handleList(GroupMembership.class, "group_memberships")));
    }

    public Iterable<GroupMembership> getAssignableGroupMemberships() {
        return new PagedIterable<GroupMembership>(this.cnst("/group_memberships/assignable.json"), this.handleList(GroupMembership.class, "group_memberships"));
    }

    public List<GroupMembership> getAssignableGroupMemberships(long group_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/groups/{group_id}/memberships/assignable.json").set("group_id", group_id)), this.handleList(GroupMembership.class, "group_memberships")));
    }

    public GroupMembership getGroupMembership(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/group_memberships/{id}.json").set("id", id)), this.handle(GroupMembership.class, "group_membership", new Class[0])));
    }

    public GroupMembership getGroupMembership(long user_id, long group_membership_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{uid}/group_memberships/{gmid}.json").set("uid", user_id).set("gmid", group_membership_id)), this.handle(GroupMembership.class, "group_membership", new Class[0])));
    }

    public GroupMembership createGroupMembership(GroupMembership groupMembership) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/group_memberships.json"), JSON, this.json(Collections.singletonMap("group_membership", groupMembership))), this.handle(GroupMembership.class, "group_membership", new Class[0])));
    }

    public GroupMembership createGroupMembership(long user_id, GroupMembership groupMembership) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{id}/group_memberships.json").set("id", user_id), JSON, this.json(Collections.singletonMap("group_membership", groupMembership))), this.handle(GroupMembership.class, "group_membership", new Class[0])));
    }

    public void deleteGroupMembership(GroupMembership groupMembership) {
        Zendesk.checkHasId(groupMembership);
        this.deleteGroupMembership(groupMembership.getId());
    }

    public void deleteGroupMembership(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/group_memberships/{id}.json").set("id", id)), this.handleStatus()));
    }

    public void deleteGroupMembership(long user_id, GroupMembership groupMembership) {
        Zendesk.checkHasId(groupMembership);
        this.deleteGroupMembership(user_id, groupMembership.getId());
    }

    public void deleteGroupMembership(long user_id, long group_membership_id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{uid}/group_memberships/{gmid}.json").set("uid", user_id).set("gmid", group_membership_id)), this.handleStatus()));
    }

    public List<GroupMembership> setGroupMembershipAsDefault(long user_id, GroupMembership groupMembership) {
        Zendesk.checkHasId(groupMembership);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{uid}/group_memberships/{gmid}/make_default.json").set("uid", user_id).set("gmid", groupMembership.getId()), JSON, this.json(Collections.singletonMap("group_memberships", groupMembership))), this.handleList(GroupMembership.class, "results")));
    }

    public Iterable<Forum> getForums() {
        return new PagedIterable<Forum>(this.cnst("/forums.json"), this.handleList(Forum.class, "forums"));
    }

    public List<Forum> getForums(long category_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/categories/{id}/forums.json").set("id", category_id)), this.handleList(Forum.class, "forums")));
    }

    public Forum getForum(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/forums/{id}.json").set("id", id)), this.handle(Forum.class, "forum", new Class[0])));
    }

    public Forum createForum(Forum forum) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/forums.json"), JSON, this.json(Collections.singletonMap("forum", forum))), this.handle(Forum.class, "forum", new Class[0])));
    }

    public Forum updateForum(Forum forum) {
        this.checkHasId(forum);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/forums/{id}.json").set("id", forum.getId()), JSON, this.json(Collections.singletonMap("forum", forum))), this.handle(Forum.class, "forum", new Class[0])));
    }

    public void deleteForum(Forum forum) {
        this.checkHasId(forum);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/forums/{id}.json").set("id", forum.getId())), this.handleStatus()));
    }

    public Iterable<Topic> getTopics() {
        return new PagedIterable<Topic>(this.cnst("/topics.json"), this.handleList(Topic.class, "topics"));
    }

    public List<Topic> getTopics(long forum_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/forums/{id}/topics.json").set("id", forum_id)), this.handleList(Topic.class, "topics")));
    }

    public List<Topic> getTopicsByUser(long user_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{id}/topics.json").set("id", user_id)), this.handleList(Topic.class, "topics")));
    }

    public Topic getTopic(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/topics/{id}.json").set("id", id)), this.handle(Topic.class, "topic", new Class[0])));
    }

    public Topic createTopic(Topic topic) {
        this.checkHasId(topic);
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/topics.json"), JSON, this.json(Collections.singletonMap("topic", topic))), this.handle(Topic.class, "topic", new Class[0])));
    }

    public Topic importTopic(Topic topic) {
        this.checkHasId(topic);
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/import/topics.json"), JSON, this.json(Collections.singletonMap("topic", topic))), this.handle(Topic.class, "topic", new Class[0])));
    }

    public List<Topic> getTopics(long id, long ... ids) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/topics/show_many.json{?ids}").set("ids", Zendesk.idArray(id, ids))), this.handleList(Topic.class, "topics")));
    }

    public Topic updateTopic(Topic topic) {
        this.checkHasId(topic);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/topics/{id}.json").set("id", topic.getId()), JSON, this.json(Collections.singletonMap("topic", topic))), this.handle(Topic.class, "topic", new Class[0])));
    }

    public void deleteTopic(Topic topic) {
        this.checkHasId(topic);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/topics/{id}.json").set("id", topic.getId())), this.handleStatus()));
    }

    public List<OrganizationMembership> getOrganizationMembershipByUser(long user_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{user_id}/organization_memberships.json").set("user_id", user_id)), this.handleList(OrganizationMembership.class, "organization_memberships")));
    }

    public OrganizationMembership getGroupOrganization(long user_id, long organization_membership_id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/users/{uid}/organization_memberships/{oid}.json").set("uid", user_id).set("oid", organization_membership_id)), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public OrganizationMembership createOrganizationMembership(long user_id, OrganizationMembership organizationMembership) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/users/{id}/organization_memberships.json").set("id", user_id), JSON, this.json(Collections.singletonMap("organization_membership", organizationMembership))), this.handle(OrganizationMembership.class, "organization_membership", new Class[0])));
    }

    public void deleteOrganizationMembership(long user_id, OrganizationMembership organizationMembership) {
        Zendesk.checkHasId(organizationMembership);
        this.deleteOrganizationMembership(user_id, organizationMembership.getId());
    }

    public void deleteOrganizationMembership(long user_id, long organization_membership_id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/users/{uid}/organization_memberships/{oid}.json").set("uid", user_id).set("oid", organization_membership_id)), this.handleStatus()));
    }

    public List<OrganizationMembership> setOrganizationMembershipAsDefault(long user_id, OrganizationMembership organizationMembership) {
        Zendesk.checkHasId(organizationMembership);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/users/{uid}/organization_memberships/{omid}/make_default.json").set("uid", user_id).set("omid", organizationMembership.getId()), JSON, this.json(Collections.singletonMap("organization_memberships", organizationMembership))), this.handleList(OrganizationMembership.class, "results")));
    }

    public Iterable<SearchResultEntity> getSearchResults(String query) {
        return new PagedIterable<SearchResultEntity>(this.tmpl("/search.json{?query}").set("query", query), this.handleSearchList("results"));
    }

    public <T extends SearchResultEntity> Iterable<T> getSearchResults(Class<T> type, String query) {
        return this.getSearchResults(type, query, null);
    }

    public <T extends SearchResultEntity> Iterable<T> getSearchResults(Class<T> type, String query, String params) {
        String typeName = null;
        for (Map.Entry<String, Class<? extends SearchResultEntity>> entry : searchResultTypes.entrySet()) {
            if (!type.equals(entry.getValue())) continue;
            typeName = entry.getKey();
            break;
        }
        if (typeName == null) {
            return Collections.emptyList();
        }
        return new PagedIterable(this.tmpl("/search.json{?query,params}").set("query", query + "+type:" + typeName).set("params", params), this.handleList(type, "results"));
    }

    public void notifyApp(String json) {
        Zendesk.complete(this.submit(this.req("POST", this.cnst("/apps/notify.json"), JSON, json.getBytes()), this.handleStatus()));
    }

    public void updateInstallation(int id, String json) {
        Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/apps/installations/{id}.json").set("id", id), JSON, json.getBytes()), this.handleStatus()));
    }

    public Iterable<SatisfactionRating> getSatisfactionRatings() {
        return new PagedIterable<SatisfactionRating>(this.cnst("/satisfaction_ratings.json"), this.handleList(SatisfactionRating.class, "satisfaction_ratings"));
    }

    public SatisfactionRating getSatisfactionRating(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/satisfaction_ratings/{id}.json").set("id", id)), this.handle(SatisfactionRating.class, "satisfaction_rating", new Class[0])));
    }

    public SatisfactionRating createSatisfactionRating(long ticketId, SatisfactionRating satisfactionRating) {
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/tickets/{ticketId}/satisfaction_rating.json").set("ticketId", ticketId), JSON, this.json(Collections.singletonMap("satisfaction_rating", satisfactionRating))), this.handle(SatisfactionRating.class, "satisfaction_rating", new Class[0])));
    }

    public SatisfactionRating createSatisfactionRating(Ticket ticket, SatisfactionRating satisfactionRating) {
        return this.createSatisfactionRating(ticket.getId(), satisfactionRating);
    }

    public Iterable<Article> getArticles() {
        return new PagedIterable<Article>(this.cnst("/help_center/articles.json"), this.handleList(Article.class, "articles"));
    }

    public Iterable<Article> getArticles(Category category) {
        Zendesk.checkHasId(category);
        return new PagedIterable<Article>(this.tmpl("/help_center/categories/{id}/articles.json").set("id", category.getId()), this.handleList(Article.class, "articles"));
    }

    public Iterable<Article> getArticlesIncrementally(Date startTime) {
        return new PagedIterable<Article>(this.tmpl("/help_center/incremental/articles.json{?start_time}").set("start_time", Zendesk.msToSeconds(startTime.getTime())), this.handleIncrementalList(Article.class, "articles"));
    }

    public List<Article> getArticlesFromPage(int page) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/articles.json?page={page}").set("page", page)), this.handleList(Article.class, "articles")));
    }

    public Article getArticle(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/articles/{id}.json").set("id", id)), this.handle(Article.class, "article", new Class[0])));
    }

    public Iterable<Translation> getArticleTranslations(Long articleId) {
        return new PagedIterable<Translation>(this.tmpl("/help_center/articles/{articleId}/translations.json").set("articleId", articleId), this.handleList(Translation.class, "translations"));
    }

    public Article createArticle(Article article) {
        Zendesk.checkHasSectionId(article);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/sections/{id}/articles.json").set("id", article.getSectionId()), JSON, this.json(Collections.singletonMap("article", article))), this.handle(Article.class, "article", new Class[0])));
    }

    public Article updateArticle(Article article) {
        Zendesk.checkHasId(article);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/articles/{id}.json").set("id", article.getId()), JSON, this.json(Collections.singletonMap("article", article))), this.handle(Article.class, "article", new Class[0])));
    }

    public Translation createArticleTranslation(Long articleId, Translation translation) {
        Zendesk.checkHasArticleId(articleId);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/articles/{id}/translations.json").set("id", articleId), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Translation updateArticleTranslation(Long articleId, String locale, Translation translation) {
        Zendesk.checkHasId(translation);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/articles/{id}/translations/{locale}.json").set("id", articleId).set("locale", locale), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public void deleteArticle(Article article) {
        Zendesk.checkHasId(article);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/articles/{id}.json").set("id", article.getId())), this.handleStatus()));
    }

    public void deleteArticleAttachment(ArticleAttachments attachment) {
        Zendesk.checkHasId(attachment);
        this.deleteArticleAttachment(attachment.getId());
    }

    public void deleteArticleAttachment(long id) {
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/articles/attachments/{id}.json").set("id", id)), this.handleStatus()));
    }

    public Iterable<Category> getCategories() {
        return new PagedIterable<Category>(this.cnst("/help_center/categories.json"), this.handleList(Category.class, "categories"));
    }

    public Category getCategory(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/categories/{id}.json").set("id", id)), this.handle(Category.class, "category", new Class[0])));
    }

    public Iterable<Translation> getCategoryTranslations(Long categoryId) {
        return new PagedIterable<Translation>(this.tmpl("/help_center/categories/{categoryId}/translations.json").set("categoryId", categoryId), this.handleList(Translation.class, "translations"));
    }

    public Category createCategory(Category category) {
        return Zendesk.complete(this.submit(this.req("POST", this.cnst("/help_center/categories.json"), JSON, this.json(Collections.singletonMap("category", category))), this.handle(Category.class, "category", new Class[0])));
    }

    public Category updateCategory(Category category) {
        Zendesk.checkHasId(category);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/categories/{id}.json").set("id", category.getId()), JSON, this.json(Collections.singletonMap("category", category))), this.handle(Category.class, "category", new Class[0])));
    }

    public Translation createCategoryTranslation(Long categoryId, Translation translation) {
        Zendesk.checkHasCategoryId(categoryId);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/categories/{id}/translation.json").set("id", categoryId), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Translation updateCategoryTranslation(Long categoryId, String locale, Translation translation) {
        Zendesk.checkHasId(translation);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/categories/{id}/translations/{locale}.json").set("id", categoryId).set("locale", locale), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public void deleteCategory(Category category) {
        Zendesk.checkHasId(category);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/categories/{id}.json").set("id", category.getId())), this.handleStatus()));
    }

    public Iterable<Section> getSections() {
        return new PagedIterable<Section>(this.cnst("/help_center/sections.json"), this.handleList(Section.class, "sections"));
    }

    public Iterable<Section> getSections(Category category) {
        Zendesk.checkHasId(category);
        return new PagedIterable<Section>(this.tmpl("/help_center/categories/{id}/sections.json").set("id", category.getId()), this.handleList(Section.class, "sections"));
    }

    public Section getSection(long id) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/help_center/sections/{id}.json").set("id", id)), this.handle(Section.class, "section", new Class[0])));
    }

    public Iterable<Translation> getSectionTranslations(Long sectionId) {
        return new PagedIterable<Translation>(this.tmpl("/help_center/sections/{sectionId}/translations.json").set("sectionId", sectionId), this.handleList(Translation.class, "translations"));
    }

    public Section createSection(Section section) {
        Zendesk.checkHasCategoryId(section);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/categories/{id}/sections.json").set("id", section.getCategoryId()), JSON, this.json(Collections.singletonMap("section", section))), this.handle(Section.class, "section", new Class[0])));
    }

    public Section updateSection(Section section) {
        Zendesk.checkHasId(section);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/sections/{id}.json").set("id", section.getId()), JSON, this.json(Collections.singletonMap("section", section))), this.handle(Section.class, "section", new Class[0])));
    }

    public Translation createSectionTranslation(Long sectionId, Translation translation) {
        Zendesk.checkHasSectionId(sectionId);
        return Zendesk.complete(this.submit(this.req("POST", this.tmpl("/help_center/sections/{id}/translation.json").set("id", sectionId), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public Translation updateSectionTranslation(Long sectionId, String locale, Translation translation) {
        Zendesk.checkHasId(translation);
        return Zendesk.complete(this.submit(this.req("PUT", this.tmpl("/help_center/sections/{id}/translations/{locale}.json").set("id", sectionId).set("locale", locale), JSON, this.json(Collections.singletonMap("translation", translation))), this.handle(Translation.class, "translation", new Class[0])));
    }

    public void deleteSection(Section section) {
        Zendesk.checkHasId(section);
        Zendesk.complete(this.submit(this.req("DELETE", this.tmpl("/help_center/sections/{id}.json").set("id", section.getId())), this.handleStatus()));
    }

    public Iterable<Subscription> getUserSubscriptions(User user) {
        Zendesk.checkHasId(user);
        return this.getUserSubscriptions(user.getId());
    }

    public Iterable<Subscription> getUserSubscriptions(Long userId) {
        return new PagedIterable<Subscription>(this.tmpl("/help_center/users/{userId}/subscriptions.json").set("userId", userId), this.handleList(Subscription.class, "subscriptions"));
    }

    public Iterable<Subscription> getArticleSubscriptions(Long articleId) {
        return this.getArticleSubscriptions(articleId, null);
    }

    public Iterable<Subscription> getArticleSubscriptions(Long articleId, String locale) {
        return new PagedIterable<Subscription>(this.tmpl("/help_center{/locale}/articles/{articleId}/subscriptions.json").set("locale", locale).set("articleId", articleId), this.handleList(Subscription.class, "subscriptions"));
    }

    public Iterable<Subscription> getSectionSubscriptions(Long sectionId) {
        return this.getSectionSubscriptions(sectionId, null);
    }

    public Iterable<Subscription> getSectionSubscriptions(Long sectionId, String locale) {
        return new PagedIterable<Subscription>(this.tmpl("/help_center{/locale}/sections/{sectionId}/subscriptions.json").set("locale", locale).set("sectionId", sectionId), this.handleList(Subscription.class, "subscriptions"));
    }

    public Iterable<Schedule> getSchedules() {
        return Zendesk.complete(this.submit(this.req("GET", this.cnst("/business_hours/schedules.json")), this.handleList(Schedule.class, "schedules")));
    }

    public Schedule getSchedule(Schedule schedule) {
        Zendesk.checkHasId(schedule);
        return this.getSchedule(schedule.getId());
    }

    public Schedule getSchedule(Long scheduleId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/business_hours/schedules/{id}.json").set("id", scheduleId)), this.handle(Schedule.class, "schedule", new Class[0])));
    }

    public Iterable<Holiday> getHolidaysForSchedule(Schedule schedule) {
        Zendesk.checkHasId(schedule);
        return this.getHolidaysForSchedule(schedule.getId());
    }

    public Iterable<Holiday> getHolidaysForSchedule(Long scheduleId) {
        return Zendesk.complete(this.submit(this.req("GET", this.tmpl("/business_hours/schedules/{id}/holidays.json").set("id", scheduleId)), this.handleList(Holiday.class, "holidays")));
    }

    private byte[] json(Object object) {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw new ZendeskException(e.getMessage(), e);
        }
    }

    private <T> ListenableFuture<T> submit(org.asynchttpclient.Request request, ZendeskAsyncCompletionHandler<T> handler) {
        if (this.logger.isDebugEnabled()) {
            if (request.getStringData() != null) {
                this.logger.debug("Request {} {}\n{}", new Object[]{request.getMethod(), request.getUrl(), request.getStringData()});
            } else if (request.getByteData() != null) {
                this.logger.debug("Request {} {} {} {} bytes", new Object[]{request.getMethod(), request.getUrl(), request.getHeaders().get("Content-type"), request.getByteData().length});
            } else {
                this.logger.debug("Request {} {}", (Object)request.getMethod(), (Object)request.getUrl());
            }
        }
        return this.client.executeRequest(request, handler);
    }

    private org.asynchttpclient.Request req(String method, Uri template) {
        return this.req(method, template.toString());
    }

    private org.asynchttpclient.Request req(String method, String url) {
        RequestBuilder builder = new RequestBuilder(method);
        if (this.realm != null) {
            builder.setRealm(this.realm);
        } else {
            builder.addHeader((CharSequence)"Authorization", "Bearer " + this.oauthToken);
        }
        builder.setUrl(RESTRICTED_PATTERN.matcher(url).replaceAll("+"));
        return builder.build();
    }

    private org.asynchttpclient.Request req(String method, Uri template, String contentType, byte[] body) {
        RequestBuilder builder = new RequestBuilder(method);
        if (this.realm != null) {
            builder.setRealm(this.realm);
        } else {
            builder.addHeader((CharSequence)"Authorization", "Bearer " + this.oauthToken);
        }
        builder.setUrl(RESTRICTED_PATTERN.matcher(template.toString()).replaceAll("+"));
        builder.addHeader((CharSequence)"Content-type", contentType);
        builder.setBody(body);
        return builder.build();
    }

    protected ZendeskAsyncCompletionHandler<Void> handleStatus() {
        return new ZendeskAsyncCompletionHandler<Void>(){

            public Void onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    return null;
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected <T> ZendeskAsyncCompletionHandler<T> handle(final Class<T> clazz) {
        return new ZendeskAsyncCompletionHandler<T>(){

            public T onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    return Zendesk.this.mapper.reader(clazz).readValue(response.getResponseBodyAsStream());
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                if (response.getStatusCode() == 404) {
                    return null;
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected <T> ZendeskAsyncCompletionHandler<T> handle(Class<T> clazz, String name, Class ... typeParams) {
        return new BasicAsyncCompletionHandler(clazz, name, typeParams);
    }

    protected <T> ZendeskAsyncCompletionHandler<JobStatus<T>> handleJobStatus(final Class<T> resultClass) {
        return new BasicAsyncCompletionHandler<JobStatus<T>>((Class)JobStatus.class, "job_status", new Class[]{resultClass}){

            @Override
            public JobStatus<T> onCompleted(Response response) throws Exception {
                JobStatus result = (JobStatus)super.onCompleted(response);
                result.setResultsClass(resultClass);
                return result;
            }
        };
    }

    protected <T> PagedAsyncCompletionHandler<List<T>> handleList(Class<T> clazz, String name) {
        return new PagedAsyncListCompletionHandler<T>(clazz, name);
    }

    protected <T> PagedAsyncCompletionHandler<List<T>> handleIncrementalList(Class<T> clazz, String name) {
        return new PagedAsyncListCompletionHandler<T>((Class)clazz, name){

            @Override
            public void setPagedProperties(JsonNode responseNode, Class<?> clazz) {
                JsonNode node = responseNode.get(Zendesk.NEXT_PAGE);
                if (node == null) {
                    if (Zendesk.this.logger.isDebugEnabled()) {
                        Zendesk.this.logger.debug("next_page property not found, pagination not supported" + (clazz != null ? " for " + clazz.getName() : ""));
                    }
                    this.setNextPage(null);
                    return;
                }
                JsonNode endTimeNode = responseNode.get(Zendesk.END_TIME);
                if (endTimeNode == null || endTimeNode.asLong() == 0L) {
                    if (Zendesk.this.logger.isDebugEnabled()) {
                        Zendesk.this.logger.debug("end_time property not found, incremental export pagination not supported" + (clazz != null ? " for " + clazz.getName() : ""));
                    }
                    this.setNextPage(null);
                    return;
                }
                if (TimeUnit.SECONDS.toMillis(endTimeNode.asLong()) > System.currentTimeMillis() - FIVE_MINUTES) {
                    this.setNextPage(null);
                } else {
                    JsonNode countNode = responseNode.get(Zendesk.COUNT);
                    if (countNode == null) {
                        if (Zendesk.this.logger.isDebugEnabled()) {
                            Zendesk.this.logger.debug("count property not found, incremental export pagination not supported" + (clazz != null ? " for " + clazz.getName() : ""));
                        }
                        this.setNextPage(null);
                        return;
                    }
                    if (countNode.asInt() < 1000) {
                        this.setNextPage(null);
                    } else {
                        this.setNextPage(node.asText());
                    }
                }
            }
        };
    }

    protected PagedAsyncCompletionHandler<List<SearchResultEntity>> handleSearchList(final String name) {
        return new PagedAsyncCompletionHandler<List<SearchResultEntity>>(){

            public List<SearchResultEntity> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    JsonNode responseNode = Zendesk.this.mapper.readTree(response.getResponseBodyAsStream()).get(name);
                    this.setPagedProperties(responseNode, null);
                    ArrayList<SearchResultEntity> values = new ArrayList<SearchResultEntity>();
                    for (JsonNode node : responseNode) {
                        Class clazz = (Class)searchResultTypes.get(node.get("result_type").asText());
                        if (clazz == null) continue;
                        values.add((SearchResultEntity)Zendesk.this.mapper.convertValue((Object)node, clazz));
                    }
                    return values;
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected PagedAsyncCompletionHandler<List<Target>> handleTargetList(final String name) {
        return new PagedAsyncCompletionHandler<List<Target>>(){

            public List<Target> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    JsonNode responseNode = Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes());
                    this.setPagedProperties(responseNode, null);
                    ArrayList<Target> values = new ArrayList<Target>();
                    for (JsonNode node : responseNode.get(name)) {
                        Class clazz = (Class)targetTypes.get(node.get("type").asText());
                        if (clazz == null) continue;
                        values.add((Target)Zendesk.this.mapper.convertValue((Object)node, clazz));
                    }
                    return values;
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    protected PagedAsyncCompletionHandler<List<ArticleAttachments>> handleArticleAttachmentsList(final String name) {
        return new PagedAsyncCompletionHandler<List<ArticleAttachments>>(){

            public List<ArticleAttachments> onCompleted(Response response) throws Exception {
                Zendesk.this.logResponse(response);
                if (Zendesk.this.isStatus2xx(response)) {
                    JsonNode responseNode = Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes());
                    ArrayList<ArticleAttachments> values = new ArrayList<ArticleAttachments>();
                    for (JsonNode node : responseNode.get(name)) {
                        values.add((ArticleAttachments)Zendesk.this.mapper.convertValue((Object)node, ArticleAttachments.class));
                    }
                    return values;
                }
                if (Zendesk.this.isRateLimitResponse(response)) {
                    throw new ZendeskResponseRateLimitException(response);
                }
                throw new ZendeskResponseException(response);
            }
        };
    }

    private TemplateUri tmpl(String template) {
        return new TemplateUri(this.url + template);
    }

    private Uri cnst(String template) {
        return new FixedUri(this.url + template);
    }

    private void logResponse(Response response) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Response HTTP/{} {}\n{}", new Object[]{response.getStatusCode(), response.getStatusText(), response.getResponseBody()});
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Response headers {}", (Object)response.getHeaders());
        }
    }

    private static String encodeUrl(String input) {
        try {
            return URLEncoder.encode(input, UTF_8);
        }
        catch (UnsupportedEncodingException impossible) {
            return input;
        }
    }

    private static long msToSeconds(long millis) {
        return TimeUnit.MILLISECONDS.toSeconds(millis);
    }

    private boolean isStatus2xx(Response response) {
        return response.getStatusCode() / 100 == 2;
    }

    private boolean isRateLimitResponse(Response response) {
        return response.getStatusCode() == 429;
    }

    private static <T> T complete(ListenableFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            throw new ZendeskException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ZendeskException) {
                if (e.getCause() instanceof ZendeskResponseRateLimitException) {
                    throw new ZendeskResponseRateLimitException((ZendeskResponseRateLimitException)e.getCause());
                }
                if (e.getCause() instanceof ZendeskResponseException) {
                    throw new ZendeskResponseException((ZendeskResponseException)e.getCause());
                }
                throw new ZendeskException(e.getCause());
            }
            throw new ZendeskException(e.getMessage(), e);
        }
    }

    private static void checkHasId(Ticket ticket) {
        if (ticket.getId() == null) {
            throw new IllegalArgumentException("Ticket requires id");
        }
    }

    private static void checkHasId(Request request) {
        if (request.getId() == null) {
            throw new IllegalArgumentException("Request requires id");
        }
    }

    private static void checkHasId(Audit audit) {
        if (audit.getId() == null) {
            throw new IllegalArgumentException("Audit requires id");
        }
    }

    private static void checkHasId(Comment comment) {
        if (comment.getId() == null) {
            throw new IllegalArgumentException("Comment requires id");
        }
    }

    private static void checkHasId(Field field) {
        if (field.getId() == null) {
            throw new IllegalArgumentException("Field requires id");
        }
    }

    private static void checkHasId(Attachment attachment) {
        if (attachment.getId() == null) {
            throw new IllegalArgumentException("Attachment requires id");
        }
    }

    private static void checkHasId(ArticleAttachments attachments) {
        if (attachments.getId() == null) {
            throw new IllegalArgumentException("Attachment requires id");
        }
    }

    private static void checkHasId(User user) {
        if (user.getId() == null) {
            throw new IllegalArgumentException("User requires id");
        }
    }

    private static void checkHasId(Identity identity) {
        if (identity.getId() == null) {
            throw new IllegalArgumentException("Identity requires id");
        }
    }

    private static void checkHasId(Organization organization) {
        if (organization.getId() == null) {
            throw new IllegalArgumentException("Organization requires id");
        }
    }

    private static void checkHasId(Group group) {
        if (group.getId() == null) {
            throw new IllegalArgumentException("Group requires id");
        }
    }

    private static void checkHasId(GroupMembership groupMembership) {
        if (groupMembership.getId() == null) {
            throw new IllegalArgumentException("GroupMembership requires id");
        }
    }

    private void checkHasId(Forum forum) {
        if (forum.getId() == null) {
            throw new IllegalArgumentException("Forum requires id");
        }
    }

    private void checkHasId(Topic topic) {
        if (topic.getId() == null) {
            throw new IllegalArgumentException("Topic requires id");
        }
    }

    private static void checkHasId(OrganizationMembership organizationMembership) {
        if (organizationMembership.getId() == null) {
            throw new IllegalArgumentException("OrganizationMembership requires id");
        }
    }

    private static void checkHasId(Article article) {
        if (article.getId() == null) {
            throw new IllegalArgumentException("Article requires id");
        }
    }

    private static void checkHasSectionId(Article article) {
        if (article.getSectionId() == null) {
            throw new IllegalArgumentException("Article requires section id");
        }
    }

    private static void checkHasArticleId(Long articleId) {
        if (articleId == null) {
            throw new IllegalArgumentException("Translation requires article id");
        }
    }

    private static void checkHasSectionId(Long articleId) {
        if (articleId == null) {
            throw new IllegalArgumentException("Translation requires section id");
        }
    }

    private static void checkHasCategoryId(Long articleId) {
        if (articleId == null) {
            throw new IllegalArgumentException("Translation requires category id");
        }
    }

    private static void checkHasCategoryId(Section section) {
        if (section.getCategoryId() == null) {
            throw new IllegalArgumentException("Section requires category id");
        }
    }

    private static void checkHasId(Category category) {
        if (category.getId() == null) {
            throw new IllegalArgumentException("Category requires id");
        }
    }

    private static void checkHasId(Section section) {
        if (section.getId() == null) {
            throw new IllegalArgumentException("Section requires id");
        }
    }

    private static void checkHasId(SuspendedTicket ticket) {
        if (ticket == null || ticket.getId() == null) {
            throw new IllegalArgumentException("SuspendedTicket requires id");
        }
    }

    private static void checkHasId(Translation translation) {
        if (translation.getId() == null) {
            throw new IllegalArgumentException("Translation requires id");
        }
    }

    private static void checkHasId(Schedule schedule) {
        if (schedule == null || schedule.getId() == null) {
            throw new IllegalArgumentException("Schedule requires id");
        }
    }

    private static void checkHasId(Holiday holiday) {
        if (holiday == null || holiday.getId() == null) {
            throw new IllegalArgumentException("Holiday requires id");
        }
    }

    private static void checkHasToken(Attachment.Upload upload) {
        if (upload.getToken() == null) {
            throw new IllegalArgumentException("Upload requires token");
        }
    }

    private static List<Long> idArray(long id, long ... ids) {
        ArrayList<Long> result = new ArrayList<Long>(ids.length + 1);
        result.add(id);
        for (long i : ids) {
            result.add(i);
        }
        return result;
    }

    private static List<String> statusArray(Status ... statuses) {
        ArrayList<String> result = new ArrayList<String>(statuses.length);
        for (Status s : statuses) {
            result.add(s.toString());
        }
        return result;
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.WRITE_ENUMS_USING_TO_STRING);
        mapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        mapper.setDateFormat((DateFormat)new ISO8601DateFormat());
        return mapper;
    }

    public static class Builder {
        private AsyncHttpClient client = null;
        private final String url;
        private String username = null;
        private String password = null;
        private String token = null;
        private String oauthToken = null;

        public Builder(String url) {
            this.url = url;
        }

        public Builder setClient(AsyncHttpClient client) {
            this.client = client;
            return this;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            if (password != null) {
                this.token = null;
                this.oauthToken = null;
            }
            return this;
        }

        public Builder setToken(String token) {
            this.token = token;
            if (token != null) {
                this.password = null;
                this.oauthToken = null;
            }
            return this;
        }

        public Builder setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
            if (oauthToken != null) {
                this.password = null;
                this.token = null;
            }
            return this;
        }

        public Builder setRetry(boolean retry) {
            return this;
        }

        public Zendesk build() {
            if (this.token != null) {
                return new Zendesk(this.client, this.url, this.username + "/token", this.token);
            }
            if (this.oauthToken != null) {
                return new Zendesk(this.client, this.url, this.oauthToken);
            }
            return new Zendesk(this.client, this.url, this.username, this.password);
        }
    }

    private class PagedIterable<T>
    implements Iterable<T> {
        private final Uri url;
        private final PagedAsyncCompletionHandler<List<T>> handler;

        private PagedIterable(Uri url, PagedAsyncCompletionHandler<List<T>> handler) {
            this.handler = handler;
            this.url = url;
        }

        @Override
        public Iterator<T> iterator() {
            return new PagedIterator(this.url);
        }

        private class PagedIterator
        implements Iterator<T> {
            private Iterator<T> current;
            private String nextPage;

            public PagedIterator(Uri url) {
                this.nextPage = url.toString();
            }

            @Override
            public boolean hasNext() {
                if (this.current == null || !this.current.hasNext()) {
                    if (this.nextPage == null || this.nextPage.equalsIgnoreCase("null")) {
                        return false;
                    }
                    List values = (List)Zendesk.complete(Zendesk.this.submit(Zendesk.this.req("GET", this.nextPage), PagedIterable.this.handler));
                    this.nextPage = PagedIterable.this.handler.getNextPage();
                    this.current = values.iterator();
                }
                return this.current.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class PagedAsyncListCompletionHandler<T>
    extends PagedAsyncCompletionHandler<List<T>> {
        private final Class<T> clazz;
        private final String name;

        public PagedAsyncListCompletionHandler(Class<T> clazz, String name) {
            this.clazz = clazz;
            this.name = name;
        }

        public List<T> onCompleted(Response response) throws Exception {
            Zendesk.this.logResponse(response);
            if (Zendesk.this.isStatus2xx(response)) {
                JsonNode responseNode = Zendesk.this.mapper.readTree(response.getResponseBodyAsBytes());
                this.setPagedProperties(responseNode, this.clazz);
                ArrayList<Object> values = new ArrayList<Object>();
                for (JsonNode node : responseNode.get(this.name)) {
                    values.add(Zendesk.this.mapper.convertValue((Object)node, this.clazz));
                }
                return values;
            }
            if (Zendesk.this.isRateLimitResponse(response)) {
                throw new ZendeskResponseRateLimitException(response);
            }
            throw new ZendeskResponseException(response);
        }
    }

    private abstract class PagedAsyncCompletionHandler<T>
    extends ZendeskAsyncCompletionHandler<T> {
        private String nextPage;

        private PagedAsyncCompletionHandler() {
        }

        public void setPagedProperties(JsonNode responseNode, Class<?> clazz) {
            JsonNode node = responseNode.get(Zendesk.NEXT_PAGE);
            if (node == null) {
                this.nextPage = null;
                if (Zendesk.this.logger.isDebugEnabled()) {
                    Zendesk.this.logger.debug("next_page property not found, pagination not supported" + (clazz != null ? " for " + clazz.getName() : ""));
                }
            } else {
                this.nextPage = node.asText();
            }
        }

        public String getNextPage() {
            return this.nextPage;
        }

        public void setNextPage(String nextPage) {
            this.nextPage = nextPage;
        }
    }

    private class BasicAsyncCompletionHandler<T>
    extends ZendeskAsyncCompletionHandler<T> {
        private final Class<T> clazz;
        private final String name;
        private final Class[] typeParams;

        public BasicAsyncCompletionHandler(Class clazz, String name, Class ... typeParams) {
            this.clazz = clazz;
            this.name = name;
            this.typeParams = typeParams;
        }

        public T onCompleted(Response response) throws Exception {
            Zendesk.this.logResponse(response);
            if (Zendesk.this.isStatus2xx(response)) {
                if (this.typeParams.length > 0) {
                    JavaType type = Zendesk.this.mapper.getTypeFactory().constructParametricType(this.clazz, this.typeParams);
                    return (T)Zendesk.this.mapper.convertValue((Object)Zendesk.this.mapper.readTree(response.getResponseBodyAsStream()).get(this.name), type);
                }
                return (T)Zendesk.this.mapper.convertValue((Object)Zendesk.this.mapper.readTree(response.getResponseBodyAsStream()).get(this.name), this.clazz);
            }
            if (Zendesk.this.isRateLimitResponse(response)) {
                throw new ZendeskResponseRateLimitException(response);
            }
            if (response.getStatusCode() == 404) {
                return null;
            }
            throw new ZendeskResponseException(response);
        }
    }

    private static abstract class ZendeskAsyncCompletionHandler<T>
    extends AsyncCompletionHandler<T> {
        private ZendeskAsyncCompletionHandler() {
        }

        public void onThrowable(Throwable t) {
            if (t instanceof IOException) {
                throw new ZendeskException(t);
            }
            super.onThrowable(t);
        }
    }
}

