/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2.model;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JsonDeserialize(using=ActionDeserializer.class)
public class Action {
    private String field;
    private List<String> value;

    public Action() {
    }

    public Action(String field, String ... values) {
        this.field = field;
        this.value = Arrays.asList(values);
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public List<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Action");
        sb.append("{field=").append(this.field);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ActionDeserializer
    extends JsonDeserializer<Action> {
        ActionDeserializer() {
        }

        public Action deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
            JsonNode root = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            Action action = new Action();
            action.field = root.get("field").asText();
            JsonNode valueNode = root.get("value");
            if (valueNode.isArray()) {
                ArrayList<String> values = new ArrayList<String>(valueNode.size());
                for (JsonNode node : valueNode) {
                    values.add(node.asText());
                }
                action.value = values;
            } else {
                action.value = Collections.singletonList(valueNode.asText());
            }
            return action;
        }
    }
}

