/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Collaborator;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.Role;
import org.zendesk.client.v2.model.SearchResultEntity;
import org.zendesk.client.v2.model.TicketRestriction;

public class User
extends Collaborator
implements SearchResultEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String url;
    private String externalId;
    private String alias;
    private Date createdAt;
    private Date updatedAt;
    private Boolean active;
    private Boolean verified;
    private Boolean shared;
    private Long localeId;
    private String locale;
    private String timeZone;
    private Date lastLoginAt;
    private String phone;
    private Boolean restrictedAgent;
    private String signature;
    private String details;
    private String notes;
    private Long organizationId;
    private Role role;
    private Long customRoleId;
    private Boolean moderator;
    private TicketRestriction ticketRestriction;
    private Boolean onlyPrivateComments;
    private List<String> tags;
    private Boolean suspended;
    private Attachment photo;
    private List<Identity> identities;
    private String remotePhotoUrl;
    private Map<String, Object> userFields;
    private Boolean chatOnly;
    private Boolean sharedPhoneNumber;
    private Long defaultGroupId;
    private Long roleType;
    private Boolean twoFactorAuthEnabled;
    private Boolean reportCsv;

    public User() {
    }

    public User(Boolean verified, String name, String email) {
        super(name, email);
        this.verified = verified;
    }

    public User(Boolean verified, String name, List<Identity> identities) {
        super(name);
        this.verified = verified;
        this.identities = identities;
    }

    public User(Boolean verified, String name, Identity ... identities) {
        super(name);
        this.verified = verified;
        this.identities = new ArrayList<Identity>(Arrays.asList(identities));
    }

    public User(String name, String email) {
        super(name, email);
    }

    public User(String name, List<Identity> identities) {
        super(name);
        this.identities = identities;
    }

    public User(String name, Identity ... identities) {
        super(name);
        this.identities = new ArrayList<Identity>(Arrays.asList(identities));
    }

    public List<Identity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(List<Identity> identities) {
        this.identities = identities;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @JsonProperty(value="created_at")
    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="custom_role_id")
    public Long getCustomRoleId() {
        return this.customRoleId;
    }

    public void setCustomRoleId(Long customRoleId) {
        this.customRoleId = customRoleId;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @JsonProperty(value="last_login_at")
    public Date getLastLoginAt() {
        return this.lastLoginAt;
    }

    public void setLastLoginAt(Date lastLoginAt) {
        this.lastLoginAt = lastLoginAt;
    }

    @JsonProperty(value="locale_id")
    public Long getLocaleId() {
        return this.localeId;
    }

    public void setLocaleId(Long localeId) {
        this.localeId = localeId;
    }

    @JsonProperty(value="locale")
    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public Boolean getModerator() {
        return this.moderator;
    }

    public void setModerator(Boolean moderator) {
        this.moderator = moderator;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @JsonProperty(value="only_private_comments")
    public Boolean getOnlyPrivateComments() {
        return this.onlyPrivateComments;
    }

    public void setOnlyPrivateComments(Boolean onlyPrivateComments) {
        this.onlyPrivateComments = onlyPrivateComments;
    }

    @JsonProperty(value="organization_id")
    public Long getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Attachment getPhoto() {
        return this.photo;
    }

    public void setPhoto(Attachment photo) {
        this.photo = photo;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public Boolean getShared() {
        return this.shared;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="ticket_restriction")
    public TicketRestriction getTicketRestriction() {
        return this.ticketRestriction;
    }

    public void setTicketRestriction(TicketRestriction ticketRestriction) {
        this.ticketRestriction = ticketRestriction;
    }

    @JsonProperty(value="time_zone")
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    @JsonProperty(value="updated_at")
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="user_fields")
    public Map<String, Object> getUserFields() {
        return this.userFields;
    }

    public void setUserFields(Map<String, Object> userFields) {
        this.userFields = userFields;
    }

    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(Boolean verified) {
        this.verified = verified;
    }

    @JsonProperty(value="remote_photo_url")
    public String getRemotePhotoUrl() {
        return this.remotePhotoUrl;
    }

    public void setRemotePhotoUrl(String remotePhotoUrl) {
        this.remotePhotoUrl = remotePhotoUrl;
    }

    @JsonProperty(value="restricted_agent")
    public Boolean getRestrictedAgent() {
        return this.restrictedAgent;
    }

    public void setRestrictedAgent(Boolean restrictedAgent) {
        this.restrictedAgent = restrictedAgent;
    }

    @JsonProperty(value="chat_only")
    public Boolean getChatOnly() {
        return this.chatOnly;
    }

    public void setChatOnly(Boolean chatOnly) {
        this.chatOnly = chatOnly;
    }

    @JsonProperty(value="shared_phone_number")
    public Boolean getSharedPhoneNumber() {
        return this.sharedPhoneNumber;
    }

    public void setSharedPhoneNumber(Boolean sharedPhoneNumber) {
        this.sharedPhoneNumber = sharedPhoneNumber;
    }

    @JsonProperty(value="default_group_id")
    public Long getDefaultGroupId() {
        return this.defaultGroupId;
    }

    public void setDefaultGroupId(Long defaultGroupId) {
        this.defaultGroupId = defaultGroupId;
    }

    @JsonProperty(value="role_type")
    public Long getRoleType() {
        return this.roleType;
    }

    public void setRoleType(Long roleType) {
        this.roleType = roleType;
    }

    @JsonProperty(value="two_factor_auth_enabled")
    public Boolean getTwoFactorAuthEnabled() {
        return this.twoFactorAuthEnabled;
    }

    public void setTwoFactorAuthEnabled(Boolean twoFactorAuthEnabled) {
        this.twoFactorAuthEnabled = twoFactorAuthEnabled;
    }

    @JsonProperty(value="report_csv")
    public Boolean getReportCsv() {
        return this.reportCsv;
    }

    public void setReportCsv(Boolean reportCsv) {
        this.reportCsv = reportCsv;
    }
}

