/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.ContinuationGroup;
import com.cloudbees.groovy.cps.impl.CpsClosure;
import com.cloudbees.groovy.cps.impl.ReferenceStackTrace;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import java.lang.reflect.Constructor;
import java.util.List;

public class ClosureBlock
implements Block {
    private final List<String> parameters;
    private final List<Class> parameterTypes;
    private final Block body;
    private final Class<? extends CpsClosure> closureType;
    private final SourceLocation loc;
    private static final long serialVersionUID = 1L;

    public ClosureBlock(SourceLocation loc, List<Class> parameterTypes, List<String> parameters, Block body, Class<? extends CpsClosure> closureType) {
        this.loc = loc;
        this.parameterTypes = parameterTypes;
        this.parameters = parameters;
        this.body = body;
        this.closureType = closureType;
    }

    private Class<? extends CpsClosure> closureType() {
        if (this.closureType == null) {
            return CpsClosure.class;
        }
        return this.closureType;
    }

    @Override
    public Next eval(Env e, Continuation k) {
        try {
            Constructor<? extends CpsClosure> c = this.closureType().getConstructor(Object.class, Object.class, List.class, Block.class, Env.class);
            CpsClosure closure = c.newInstance(e.closureOwner(), e.getLocalVariable("this"), this.parameters, this.body, e);
            if (this.parameterTypes != null) {
                closure.setParameterTypes(this.parameterTypes);
            }
            return k.receive((Object)closure);
        }
        catch (Exception x) {
            return new ContinuationGroup(){}.throwException(e, x, this.loc, new ReferenceStackTrace());
        }
    }
}

