/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import java.io.Serializable;

public final class MethodLocation
implements Serializable {
    private final String declaringClass;
    private final String methodName;
    private final String fileName;
    public static final MethodLocation UNKNOWN = new MethodLocation("Unknown", "Unknown", "Unknown");
    private static final long serialVersionUID = 1L;

    public MethodLocation(Class clazz, String methodName) {
        this(clazz.getName(), methodName, clazz.getSimpleName());
    }

    public MethodLocation(String declaringClass, String methodName, String fileName) {
        this.declaringClass = declaringClass;
        this.methodName = methodName;
        assert (!fileName.contains(":")) : "possible JENKINS-57085 violation in " + fileName;
        this.fileName = fileName;
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public StackTraceElement toStackTrace(int lineNumber) {
        return new StackTraceElement(this.declaringClass, this.methodName, this.fileName, lineNumber);
    }
}

