/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.CpsDefaultGroovyMethods;
import com.cloudbees.groovy.cps.CpsDefaultGroovyStaticMethods;
import com.cloudbees.groovy.cps.CpsStringGroovyMethods;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Envs;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.WorkflowTransformed;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.SuspendBlock;
import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import groovy.lang.Script;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.runtime.GroovyCategorySupport;

public class Continuable
implements Serializable {
    public static final List<Class> categories = ImmutableList.of(CpsDefaultGroovyMethods.class, CpsDefaultGroovyStaticMethods.class, CpsStringGroovyMethods.class);
    private Env e;
    private Continuation k;
    private static final long serialVersionUID = 1L;
    public static final StackTraceElement SEPARATOR_STACK_ELEMENT = new StackTraceElement("___cps", "transform___", null, -2);

    public Continuable(Continuable src) {
        this.e = src.e;
        this.k = src.k;
    }

    public Continuable(Next n) {
        this.e = n.e;
        this.k = n;
    }

    public Continuable(Block block) {
        this(block, Envs.empty());
    }

    public Continuable(Block block, Env e) {
        this.e = e;
        this.k = new Next(block, e, Continuation.HALT);
    }

    public Continuable(Script cpsTransformedScript) {
        this(cpsTransformedScript, null);
    }

    public Continuable(Script cpsTransformedScript, Env env) {
        this(cpsTransformedScript, env, Continuation.HALT);
    }

    public Continuable(Script cpsTransformedScript, Env env, Continuation k) {
        this(Continuable.wrap(cpsTransformedScript, env, k));
    }

    private static Next wrap(Script s, Env env, Continuation k) {
        try {
            Method m = s.getClass().getMethod("run", new Class[0]);
            if (!m.isAnnotationPresent(WorkflowTransformed.class)) {
                throw new IllegalArgumentException(s + " is not CPS-transformed");
            }
            s.run();
            throw new AssertionError((Object)"I'm confused if Script is CPS-transformed or not!");
        }
        catch (CpsCallableInvocation e) {
            return e.invoke(env, null, k);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void printStackTrace(PrintWriter s) {
        for (StackTraceElement t : this.getStackTrace()) {
            s.println("\tat " + t);
        }
    }

    @Deprecated
    public Object run(Object arg) throws InvocationTargetException {
        return this.run0(new Outcome(arg, null)).wrapReplay();
    }

    @Deprecated
    public Object runByThrow(Throwable arg) throws InvocationTargetException {
        return this.run0(new Outcome(null, arg)).wrapReplay();
    }

    @Deprecated
    public Outcome run0(Outcome cn) {
        return this.run0(cn, categories);
    }

    public Outcome run0(final Outcome cn, List<Class> categories) {
        return (Outcome)GroovyCategorySupport.use(categories, (Closure)new Closure<Outcome>(null){

            public Outcome call() {
                Next n = cn.resumeFrom(Continuable.this.e, Continuable.this.k);
                while (n.yield == null) {
                    n = n.step();
                }
                Continuable.this.e = n.e;
                Continuable.this.k = n.k;
                return n.yield;
            }
        });
    }

    public boolean isResumable() {
        return this.k != Continuation.HALT || this.e != null;
    }

    @Deprecated
    public static Object suspend(Object v) {
        return Continuable.suspend("suspend?", v);
    }

    public static Object suspend(String methodName, Object v) {
        throw new CpsCallableInvocation(methodName, SuspendBlock.SUSPEND, null, v);
    }

    public List<StackTraceElement> getStackTrace() {
        ArrayList<StackTraceElement> r = new ArrayList<StackTraceElement>();
        if (this.e != null) {
            this.e.buildStackTraceElements(r, Integer.MAX_VALUE);
        }
        return r;
    }

    Env getE() {
        return this.e;
    }

    Continuation getK() {
        return this.k;
    }
}

