/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.green;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.green.Cond;
import com.cloudbees.groovy.cps.green.GreenThreadState;
import com.cloudbees.groovy.cps.green.GreenWorld;
import com.cloudbees.groovy.cps.green.Result;
import com.cloudbees.groovy.cps.green.ThreadTask;
import com.cloudbees.groovy.cps.impl.ConstantBlock;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.ThrowBlock;

public abstract class GreenThread
implements Runnable {
    public void start() {
        Block b;
        try {
            this.run();
            b = Block.NOOP;
        }
        catch (CpsCallableInvocation inv) {
            b = inv.asBlock();
        }
        catch (Throwable t) {
            b = new ThrowBlock(new ConstantBlock(t));
        }
        final Block bb = b;
        GreenThread.invoke(new ThreadTask(){

            @Override
            public Result eval(GreenWorld w) {
                w = w.withNewThread(new GreenThreadState(GreenThread.this, bb));
                return new Result(w, new Outcome(GreenThread.this, null), false);
            }
        });
        throw new AssertionError();
    }

    private static void invoke(ThreadTask task) {
        Continuable.suspend(task);
        throw new AssertionError();
    }

    private GreenThreadState stateAt(GreenWorld d) {
        return d.resolveThreadState(this);
    }

    public boolean isAlive() {
        GreenThread.invoke(new ThreadTask(){

            @Override
            public Result eval(GreenWorld w) {
                return new Result(w, new Outcome(!GreenThread.this.stateAt(w).isDead(), null), false);
            }
        });
        throw new AssertionError();
    }

    public static GreenThread currentThread() {
        GreenThread.invoke(new ThreadTask(){

            @Override
            public Result eval(GreenWorld w) {
                return new Result(w, new Outcome(w.currentThread().g, null), false);
            }
        });
        throw new AssertionError();
    }

    public static void monitorEnter(final Object o) {
        GreenThread.invoke(new ThreadTask(){

            @Override
            public Result eval(GreenWorld w) {
                return new Result(this.trans(w), null, false);
            }

            public GreenWorld trans(GreenWorld d) {
                GreenThreadState cur = d.currentThread();
                for (GreenThreadState t : d.threads) {
                    if (t == cur || !t.hasMonitor(o)) continue;
                    return d.with(cur.withCond(Cond.MONITOR_ENTER, o));
                }
                return d.with(cur.pushMonitor(o));
            }
        });
        throw new AssertionError();
    }

    public static void monitorLeave() {
        GreenThread.invoke(new ThreadTask(){

            @Override
            public Result eval(GreenWorld w) {
                GreenThreadState cur = w.currentThread();
                Object o = cur.monitor.o;
                cur = cur.popMonitor();
                w = w.with(cur);
                if (!cur.hasMonitor(o)) {
                    block4: for (GreenThreadState t : w.threads) {
                        if (t.wait != o) continue;
                        switch (t.cond) {
                            case MONITOR_ENTER: {
                                w = w.with(t.withCond(null, null).pushMonitor(o));
                                break block4;
                            }
                            case NOTIFIED: {
                                w = w.with(t.withCond(null, null));
                                break block4;
                            }
                            default: {
                                continue block4;
                            }
                        }
                    }
                }
                return new Result(w, null, false);
            }
        });
        throw new AssertionError();
    }

    public static void wait(final Object o) {
        GreenThread.invoke(new ThreadTask(){

            @Override
            public Result eval(GreenWorld w) {
                GreenThreadState cur = w.currentThread();
                if (!cur.hasMonitor(o)) {
                    throw new IllegalStateException("Thread doesn't have a lock of " + o);
                }
                w = w.with(cur.withCond(Cond.WAIT, o));
                return new Result(w, null, false);
            }
        });
        throw new AssertionError();
    }

    public static void notify(final Object o, final boolean all) {
        GreenThread.invoke(new ThreadTask(){

            @Override
            public Result eval(GreenWorld w) {
                GreenThreadState cur = w.currentThread();
                if (!cur.hasMonitor(o)) {
                    throw new IllegalStateException("Thread doesn't have a lock of " + o);
                }
                for (GreenThreadState t : w.threads) {
                    if (t.wait != o) continue;
                    w = w.with(t.withCond(Cond.NOTIFIED, o));
                    if (!all) break;
                }
                return new Result(w, null, false);
            }
        });
        throw new AssertionError();
    }
}

