/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.green;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.green.GreenThread;
import com.cloudbees.groovy.cps.green.GreenThreadState;
import com.cloudbees.groovy.cps.green.Result;
import com.cloudbees.groovy.cps.green.ThreadTask;
import com.cloudbees.groovy.cps.impl.ProxyEnv;
import java.io.Serializable;

class GreenWorld
implements Serializable {
    final GreenThreadState[] threads;
    private final int cur;
    private final Env e;
    private final Continuation k = new Continuation(){

        public Next receive(Object o) {
            return GreenWorld.this.update(GreenWorld.this.currentThread().tick(o));
        }
    };
    private final Block b = new Block(){

        public Next eval(Env e, Continuation k) {
            return GreenWorld.this.update(GreenWorld.this.currentThread().step());
        }
    };
    private static final long serialVersionUID = 1L;

    public GreenWorld(int cur, GreenThreadState ... threads) {
        this.threads = threads;
        this.cur = cur;
        this.e = new ProxyEnv(this.currentThread().n.e);
    }

    GreenThreadState currentThread() {
        return this.threads[this.cur];
    }

    GreenWorld withNewThread(GreenThreadState s) {
        GreenThreadState[] a = new GreenThreadState[this.threads.length + 1];
        System.arraycopy(this.threads, 0, a, 0, this.threads.length);
        a[this.threads.length] = s;
        return new GreenWorld(this.cur, a);
    }

    GreenWorld with(GreenThreadState s) {
        GreenWorld d;
        GreenThreadState[] a;
        int idx = -1;
        for (int i = 0; i < this.threads.length; ++i) {
            if (this.threads[i].g != s.g) continue;
            this.threads[i] = s;
            idx = i;
            break;
        }
        if (idx == -1) {
            throw new IllegalStateException("No such thread: " + s.g);
        }
        if (s.isDead()) {
            a = new GreenThreadState[this.threads.length - 1];
            System.arraycopy(this.threads, 0, a, 0, idx);
            System.arraycopy(this.threads, idx + 1, a, this.cur, this.threads.length - idx);
            d = new GreenWorld(idx < this.cur ? this.cur - 1 : this.cur, a);
        } else {
            a = new GreenThreadState[this.threads.length];
            System.arraycopy(this.threads, 0, a, 0, this.threads.length);
            a[idx] = s;
            int cur = this.cur;
            d = new GreenWorld(cur, a);
        }
        int i = 0;
        while (!d.currentThread().isRunnable()) {
            if (i == d.threads.length) {
                throw new IllegalStateException("No threads are runnable. Deadlock?");
            }
            ++i;
            d = d.withNewCur();
        }
        return d;
    }

    GreenWorld withNewCur() {
        int cur = this.cur + 1;
        for (int cnt = 0; cnt < this.threads.length; ++cnt) {
            int i = cur % this.threads.length;
            if (!this.threads[i].isRunnable()) continue;
            return new GreenWorld(i, this.threads);
        }
        throw new IllegalStateException("No threads are runnable. Deadlock?");
    }

    Next update(GreenThreadState g) {
        GreenWorld d = this.with(g);
        Outcome y = g.n.yield;
        if (y == null) {
            return d.withNewCur().asNext(null);
        }
        if (y.getNormal() instanceof ThreadTask) {
            ThreadTask task = (ThreadTask)y.getNormal();
            Result r = task.eval(d);
            d = r.w;
            if (r.suspend) {
                return d.asNext(r.value);
            }
            return d.update(g.resumeFrom(r.value));
        }
        return d.asNext(y);
    }

    Next asNext(Outcome y) {
        if (y == null) {
            return new Next(this.b, this.e, this.k);
        }
        return new Next(this.e, this.k, y);
    }

    public GreenThreadState resolveThreadState(GreenThread g) {
        for (GreenThreadState ts : this.threads) {
            if (ts.g != g) continue;
            return ts;
        }
        throw new IllegalStateException("Invalid green thread: " + g);
    }
}

