/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.tree;

import org.congocc.parser.CongoCCLexer;
import org.congocc.parser.Token;
import org.congocc.parser.tree.Literal;

public class StringLiteral
extends Literal {
    public String getString() {
        return StringLiteral.removeEscapesAndQuotes(this.toString());
    }

    public static String removeEscapesAndQuotes(String content) {
        StringBuilder buf = new StringBuilder();
        for (int i = 1; i < content.length() - 1; ++i) {
            boolean possibly3digits;
            char nextChar;
            char ch = content.charAt(i);
            if (ch != '\\') {
                buf.append(ch);
                continue;
            }
            if (i >= content.length() - 2) continue;
            if ((nextChar = content.charAt(++i)) < '0' || nextChar > '7') {
                switch (nextChar) {
                    case '\\': {
                        buf.append('\\');
                        break;
                    }
                    case 'b': {
                        buf.append('\b');
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        break;
                    }
                    case '\"': {
                        buf.append('\"');
                        break;
                    }
                    case '\'': {
                        buf.append('\'');
                    }
                }
                continue;
            }
            int octal = nextChar - 48;
            boolean bl = possibly3digits = octal <= 3;
            if (i < content.length() - 2 && (nextChar = content.charAt(i + 1)) >= '0' && nextChar <= '7') {
                octal = octal * 8 + nextChar - 48;
                if (possibly3digits && ++i < content.length() - 2 && (nextChar = content.charAt(i + 1)) >= '0' && nextChar <= '7') {
                    octal = octal * 8 + nextChar - 48;
                    ++i;
                }
            }
            buf.append((char)octal);
        }
        return buf.toString();
    }

    public StringLiteral(Token.TokenType type, CongoCCLexer tokenSource, int beginOffset, int endOffset) {
        super(type, tokenSource, beginOffset, endOffset);
    }
}

