/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.core;

import org.congocc.core.LexerData;
import org.congocc.core.RegexpSpec;
import org.congocc.core.nfa.LexicalStateData;
import org.congocc.parser.Node;
import org.congocc.parser.tree.BaseNode;
import org.congocc.parser.tree.CodeBlock;
import org.congocc.parser.tree.RegexpSequence;
import org.congocc.parser.tree.TokenProduction;

public abstract class RegularExpression
extends BaseNode {
    private LexicalStateData newLexicalState;
    private boolean _private = false;
    String label;
    private String generatedClassName;
    private String generatedSuperClassName;

    public CodeBlock getCodeSnippet() {
        return this.getParent() instanceof RegexpSpec ? this.getParent().firstChildOfType(CodeBlock.class) : null;
    }

    public boolean getIgnoreCase() {
        TokenProduction tp = this.firstAncestorOfType(TokenProduction.class);
        if (tp != null) {
            return tp.isIgnoreCase();
        }
        return this.getAppSettings().isIgnoreCase();
    }

    public TokenProduction getTokenProduction() {
        return this.firstAncestorOfType(TokenProduction.class);
    }

    public final void setLabel(String label) {
        assert (label.equals("") || LexerData.isJavaIdentifier(label));
        this.label = label;
    }

    public String getLabel() {
        if (this.label != null && this.label.length() != 0) {
            return this.label;
        }
        int id = this.getOrdinal();
        if (id == 0) {
            return "EOF";
        }
        String literalString = this.getLiteralString();
        if (literalString != null && LexerData.isJavaIdentifier(literalString)) {
            literalString = literalString.toUpperCase();
            if (!this.getGrammar().getLexerData().regexpLabelAlreadyUsed(literalString, this)) {
                return literalString;
            }
        }
        return "_TOKEN_" + id;
    }

    public final boolean hasLabel() {
        return this.label != null && LexerData.isJavaIdentifier(this.label);
    }

    public int getOrdinal() {
        int id = this.getGrammar().getLexerData().getOrdinal(this);
        return Math.max(0, id);
    }

    public void setNewLexicalState(LexicalStateData newLexicalState) {
        this.newLexicalState = newLexicalState;
    }

    public LexicalStateData getNewLexicalState() {
        return this.newLexicalState;
    }

    public boolean isPrivate() {
        return this._private;
    }

    public String getLiteralString() {
        return null;
    }

    public void setPrivate(boolean _private) {
        this._private = _private;
    }

    public String getGeneratedClassName() {
        if (this.generatedClassName == null) {
            this.generatedClassName = this.hasLabel() ? this.getLabel() : this.getGrammar().getAppSettings().getBaseTokenClassName();
        }
        return this.generatedClassName;
    }

    public void setGeneratedClassName(String generatedClassName) {
        this.generatedClassName = generatedClassName;
    }

    public String getGeneratedSuperClassName() {
        return this.generatedSuperClassName;
    }

    public void setGeneratedSuperClassName(String generatedSuperClassName) {
        this.generatedSuperClassName = generatedSuperClassName;
    }

    public abstract boolean matchesEmptyString();

    public boolean isPossiblyAtStart() {
        Node parent = this.getParent();
        if (!(parent instanceof RegularExpression)) {
            return true;
        }
        if (parent instanceof RegexpSequence) {
            RegexpSequence parentSequence = (RegexpSequence)parent;
            for (RegularExpression re : parentSequence.childrenOfType(RegularExpression.class)) {
                if (re == this) break;
                if (re.matchesEmptyString()) continue;
                return false;
            }
        }
        return ((RegularExpression)parent).isPossiblyAtStart();
    }

    public abstract int maximumLength();
}

