/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.java;

import java.util.EnumSet;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.Annotation;
import org.congocc.parser.tree.ArrayInitializer;
import org.congocc.parser.tree.CastExpression;
import org.congocc.parser.tree.ClassicCaseStatement;
import org.congocc.parser.tree.ClassicSwitchLabel;
import org.congocc.parser.tree.ConstructorDeclaration;
import org.congocc.parser.tree.Delimiter;
import org.congocc.parser.tree.EnumBody;
import org.congocc.parser.tree.FieldDeclaration;
import org.congocc.parser.tree.ForStatement;
import org.congocc.parser.tree.Identifier;
import org.congocc.parser.tree.IfStatement;
import org.congocc.parser.tree.ImportDeclaration;
import org.congocc.parser.tree.KeyWord;
import org.congocc.parser.tree.LocalVariableDeclaration;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.MultiLineComment;
import org.congocc.parser.tree.Operator;
import org.congocc.parser.tree.PackageDeclaration;
import org.congocc.parser.tree.RelationalExpression;
import org.congocc.parser.tree.SingleLineComment;
import org.congocc.parser.tree.Statement;
import org.congocc.parser.tree.TernaryExpression;
import org.congocc.parser.tree.TypeDeclaration;
import org.congocc.parser.tree.TypeParameters;
import org.congocc.parser.tree.Whitespace;

public class JavaFormatter
extends Node.Visitor {
    protected StringBuilder buf;
    private String indent;
    private String currentIndent;
    private String eol;
    private EnumSet<Token.TokenType> alwaysPrependSpace;
    private EnumSet<Token.TokenType> alwaysAppendSpace;
    private static final int MAX_LINE_LENGTH = 80;

    public JavaFormatter() {
        this.visitUnparsedTokens = true;
        this.indent = "    ";
        this.currentIndent = "";
        this.eol = "\n";
        this.alwaysPrependSpace = EnumSet.of(Token.TokenType.ASSIGN, new Token.TokenType[]{Token.TokenType.COLON, Token.TokenType.LBRACE, Token.TokenType.THROWS, Token.TokenType.EQ, Token.TokenType.NE, Token.TokenType.LE, Token.TokenType.GE, Token.TokenType.PLUS, Token.TokenType.MINUS, Token.TokenType.SLASH, Token.TokenType.SC_AND, Token.TokenType.SC_OR, Token.TokenType.BIT_AND, Token.TokenType.BIT_OR, Token.TokenType.XOR, Token.TokenType.REM, Token.TokenType.LSHIFT, Token.TokenType.PLUSASSIGN, Token.TokenType.MINUSASSIGN, Token.TokenType.STARASSIGN, Token.TokenType.SLASHASSIGN, Token.TokenType.ANDASSIGN, Token.TokenType.ORASSIGN, Token.TokenType.XORASSIGN, Token.TokenType.REMASSIGN, Token.TokenType.LSHIFTASSIGN, Token.TokenType.RSIGNEDSHIFT, Token.TokenType.RUNSIGNEDSHIFT, Token.TokenType.RSIGNEDSHIFTASSIGN, Token.TokenType.RUNSIGNEDSHIFTASSIGN, Token.TokenType.LAMBDA, Token.TokenType.INSTANCEOF});
        this.alwaysAppendSpace = EnumSet.of(Token.TokenType.ASSIGN, new Token.TokenType[]{Token.TokenType.COLON, Token.TokenType.DO, Token.TokenType.CATCH, Token.TokenType.CASE, Token.TokenType.FOR, Token.TokenType.IF, Token.TokenType.WHILE, Token.TokenType.THROWS, Token.TokenType.EXTENDS, Token.TokenType.EQ, Token.TokenType.NE, Token.TokenType.LE, Token.TokenType.GE, Token.TokenType.PLUS, Token.TokenType.SLASH, Token.TokenType.SC_AND, Token.TokenType.SC_OR, Token.TokenType.BIT_AND, Token.TokenType.BIT_OR, Token.TokenType.XOR, Token.TokenType.REM, Token.TokenType.LSHIFT, Token.TokenType.PLUSASSIGN, Token.TokenType.MINUSASSIGN, Token.TokenType.STARASSIGN, Token.TokenType.SLASHASSIGN, Token.TokenType.ANDASSIGN, Token.TokenType.ORASSIGN, Token.TokenType.XORASSIGN, Token.TokenType.REMASSIGN, Token.TokenType.LSHIFTASSIGN, Token.TokenType.RSIGNEDSHIFT, Token.TokenType.RUNSIGNEDSHIFT, Token.TokenType.RSIGNEDSHIFTASSIGN, Token.TokenType.RUNSIGNEDSHIFTASSIGN, Token.TokenType.LAMBDA, Token.TokenType.INSTANCEOF});
    }

    public String format(Node code, int indentLevel) {
        this.buf = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            this.currentIndent = this.currentIndent + this.indent;
        }
        this.visit(code);
        return this.buf.toString();
    }

    public String format(Node code) {
        return this.format(code, 0);
    }

    private void outputToken(Token tok) {
        if (this.buf.length() > 0) {
            int nextChar = tok.toString().codePointAt(0);
            int prevChar = this.buf.codePointBefore(this.buf.length());
            if ((Character.isJavaIdentifierPart(prevChar) || prevChar == 59) && Character.isJavaIdentifierPart(nextChar)) {
                this.addSpaceIfNecessary();
            } else if (this.alwaysPrependSpace.contains(tok.getType())) {
                this.addSpaceIfNecessary();
            }
        }
        this.buf.append(tok.toString());
        if (this.alwaysAppendSpace.contains(tok.getType())) {
            this.addSpaceIfNecessary();
        }
    }

    void visit(Token tok) {
        if (tok.getType() == Token.TokenType.EOF) {
            this.buf.append("\n");
        } else {
            this.outputToken(tok);
        }
    }

    void visit(TypeParameters tps) {
        this.addSpaceIfNecessary();
        this.recurse(tps);
    }

    void visit(Operator op) {
        switch (op.getType()) {
            case LT: {
                if (op.getParent() instanceof RelationalExpression) {
                    this.addSpaceIfNecessary();
                    this.buf.append(op);
                    this.buf.append(' ');
                    break;
                }
                this.buf.append(op);
                break;
            }
            case GT: {
                if (op.getParent() instanceof RelationalExpression) {
                    this.addSpaceIfNecessary();
                    this.buf.append(op);
                    this.buf.append(' ');
                    break;
                }
                this.buf.append(op);
                Token.TokenType tokenType = op.nextCachedToken().getType();
                if (tokenType == Token.TokenType.GT || tokenType == Token.TokenType.COMMA || tokenType == Token.TokenType.LPAREN || tokenType == Token.TokenType.RPAREN || tokenType == Token.TokenType.LBRACE) break;
                this.addSpaceIfNecessary();
                break;
            }
            case HOOK: {
                if (op.getParent() instanceof TernaryExpression) {
                    this.addSpaceIfNecessary();
                    this.buf.append(op);
                    this.buf.append(' ');
                    break;
                }
                this.buf.append(op);
                if (op.nextCachedToken().getType() == Token.TokenType.GT) break;
                this.buf.append(' ');
                break;
            }
            case STAR: {
                if (op.getParent() instanceof ImportDeclaration) {
                    this.buf.append(op);
                    break;
                }
                this.addSpaceIfNecessary();
                this.buf.append(op);
                this.buf.append(' ');
                break;
            }
            case MINUS: {
                if (op.getPrevious().getType() == Token.TokenType.RPAREN || op.getPrevious() instanceof Identifier) {
                    this.addSpaceIfNecessary();
                }
                this.buf.append(op);
                int nextChar = op.getNext().toString().codePointAt(0);
                if (!(op.getPrevious() instanceof Identifier) && !(op.getPrevious() instanceof Delimiter) && Character.isDigit(nextChar)) break;
                this.addSpaceIfNecessary();
                break;
            }
            default: {
                this.outputToken(op);
            }
        }
    }

    void visit(KeyWord kw) {
        this.outputToken(kw);
        if (kw.getType() == Token.TokenType.RETURN && kw.getNext().getType() != Token.TokenType.SEMICOLON) {
            this.addSpaceIfNecessary();
        }
    }

    void visit(Delimiter delimiter) {
        switch (delimiter.getType()) {
            case COMMA: {
                this.outputToken(delimiter);
                if (this.currentLineLength() > 80 && (delimiter.getParent() instanceof ArrayInitializer || delimiter.getParent() instanceof EnumBody)) {
                    this.newLine();
                    break;
                }
                this.buf.append(' ');
                break;
            }
            case RBRACKET: {
                this.outputToken(delimiter);
                Token.TokenType nextType = delimiter.getNext().getType();
                if (nextType == Token.TokenType.LBRACKET || nextType == Token.TokenType.SEMICOLON || nextType == Token.TokenType.GT || nextType == Token.TokenType.RPAREN || nextType == Token.TokenType.COMMA || nextType == Token.TokenType.DOT) break;
                this.addSpaceIfNecessary();
                break;
            }
            case LBRACE: {
                this.outputToken(delimiter);
                if (delimiter.getParent() instanceof ArrayInitializer) break;
                this.currentIndent = this.currentIndent + this.indent;
                this.newLine();
                break;
            }
            case RBRACE: {
                boolean endOfArrayInitializer = delimiter.getParent() instanceof ArrayInitializer;
                if (!endOfArrayInitializer) {
                    this.newLine();
                    this.dedent();
                }
                this.buf.append(delimiter);
                Token token = delimiter.getNext();
                if (endOfArrayInitializer || null == token || token.getType() == Token.TokenType.SEMICOLON) break;
                if (token.getType() == Token.TokenType.CATCH || token.getType() == Token.TokenType.ELSE || token.getType() == Token.TokenType.FINALLY) {
                    this.addSpaceIfNecessary();
                    break;
                }
                this.newLine();
                break;
            }
            case RPAREN: {
                this.buf.append(delimiter);
                if (!(delimiter.getParent() instanceof CastExpression)) break;
                this.addSpaceIfNecessary();
                break;
            }
            case SEMICOLON: {
                if (this.buf.charAt(this.buf.length() - 1) != ' ') {
                    this.buf.append(delimiter);
                    if (delimiter.getParent() instanceof ForStatement || delimiter.getParent() instanceof ImportDeclaration) break;
                    this.newLine();
                    break;
                }
                for (int i = 1; i <= 6; ++i) {
                    if (this.buf.charAt(this.buf.length() - 1) != ' ' && this.buf.charAt(this.buf.length() - 1) != '\n') continue;
                    this.buf.setLength(this.buf.length() - 1);
                }
                break;
            }
            default: {
                this.outputToken(delimiter);
            }
        }
    }

    void visit(MultiLineComment comment) {
        this.startNewLineIfNecessary();
        this.buf.append(this.indentText(comment.toString()));
        this.newLine();
    }

    void visit(SingleLineComment comment) {
        if (this.startsNewLine(comment)) {
            this.newLine();
        } else {
            this.addSpaceIfNecessary();
        }
        this.buf.append(comment.toString());
        this.newLine();
    }

    void visit(Whitespace ws) {
    }

    void visit(TypeDeclaration td) {
        this.newLine(true);
        this.recurse(td);
        this.newLine(true);
    }

    void visit(Statement stmt) {
        if (stmt.getParent() instanceof IfStatement) {
            this.addSpaceIfNecessary();
        }
        this.recurse(stmt);
    }

    private void addSpaceIfNecessary() {
        if (this.buf.length() == 0) {
            return;
        }
        int lastChar = this.buf.codePointBefore(this.buf.length());
        if (!Character.isWhitespace(lastChar)) {
            this.buf.append(' ');
        }
    }

    private void dedent() {
        String finalPart = this.buf.substring(this.buf.length() - this.indent.length(), this.buf.length());
        if (finalPart.equals(this.indent)) {
            this.buf.setLength(this.buf.length() - this.indent.length());
        }
        this.currentIndent = this.currentIndent.substring(0, this.currentIndent.length() - this.indent.length());
    }

    private boolean startsNewLine(Token t) {
        Token previousCachedToken = t.previousCachedToken();
        return previousCachedToken == null || previousCachedToken.getEndLine() != t.getBeginLine();
    }

    private String indentText(String text) {
        StringBuilder buf = new StringBuilder();
        for (String line : text.split("\n")) {
            buf.append(this.currentIndent);
            buf.append(line.trim());
            buf.append("\n");
        }
        return buf.toString();
    }

    protected void visit(PackageDeclaration pd) {
        this.recurse(pd);
        this.newLine(true);
    }

    protected void visit(ImportDeclaration id) {
        this.recurse(id);
        this.buf.append(this.eol);
        if (!(id.nextSibling() instanceof ImportDeclaration)) {
            this.buf.append(this.eol);
        }
    }

    protected void visit(MethodDeclaration md) {
        if (!(md.previousSibling() instanceof MethodDeclaration) && !(md.previousSibling() instanceof ConstructorDeclaration)) {
            this.newLine(true);
        }
        this.recurse(md);
        this.newLine(true);
    }

    protected void visit(ConstructorDeclaration cd) {
        if (!(cd.previousSibling() instanceof MethodDeclaration) && !(cd.previousSibling() instanceof ConstructorDeclaration)) {
            this.newLine(true);
        }
        this.recurse(cd);
        this.newLine(true);
    }

    protected void visit(FieldDeclaration fd) {
        if (!(fd.previousSibling() instanceof FieldDeclaration)) {
            this.newLine();
        }
        this.recurse(fd);
        this.newLine();
    }

    protected void visit(LocalVariableDeclaration lvd) {
        boolean inForStatement = lvd.getParent() instanceof ForStatement;
        if (!inForStatement) {
            this.newLine();
        }
        this.recurse(lvd);
        if (!inForStatement) {
            this.newLine();
        }
    }

    protected void visit(Annotation ann) {
        if (!(ann.previousSibling() instanceof Annotation)) {
            this.newLine();
        }
        this.recurse(ann);
        this.newLine();
    }

    void visit(ClassicCaseStatement ccs) {
        this.visit(ccs.firstChildOfType(ClassicSwitchLabel.class));
        this.currentIndent = this.currentIndent + this.indent;
        this.newLine();
        for (Statement stmt : ccs.childrenOfType(Statement.class)) {
            this.visit(stmt);
        }
        this.dedent();
        this.newLine();
    }

    private void startNewLineIfNecessary() {
        if (this.buf.length() == 0) {
            return;
        }
        int lastNL = this.buf.lastIndexOf(this.eol);
        if (lastNL + this.eol.length() == this.buf.length()) {
            return;
        }
        String line = this.buf.substring(lastNL + this.eol.length());
        if (line.trim().length() == 0) {
            this.buf.setLength(lastNL + this.eol.length());
        } else {
            this.buf.append(this.eol);
        }
    }

    private void newLine() {
        this.newLine(false);
    }

    private void newLine(boolean ensureBlankLine) {
        this.startNewLineIfNecessary();
        if (ensureBlankLine) {
            this.buf.append(this.eol);
        }
        this.buf.append(this.currentIndent);
    }

    private int currentLineLength() {
        return this.buf.length() - this.buf.lastIndexOf(this.eol) - this.eol.length();
    }
}

