/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.java;

import java.util.ArrayList;
import java.util.List;
import org.congocc.codegen.java.Reaper;
import org.congocc.parser.CongoCCParser;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.tree.Annotation;
import org.congocc.parser.tree.CompilationUnit;
import org.congocc.parser.tree.FieldDeclaration;
import org.congocc.parser.tree.Identifier;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.Modifiers;
import org.congocc.parser.tree.Type;

public class JavaCodeUtils {
    private JavaCodeUtils() {
    }

    public static void addGetterSetters(Node root) {
        List<FieldDeclaration> fds = root.descendants(FieldDeclaration.class);
        for (FieldDeclaration fd : fds) {
            for (Annotation annotation : JavaCodeUtils.getAnnotations(fd)) {
                if (!annotation.getName().equals("Property")) continue;
                JavaCodeUtils.addGetterSetter(fd);
                annotation.getParent().remove(annotation);
            }
        }
    }

    private static List<Annotation> getAnnotations(Node node) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        result.addAll(node.childrenOfType(Annotation.class));
        Modifiers mods = node.firstChildOfType(Modifiers.class);
        if (mods != null) {
            result.addAll(mods.childrenOfType(Annotation.class));
        }
        return result;
    }

    private static void addGetterSetter(FieldDeclaration fd) {
        Node context = fd.getParent();
        int index = context.indexOf(fd);
        String fieldType = fd.firstChildOfType(Type.class).toString();
        for (Identifier id : fd.getVariableIds()) {
            JavaCodeUtils.ensurePrivate(fd);
            JavaCodeUtils.insertGetterSetter(context, fieldType, id.toString(), index);
        }
    }

    private static void ensurePrivate(FieldDeclaration fd) {
        List<Token> tokens = fd.childrenOfType(Token.class);
        Modifiers mods = fd.firstChildOfType(Modifiers.class);
        if (mods != null) {
            tokens.addAll(mods.childrenOfType(Token.class));
        }
        for (Token tok : tokens) {
            Token.TokenType type = tok.getType();
            if (type == Token.TokenType.PRIVATE) {
                return;
            }
            if (type != Token.TokenType.PROTECTED && type != Token.TokenType.PUBLIC) continue;
            tok.getParent().remove(tok);
            break;
        }
        Type type = fd.firstChildOfType(Type.class);
        Token privateToken = Token.newToken(Token.TokenType.PRIVATE, "private", fd.getTokenSource());
        if (mods != null) {
            mods.add(privateToken);
        } else {
            fd.add(fd.indexOf(type), privateToken);
        }
    }

    private static void insertGetterSetter(Node context, String fieldType, String fieldName, int index) {
        String getterMethodName = "get" + JavaCodeUtils.capitalizeFirstLetter(fieldName);
        String setterMethodName = getterMethodName.replaceFirst("g", "s");
        if (fieldType.equals("boolean")) {
            getterMethodName = getterMethodName.replaceFirst("get", "is");
        }
        String getter = "//Inserted getter for " + fieldName + "\npublic " + fieldType + " " + getterMethodName + "() {return " + fieldName + ";}";
        String setter = "//Inserted setter for " + fieldName + "\npublic void " + setterMethodName + "(" + fieldType + " " + fieldName + ") {this." + fieldName + " = " + fieldName + ";}";
        MethodDeclaration getterMethod = null;
        MethodDeclaration setterMethod = null;
        getterMethod = new CongoCCParser(getter).MethodDeclaration();
        setterMethod = new CongoCCParser(setter).MethodDeclaration();
        context.add(index + 1, setterMethod);
        context.add(index + 1, getterMethod);
    }

    public static void removeWrongJDKElements(Node context, int target) {
        List<Annotation> annotations = context.descendants(Annotation.class, a -> a.getName().toLowerCase().startsWith("minjdk") || a.getName().toLowerCase().startsWith("maxjdk"));
        for (Annotation annotation : annotations) {
            boolean specifiesMax = annotation.getName().toLowerCase().startsWith("max");
            String intPart = annotation.getName().substring(6);
            int specifiedVersion = target;
            try {
                specifiedVersion = Integer.valueOf(intPart);
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            boolean removeElement = specifiesMax ? target > specifiedVersion : target < specifiedVersion;
            Node parent = annotation.getParent();
            parent.remove(annotation);
            if (parent instanceof Modifiers) {
                parent = parent.getParent();
            }
            Node grandparent = parent.getParent();
            if (!removeElement) continue;
            grandparent.remove(parent);
        }
    }

    public static void stripUnused(CompilationUnit jcu) {
        new Reaper(jcu).stripUnused();
    }

    private static final String capitalizeFirstLetter(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

