/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.script;

import freemarker.ext.script.FreeMarkerScriptEngine;
import freemarker.ext.script.ScriptContextHashModel;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

class CompiledFreeMarkerScript
extends CompiledScript {
    private final FreeMarkerScriptEngine engine;
    private final Template template;

    CompiledFreeMarkerScript(FreeMarkerScriptEngine engine, Template template) {
        this.engine = engine;
        this.template = template;
    }

    @Override
    public Object eval(ScriptContext context) throws ScriptException {
        try {
            boolean stringOutput = Boolean.TRUE.equals(context.getAttribute("freeMarker.stringOutput"));
            Writer w = stringOutput ? new StringWriter() : context.getWriter();
            this.template.process(new ScriptContextHashModel(context, this.template.getObjectWrapper()), w);
            return stringOutput ? w.toString() : null;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (TemplateException e) {
            throw new ScriptException(e);
        }
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }
}

