/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.core.ast.CollectionAndSequence;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.util.ModelFactory;
import freemarker.ext.util.WrapperTemplateModel;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.WrappingTemplateModel;
import java.util.List;
import java.util.Map;

public class SimpleMapModel
extends WrappingTemplateModel
implements TemplateHashModelEx,
TemplateMethodModelEx,
AdapterTemplateModel,
WrapperTemplateModel {
    static final ModelFactory FACTORY = new ModelFactory(){

        @Override
        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new SimpleMapModel((Map)object, (BeansWrapper)wrapper);
        }
    };
    private final Map map;

    public SimpleMapModel(Map map, BeansWrapper wrapper) {
        super(wrapper);
        this.map = map;
    }

    @Override
    public TemplateModel get(String key) {
        Object val = this.map.get(key);
        if (val == null) {
            if (key.length() == 1) {
                Character charKey = Character.valueOf(key.charAt(0));
                val = this.map.get(charKey);
                if (val == null) {
                    return this.map.containsKey(key) || this.map.containsKey(charKey) ? JAVA_NULL : null;
                }
            } else {
                return this.map.containsKey(key) ? JAVA_NULL : null;
            }
        }
        return this.wrap(val);
    }

    @Override
    public Object exec(List args) {
        Object key = ((BeansWrapper)this.getObjectWrapper()).unwrap((TemplateModel)args.get(0));
        Object value = this.map.get(key);
        if (value == null && !this.map.containsKey(key)) {
            return null;
        }
        return this.wrap(value);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public TemplateCollectionModel keys() {
        return new CollectionAndSequence(new SimpleSequence(this.map.keySet(), this.getObjectWrapper()));
    }

    @Override
    public TemplateCollectionModel values() {
        return new CollectionAndSequence(new SimpleSequence(this.map.values(), this.getObjectWrapper()));
    }

    public Object getAdaptedObject(Class hint) {
        return this.map;
    }

    @Override
    public Object getWrappedObject() {
        return this.map;
    }
}

