/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.HashMap;
import java.util.Map;

abstract class ClassBasedModelFactory
implements TemplateHashModel {
    private final BeansWrapper wrapper;
    private final Map<String, TemplateModel> cache = new HashMap<String, TemplateModel>();

    protected ClassBasedModelFactory(BeansWrapper wrapper) {
        this.wrapper = wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TemplateModel get(String key) {
        Map<String, TemplateModel> map = this.cache;
        synchronized (map) {
            TemplateModel model = this.cache.get(key);
            if (model == null) {
                try {
                    Class<?> clazz = Class.forName(key);
                    model = this.createModel(clazz);
                    this.wrapper.introspectClass(clazz);
                }
                catch (Exception e) {
                    throw new TemplateModelException(e);
                }
                this.cache.put(key, model);
            }
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCache() {
        Map<String, TemplateModel> map = this.cache;
        synchronized (map) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIntrospectionInfo(Class clazz) {
        Map<String, TemplateModel> map = this.cache;
        synchronized (map) {
            this.cache.remove(clazz.getName());
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    protected abstract TemplateModel createModel(Class var1) throws TemplateModelException;

    protected BeansWrapper getWrapper() {
        return this.wrapper;
    }
}

