/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.helpers;

import freemarker.core.AbstractScope;
import freemarker.core.Scope;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateModel;
import java.util.Collection;
import java.util.Map;

public class NamedParameterMapScope
extends AbstractScope {
    private final Map<String, TemplateModel> parameters;

    public NamedParameterMapScope(Scope enclosingScope, Map<String, TemplateModel> parameters) {
        super(enclosingScope);
        this.parameters = parameters;
    }

    @Override
    public boolean definesVariable(String name) {
        return this.parameters.containsKey(name);
    }

    @Override
    public Collection<String> getDirectVariableNames() {
        return this.parameters.keySet();
    }

    @Override
    public void put(String key, TemplateModel value) {
        this.parameters.put(key, value);
    }

    @Override
    public TemplateModel remove(String key) {
        return this.parameters.remove(key);
    }

    @Override
    public TemplateCollectionModel keys() {
        return new SimpleCollection(this.parameters.keySet());
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public TemplateCollectionModel values() {
        return new SimpleCollection(this.parameters.values());
    }

    @Override
    public TemplateModel get(String key) {
        return this.parameters.get(key);
    }
}

