/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.helpers;

import freemarker.core.ast.ArgsList;
import freemarker.core.ast.AssignmentInstruction;
import freemarker.core.ast.BooleanLiteral;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.Expression;
import freemarker.core.ast.Macro;
import freemarker.core.ast.MethodCall;
import freemarker.core.ast.MixedContent;
import freemarker.core.ast.PositionalArgsList;
import freemarker.core.ast.TemplateHeaderElement;
import freemarker.core.ast.TemplateNode;
import freemarker.core.ast.VarDirective;
import freemarker.core.helpers.DefaultTreeDumper;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CanonicalizingTreeDumper
extends DefaultTreeDumper {
    boolean convertAssignments = true;
    boolean convertExistence = true;
    boolean strictVars;

    public CanonicalizingTreeDumper() {
        super(true);
    }

    public CanonicalizingTreeDumper(boolean altSyntax) {
        super(altSyntax);
    }

    @Override
    public String render(Template template) {
        if (this.strictVars) {
            TemplateHeaderElement header = template.getHeaderElement();
            if (header == null) {
                HashMap<String, Expression> params = new HashMap<String, Expression>();
                params.put("strict_vars", new BooleanLiteral(true));
                header = new TemplateHeaderElement(params);
            } else {
                header.addParameter("strict_vars", new BooleanLiteral(false));
            }
        }
        return super.render(template);
    }

    @Override
    public void visit(MixedContent node) {
        if (this.strictVars && node.getParent() == null) {
            Template template = node.getTemplate();
            ArrayList<String> declaredVariables = new ArrayList<String>(template.getDeclaredVariables());
            for (TemplateNode te : node) {
                if (te instanceof Macro) {
                    String macroName = ((Macro)te).getName();
                    declaredVariables.remove(macroName);
                }
                if (!(te instanceof VarDirective)) continue;
                VarDirective varDirective = (VarDirective)te;
                for (String varname : varDirective.getVariables().keySet()) {
                    declaredVariables.remove(varname);
                }
            }
            if (!declaredVariables.isEmpty()) {
                VarDirective varDirective = new VarDirective();
                for (String varname : declaredVariables) {
                    varDirective.addVar(varname);
                }
                this.visit(varDirective);
                this.buffer.append("\n");
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(Macro macro) {
        if (this.convertAssignments) {
            macro.canonicalizeAssignments();
        }
        super.visit(macro);
    }

    @Override
    public void visit(MethodCall node) {
        BuiltInExpression bi;
        if (this.convertExistence && node.getTarget() instanceof BuiltInExpression && (bi = (BuiltInExpression)node.getTarget()).getName().equals("default")) {
            Expression lhs = bi.getTarget();
            this.buffer.append(this.render(lhs));
            ArgsList args = node.getArgs();
            if (args instanceof PositionalArgsList) {
                PositionalArgsList pargs = (PositionalArgsList)args;
                for (Expression arg : pargs.getArgs()) {
                    this.buffer.append("!");
                    this.visit(arg);
                }
            }
            return;
        }
        super.visit(node);
    }

    @Override
    public void visit(BuiltInExpression node) {
        if (!this.convertExistence) {
            super.visit(node);
            return;
        }
        this.visit(node.getTarget());
        String builtinName = node.getName();
        if (builtinName.equals("if_exists")) {
            this.buffer.append("!");
        } else if (builtinName.equals("exists")) {
            this.buffer.append("??");
        } else {
            this.buffer.append("?");
            this.buffer.append(builtinName);
        }
    }

    @Override
    public void visit(AssignmentInstruction node) {
        if (!this.convertAssignments) {
            super.visit(node);
            return;
        }
        this.openDirective("set ");
        List<String> varnames = node.getVarNames();
        List<Expression> values = node.getValues();
        for (int i = 0; i < varnames.size(); ++i) {
            if (i > 0) {
                this.buffer.append(", ");
            }
            String varname = varnames.get(i);
            Expression value = values.get(i);
            this.buffer.append(CanonicalizingTreeDumper.quoteVarnameIfNecessary(varname));
            this.buffer.append(" = ");
            this.visit(value);
        }
        Expression namespaceExp = node.getNamespaceExp();
        if (namespaceExp != null) {
            this.buffer.append(" in ");
            this.visit(namespaceExp);
        } else {
            Macro enclosingMacro;
            if (node.getType() == 2) {
                this.buffer.append(" in .globals");
            }
            if (node.getType() == 1 && (enclosingMacro = node.getEnclosingMacro()) != null) {
                boolean declaredLocally = false;
                for (String varname : varnames) {
                    if (!enclosingMacro.declaresVariable(varname)) continue;
                    declaredLocally = true;
                }
                if (declaredLocally) {
                    this.buffer.append(" in .namespace");
                }
            }
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }
}

