/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.TemplateNode;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.core.builtins.ModelComparator;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import freemarker.template.TemplateSequenceModel;
import java.util.List;

public class SequenceContainsBuiltIn
extends ExpressionEvaluatingBuiltIn {
    @Override
    public boolean isSideEffectFree() {
        return false;
    }

    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) throws TemplateException {
        if (!(model instanceof TemplateSequenceModel) && !(model instanceof TemplateCollectionModel)) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "sequence or collection");
        }
        return new SequenceContainsFunction(model);
    }

    static class SequenceContainsFunction
    implements TemplateMethodModelEx {
        final TemplateSequenceModel sequence;
        final TemplateCollectionModel collection;

        SequenceContainsFunction(TemplateModel seqModel) {
            if (seqModel instanceof TemplateCollectionModel) {
                this.collection = (TemplateCollectionModel)seqModel;
                this.sequence = null;
            } else if (seqModel instanceof TemplateSequenceModel) {
                this.sequence = (TemplateSequenceModel)seqModel;
                this.collection = null;
            } else {
                throw new AssertionError();
            }
        }

        @Override
        public TemplateModel exec(List args) {
            if (args.size() != 1) {
                throw new TemplateModelException("Expecting exactly one argument for ?seq_contains(...)");
            }
            TemplateModel compareToThis = (TemplateModel)args.get(0);
            ModelComparator modelComparator = new ModelComparator(Environment.getCurrentEnvironment());
            if (this.collection != null) {
                TemplateModelIterator tmi = this.collection.iterator();
                while (tmi.hasNext()) {
                    if (!modelComparator.modelsEqual(tmi.next(), compareToThis)) continue;
                    return TemplateBooleanModel.TRUE;
                }
                return TemplateBooleanModel.FALSE;
            }
            for (int i = 0; i < this.sequence.size(); ++i) {
                if (!modelComparator.modelsEqual(this.sequence.get(i), compareToThis)) continue;
                return TemplateBooleanModel.TRUE;
            }
            return TemplateBooleanModel.FALSE;
        }
    }
}

