/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.TemplateNode;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNodeModel;
import freemarker.template.utility.StringUtil;
import java.util.List;

public abstract class NodeFunctions
extends ExpressionEvaluatingBuiltIn {
    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        if (!(model instanceof TemplateNodeModel)) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "node");
        }
        return this.apply(env, (TemplateNodeModel)model);
    }

    public abstract TemplateModel apply(Environment var1, TemplateNodeModel var2) throws TemplateException;

    static class AncestorSequence
    extends SimpleSequence
    implements TemplateMethodModel {
        private static final long serialVersionUID = 1L;

        AncestorSequence() {
        }

        @Override
        public Object exec(List names) {
            if (names == null || names.isEmpty()) {
                return this;
            }
            AncestorSequence result = new AncestorSequence();
            Environment env = Environment.getCurrentEnvironment();
            block0: for (int i = 0; i < this.size(); ++i) {
                TemplateNodeModel tnm = (TemplateNodeModel)this.get(i);
                String nodeName = tnm.getNodeName();
                String nsURI = tnm.getNodeNamespace();
                if (nsURI == null) {
                    if (!names.contains(nodeName)) continue;
                    result.add(tnm);
                    continue;
                }
                for (int j = 0; j < names.size(); ++j) {
                    if (!StringUtil.matchesName((String)names.get(j), nodeName, nsURI, env)) continue;
                    result.add(tnm);
                    continue block0;
                }
            }
            return result;
        }
    }

    public static class Ancestors
    extends NodeFunctions {
        @Override
        public TemplateModel apply(Environment env, TemplateNodeModel node) {
            AncestorSequence result = new AncestorSequence();
            for (TemplateNodeModel parent = node.getParentNode(); parent != null; parent = parent.getParentNode()) {
                result.add(parent);
            }
            return result;
        }
    }

    public static class NodeType
    extends NodeFunctions {
        @Override
        public TemplateModel apply(Environment env, TemplateNodeModel node) {
            String nt = node.getNodeType();
            return nt == null ? TemplateModel.JAVA_NULL : new SimpleScalar(nt);
        }
    }

    public static class NodeNamespace
    extends NodeFunctions {
        @Override
        public TemplateModel apply(Environment env, TemplateNodeModel node) {
            String ns = node.getNodeNamespace();
            return ns == null ? TemplateModel.JAVA_NULL : new SimpleScalar(ns);
        }
    }

    public static class NodeName
    extends NodeFunctions {
        @Override
        public TemplateModel apply(Environment env, TemplateNodeModel node) {
            return new SimpleScalar(node.getNodeName());
        }
    }

    public static class Root
    extends NodeFunctions {
        @Override
        public TemplateModel apply(Environment env, TemplateNodeModel node) {
            TemplateNodeModel parent;
            while ((parent = node.getParentNode()) != null) {
                node = parent;
            }
            return node;
        }
    }

    public static class Children
    extends NodeFunctions {
        @Override
        public TemplateModel apply(Environment env, TemplateNodeModel node) {
            return node.getChildNodes();
        }
    }

    public static class Parent
    extends NodeFunctions {
        @Override
        public TemplateModel apply(Environment env, TemplateNodeModel node) {
            return node.getParentNode();
        }
    }
}

