/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.Expression;
import freemarker.core.ast.ParentheticalExpression;
import freemarker.core.builtins.BuiltIn;
import freemarker.template.LazilyEvaluatableArguments;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.util.List;

public abstract class ExistenceBuiltIn
extends BuiltIn {
    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller) {
        Expression target = caller.getTarget();
        try {
            return this.apply(target.getAsTemplateModel(env));
        }
        catch (InvalidReferenceException e) {
            if (!(target instanceof ParentheticalExpression)) {
                throw e;
            }
            return this.apply(null);
        }
    }

    public abstract TemplateModel apply(TemplateModel var1) throws TemplateModelException;

    private static class FirstDefined
    implements TemplateMethodModelEx,
    LazilyEvaluatableArguments {
        static final FirstDefined INSTANCE = new FirstDefined();

        private FirstDefined() {
        }

        @Override
        public TemplateModel exec(List args) {
            for (Object arg : args) {
                if (arg == null || arg == TemplateModel.JAVA_NULL) continue;
                return (TemplateModel)arg;
            }
            return null;
        }
    }

    public static class IsDefinedBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public TemplateModel apply(TemplateModel model) {
            return model == null ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
        }
    }

    public static class HasContentBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public TemplateModel apply(TemplateModel model) {
            return model == null || Expression.isEmpty(model) ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
        }
    }

    public static class ExistsBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public TemplateModel apply(TemplateModel model) {
            return model == null || model == TemplateModel.JAVA_NULL ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
        }
    }

    public static class IfExistsBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public TemplateModel apply(TemplateModel model) {
            return model == null || model == TemplateModel.JAVA_NULL ? TemplateModel.NOTHING : model;
        }
    }

    public static final class DefaultBuiltIn
    extends ExistenceBuiltIn {
        @Override
        public TemplateModel apply(final TemplateModel model) {
            if (model == null || model == TemplateModel.JAVA_NULL) {
                return FirstDefined.INSTANCE;
            }
            return new TemplateMethodModelEx(){

                @Override
                public Object exec(List arguments) {
                    return model;
                }
            };
        }
    }
}

