/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.TemplateNode;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.template.SimpleDate;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class DateTime
extends ExpressionEvaluatingBuiltIn {
    private final int dateType;

    public DateTime(int dateType) {
        this.dateType = dateType;
    }

    @Override
    public boolean isSideEffectFree() {
        return false;
    }

    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        if (model instanceof TemplateDateModel) {
            TemplateDateModel dmodel = (TemplateDateModel)model;
            int dtype = dmodel.getDateType();
            if (this.dateType == dtype) {
                return dmodel;
            }
            if (dtype == 0 || dtype == 3) {
                return new SimpleDate(dmodel.getAsDate(), this.dateType);
            }
            throw new TemplateException("Cannot convert " + TemplateDateModel.TYPE_NAMES.get(dtype) + " into " + TemplateDateModel.TYPE_NAMES.get(this.dateType), env);
        }
        if (model instanceof TemplateScalarModel) {
            return new DateParser(((TemplateScalarModel)model).getAsString(), this.dateType, caller, env);
        }
        throw TemplateNode.invalidTypeException(model, caller, env, "time/date or string");
    }

    static class DateParser
    implements TemplateDateModel,
    TemplateMethodModel,
    TemplateHashModel {
        private final String text;
        private final Environment env;
        private final DateFormat defaultFormat;
        private BuiltInExpression caller;
        private int dateType;
        private Date cachedValue;

        DateParser(String text, int dateType, BuiltInExpression caller, Environment env) throws TemplateModelException {
            this.text = text;
            this.env = env;
            this.caller = caller;
            this.dateType = dateType;
            this.defaultFormat = env.getDateFormatObject(dateType);
        }

        @Override
        public Date getAsDate() {
            if (this.cachedValue == null) {
                this.cachedValue = this.parse(this.defaultFormat);
            }
            return this.cachedValue;
        }

        @Override
        public int getDateType() {
            return this.dateType;
        }

        @Override
        public TemplateModel get(String pattern) {
            return new SimpleDate(this.parse(this.env.getDateFormatObject(this.dateType, pattern)), this.dateType);
        }

        @Override
        public Object exec(List arguments) {
            if (arguments.size() != 1) {
                throw new TemplateModelException("string?" + this.caller.getName() + "(...) requires exactly 1 argument.");
            }
            return this.get((String)arguments.get(0));
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        private Date parse(DateFormat df) throws TemplateModelException {
            try {
                return df.parse(this.text);
            }
            catch (ParseException e) {
                String mess = "Error: " + this.caller.getStartLocation() + "\nExpecting a date here, found: " + this.text;
                throw new TemplateModelException(mess);
            }
        }
    }
}

