/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.ArithmeticEngine;
import freemarker.core.ast.Expression;
import freemarker.core.ast.NonNumericalException;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

public class UnaryPlusMinusExpression
extends Expression {
    private Expression target;
    private boolean isMinus;
    private static final Integer MINUS_ONE = -1;

    public UnaryPlusMinusExpression(Expression target, boolean isMinus) {
        this.target = target;
        this.isMinus = isMinus;
        target.parent = this;
    }

    public Expression getTarget() {
        return this.target;
    }

    public boolean isMinus() {
        return this.isMinus;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        TemplateNumberModel targetModel = null;
        try {
            targetModel = (TemplateNumberModel)this.target.getAsTemplateModel(env);
        }
        catch (ClassCastException cce) {
            String msg = "Error " + this.getStartLocation();
            msg = msg + "\nExpression " + this.target + " is not numerical.";
            throw new NonNumericalException(msg, env);
        }
        if (!this.isMinus) {
            return targetModel;
        }
        Number n = targetModel.getAsNumber();
        n = ArithmeticEngine.CONSERVATIVE_ENGINE.multiply(MINUS_ONE, n);
        return new SimpleNumber(n);
    }

    @Override
    boolean isLiteral() {
        return this.target.isLiteral();
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new UnaryPlusMinusExpression(this.target.deepClone(name, subst), this.isMinus);
    }
}

