/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.Scope;
import freemarker.core.TemplateRunnable;
import freemarker.core.ast.ArgsList;
import freemarker.core.ast.EmptyArgsList;
import freemarker.core.ast.Expression;
import freemarker.core.ast.NamedArgsList;
import freemarker.core.ast.PositionalArgsList;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateNode;
import freemarker.core.helpers.NamedParameterListScope;
import freemarker.core.helpers.NamedParameterMapScope;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParameterList
extends TemplateNode {
    List<String> params = new ArrayList<String>();
    private Map<String, Expression> defaults;
    private String catchall;
    protected TemplateElement parent;

    public void addParam(String paramName) {
        this.params.add(paramName);
    }

    public List<String> getParamNames() {
        ArrayList<String> result = new ArrayList<String>(this.params);
        if (this.catchall != null) {
            result.add(this.catchall);
        }
        return result;
    }

    boolean containsParam(String name) {
        return this.params.contains(name);
    }

    public void addParam(String paramName, Expression defaultExp) {
        if (this.defaults == null) {
            this.defaults = new HashMap<String, Expression>();
        }
        this.defaults.put(paramName, defaultExp);
        this.addParam(paramName);
    }

    public void setCatchAll(String varname) {
        this.catchall = varname;
    }

    public String getCatchAll() {
        return this.catchall;
    }

    private boolean hasDefaultExpressions() {
        return this.defaults != null && !this.defaults.isEmpty();
    }

    public Expression getDefaultExpression(String paramName) {
        return this.defaults == null ? null : this.defaults.get(paramName);
    }

    public Expression getDefaultExpression(int paramIndex) {
        if (this.params == null || paramIndex >= this.params.size()) {
            return null;
        }
        return this.getDefaultExpression(this.params.get(paramIndex));
    }

    private void fillInDefaults(final Environment env, final Scope scope, final Collection<String> paramNames) {
        try {
            env.runInScope(scope, new TemplateRunnable<Object>(){

                @Override
                public Object run() throws TemplateException, IOException {
                    ParameterList.this.fillInDefaultsInternal(env, scope, paramNames);
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new TemplateException(e, env);
        }
    }

    private void fillInDefaultsInternal(Environment env, Scope scope, Collection<String> paramNames) {
        InvalidReferenceException firstReferenceException;
        Expression firstUnresolvedExpression;
        boolean hasUnresolvedArg;
        boolean resolvedAnArg;
        do {
            firstUnresolvedExpression = null;
            firstReferenceException = null;
            hasUnresolvedArg = false;
            resolvedAnArg = false;
            for (String paramName : paramNames) {
                TemplateModel arg = scope.get(paramName);
                if (arg != null) continue;
                Expression defaultExp = this.getDefaultExpression(paramName);
                if (defaultExp != null) {
                    try {
                        TemplateModel value = defaultExp.getAsTemplateModel(env);
                        if (value == null) {
                            if (hasUnresolvedArg) continue;
                            firstUnresolvedExpression = defaultExp;
                            hasUnresolvedArg = true;
                            continue;
                        }
                        scope.put(paramName, value);
                        resolvedAnArg = true;
                    }
                    catch (InvalidReferenceException e) {
                        if (hasUnresolvedArg) continue;
                        hasUnresolvedArg = true;
                        firstReferenceException = e;
                    }
                    continue;
                }
                if (arg != null) continue;
                throw new TemplateModelException("Missing required parameter " + paramName);
            }
        } while (resolvedAnArg && hasUnresolvedArg);
        if (hasUnresolvedArg) {
            if (firstReferenceException != null) {
                throw firstReferenceException;
            }
            assert (firstUnresolvedExpression != null);
            ParameterList.assertNonNull(null, firstUnresolvedExpression, scope.getEnvironment());
        }
    }

    List<TemplateModel> getParameterSequence(PositionalArgsList args, Environment env) {
        int i;
        ArrayList<TemplateModel> result = new ArrayList<TemplateModel>(this.params.size());
        int argsSize = args.size();
        int paramsSize = this.params.size();
        int commonSize = Math.min(argsSize, paramsSize);
        for (i = 0; i < commonSize; ++i) {
            result.add(args.getValueAt(i, env));
        }
        if (commonSize < argsSize) {
            if (this.catchall == null) {
                throw new TemplateException("Extraneous parameters provided; expected " + paramsSize + ", got " + argsSize, env);
            }
            for (i = commonSize; i < argsSize; ++i) {
                result.add(args.getValueAt(i, env));
            }
        } else if (commonSize < paramsSize) {
            NamedParameterListScope scope = new NamedParameterListScope(env.getCurrentScope(), this.params, result, false);
            this.fillInDefaults(env, scope, this.params.subList(args.size(), this.params.size()));
        }
        return result;
    }

    List<TemplateModel> getParameterSequence(NamedArgsList args, Environment env) {
        int paramsSize;
        int argsSize = args.size();
        if (argsSize > (paramsSize = this.params.size())) {
            LinkedHashSet<String> l = new LinkedHashSet<String>(args.getArgs().keySet());
            l.removeAll(this.params);
            throw new TemplateException("Extraneous parameters " + l, env);
        }
        ArrayList<TemplateModel> result = new ArrayList<TemplateModel>();
        LinkedList<String> unresolvedParamNames = null;
        Map<String, Expression> argsMap = args.getCopyOfMap();
        for (String paramName : this.params) {
            Expression argExp = argsMap.remove(paramName);
            if (argExp != null) {
                TemplateModel argModel = argExp.getAsTemplateModel(env);
                ParameterList.assertIsDefined(argModel, argExp, env);
                result.add(argModel);
                continue;
            }
            if (unresolvedParamNames == null) {
                unresolvedParamNames = new LinkedList<String>();
            }
            unresolvedParamNames.add(paramName);
        }
        if (unresolvedParamNames != null) {
            NamedParameterListScope scope = new NamedParameterListScope(env.getCurrentScope(), this.params, result, false);
            this.fillInDefaults(env, scope, unresolvedParamNames);
        }
        return result;
    }

    public Map<String, TemplateModel> getParameterMap(PositionalArgsList args, Environment env, boolean ignoreExtraParams) throws TemplateException {
        int argsSize = args.size();
        int paramsSize = this.params.size();
        HashMap<String, TemplateModel> result = new HashMap<String, TemplateModel>();
        if (this.catchall == null && argsSize > paramsSize && !ignoreExtraParams) {
            throw new TemplateException("Expecting exactly " + paramsSize + " arguments, received " + argsSize + ".", env);
        }
        int min = Math.min(paramsSize, argsSize);
        for (int i = 0; i < min; ++i) {
            result.put(this.params.get(i), args.getValueAt(i, env));
        }
        if (this.hasDefaultExpressions() && argsSize < paramsSize) {
            NamedParameterMapScope scope = new NamedParameterMapScope(env.getCurrentScope(), result);
            this.fillInDefaults(env, scope, this.params.subList(argsSize, paramsSize));
        }
        if (this.catchall != null) {
            SimpleSequence catchAllVars = new SimpleSequence();
            result.put(this.catchall, catchAllVars);
            for (int i = paramsSize; i < argsSize; ++i) {
                catchAllVars.add(args.getValueAt(i, env));
            }
        }
        return result;
    }

    public Map<String, TemplateModel> getParameterMap(NamedArgsList args, Environment env) throws TemplateException {
        HashMap<String, TemplateModel> result = new HashMap<String, TemplateModel>();
        LinkedList<String> unresolvedParamNames = null;
        Map<String, Expression> argsMap = args.getCopyOfMap();
        for (String paramName : this.params) {
            Expression argExp = argsMap.remove(paramName);
            if (argExp != null) {
                TemplateModel value = argExp.getAsTemplateModel(env);
                TemplateNode.assertIsDefined(value, argExp, env);
                result.put(paramName, value);
                continue;
            }
            if (this.defaults != null && this.defaults.containsKey(paramName)) {
                if (unresolvedParamNames == null) {
                    unresolvedParamNames = new LinkedList<String>();
                }
                unresolvedParamNames.add(paramName);
                continue;
            }
            throw new TemplateException("Missing required parameter " + paramName, env);
        }
        if (unresolvedParamNames != null) {
            NamedParameterMapScope scope = new NamedParameterMapScope(env.getCurrentScope(), result);
            this.fillInDefaults(env, scope, unresolvedParamNames);
        }
        SimpleHash catchAllMap = null;
        if (this.catchall != null) {
            catchAllMap = new SimpleHash();
            result.put(this.catchall, catchAllMap);
        }
        if (!argsMap.isEmpty()) {
            if (this.catchall != null) {
                for (Map.Entry<String, Expression> entry : argsMap.entrySet()) {
                    Expression exp = entry.getValue();
                    TemplateModel val = exp.getAsTemplateModel(env);
                    ParameterList.assertIsDefined(val, exp, env);
                    catchAllMap.put(entry.getKey(), val);
                }
            } else {
                throw new TemplateException("Extraneous parameters " + argsMap.keySet() + " provided.", env);
            }
        }
        return result;
    }

    public Map<String, TemplateModel> getParameterMapForEmptyArgs(Environment env) throws TemplateException {
        HashMap<String, TemplateModel> result = new HashMap<String, TemplateModel>();
        if (this.hasDefaultExpressions()) {
            NamedParameterMapScope scope = new NamedParameterMapScope(env.getCurrentScope(), result);
            this.fillInDefaults(env, scope, this.defaults.keySet());
        }
        return result;
    }

    public Map<String, TemplateModel> getParameterMap(ArgsList args, Environment env) {
        if (args instanceof NamedArgsList) {
            return this.getParameterMap((NamedArgsList)args, env);
        }
        if (args instanceof PositionalArgsList) {
            return this.getParameterMap((PositionalArgsList)args, env, false);
        }
        if (args instanceof EmptyArgsList) {
            return this.getParameterMapForEmptyArgs(env);
        }
        throw new AssertionError();
    }

    String toDebugString() {
        StringBuilder b = new StringBuilder();
        for (String argName : this.params) {
            b.append(argName);
            Expression exp = this.getDefaultExpression(argName);
            if (exp != null) {
                b.append('=');
                b.append(exp);
            }
            b.append(' ');
        }
        return b.toString();
    }

    public TemplateElement getParent() {
        return this.parent;
    }
}

