/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.EvaluationUtil;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;

public class NumericalOutput
extends TemplateElement {
    private Expression expression;
    private int minFracDigits;
    private int maxFracDigits;
    private String formatString;
    private volatile FormatHolder formatCache;

    public NumericalOutput(Expression expression) {
        this.expression = expression;
    }

    public NumericalOutput(Expression expression, String format) {
        this.expression = expression;
        this.formatString = format;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void parseFormat() {
        if (this.formatString == null) {
            return;
        }
        int minFrac = -1;
        int maxFrac = -1;
        StringTokenizer st = new StringTokenizer(this.formatString, "mM", true);
        int type = 45;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (type != 45) {
                switch (type) {
                    case 109: {
                        if (minFrac != -1) {
                            throw new IllegalArgumentException("Invalid formatting string");
                        }
                        minFrac = Integer.parseInt(token);
                        break;
                    }
                    case 77: {
                        if (maxFrac != -1) {
                            throw new IllegalArgumentException("Invalid formatting string");
                        }
                        maxFrac = Integer.parseInt(token);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid formatting string.");
                    }
                }
                type = 45;
                continue;
            }
            if (token.equals("m")) {
                type = 109;
                continue;
            }
            if (token.equals("M")) {
                type = 77;
                continue;
            }
            throw new IllegalArgumentException(this.formatString);
        }
        if (maxFrac == -1) {
            if (minFrac == -1) {
                throw new IllegalArgumentException("Invalid formatting string.");
            }
            maxFrac = minFrac;
        } else if (minFrac == -1) {
            minFrac = 0;
        }
        if (minFrac > maxFrac) {
            throw new IllegalArgumentException("The minimum digits cannot be greater than maximum.");
        }
        if (minFrac > 50 || maxFrac > 50) {
            throw new IllegalArgumentException("\nCannot specify more than 50 fraction digits");
        }
        this.minFracDigits = minFrac;
        this.maxFracDigits = maxFrac;
    }

    public String getFormatString() {
        return this.formatString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        Number num = EvaluationUtil.getNumber(this.expression, env);
        FormatHolder fmth = this.formatCache;
        if (fmth == null || !fmth.locale.equals(env.getLocale())) {
            NumericalOutput numericalOutput = this;
            synchronized (numericalOutput) {
                fmth = this.formatCache;
                if (fmth == null || !fmth.locale.equals(env.getLocale())) {
                    NumberFormat fmt = NumberFormat.getNumberInstance(env.getLocale());
                    if (this.formatString != null) {
                        fmt.setMinimumFractionDigits(this.minFracDigits);
                        fmt.setMaximumFractionDigits(this.maxFracDigits);
                    } else {
                        fmt.setMinimumFractionDigits(0);
                        fmt.setMaximumFractionDigits(50);
                    }
                    fmt.setGroupingUsed(false);
                    fmth = this.formatCache = new FormatHolder(fmt, env.getLocale());
                }
            }
        }
        env.getOut().write(fmth.format.format(num));
    }

    @Override
    public String getDescription() {
        return this.getSource();
    }

    private static class FormatHolder {
        final NumberFormat format;
        final Locale locale;

        FormatHolder(NumberFormat format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }
    }
}

