/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.template.SimpleNumber;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;

public class NumberLiteral
extends Expression
implements TemplateNumberModel {
    private Number value;

    public NumberLiteral(Number value) {
        this.value = value;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        return new SimpleNumber(this.value);
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public String getStringValue(Environment env) {
        return env.formatNumber(this.value);
    }

    @Override
    public Number getAsNumber() {
        return this.value;
    }

    String getName() {
        return "the number: '" + this.value + "'";
    }

    @Override
    boolean isLiteral() {
        return true;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new NumberLiteral(this.value);
    }
}

