/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.InvalidReferenceException;
import freemarker.core.ast.Expression;
import freemarker.core.ast.ParentheticalExpression;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.util.ArrayList;

public class DefaultToExpression
extends Expression {
    private static final TemplateCollectionModel EMPTY_COLLECTION = new SimpleCollection(new ArrayList(0));
    static final TemplateModel EMPTY_STRING_AND_SEQUENCE = new EmptyStringAndSequence();
    private Expression lhs;
    private Expression rhs;

    public DefaultToExpression(Expression lhs, Expression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
        lhs.parent = this;
        if (rhs != null) {
            rhs.parent = this;
        }
    }

    public Expression getLeft() {
        return this.lhs;
    }

    public Expression getRight() {
        return this.rhs;
    }

    @Override
    TemplateModel _getAsTemplateModel(Environment env) {
        TemplateModel left;
        block4: {
            left = null;
            try {
                left = this.lhs.getAsTemplateModel(env);
            }
            catch (InvalidReferenceException ire) {
                if (this.lhs instanceof ParentheticalExpression) break block4;
                throw ire;
            }
        }
        if (left != null && left != TemplateModel.JAVA_NULL) {
            return left;
        }
        if (this.rhs == null) {
            return EMPTY_STRING_AND_SEQUENCE;
        }
        return this.rhs.getAsTemplateModel(env);
    }

    @Override
    boolean isLiteral() {
        return false;
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        if (this.rhs == null) {
            return new DefaultToExpression(this.lhs.deepClone(name, subst), null);
        }
        return new DefaultToExpression(this.lhs.deepClone(name, subst), this.rhs.deepClone(name, subst));
    }

    private static class EmptyStringAndSequence
    implements TemplateScalarModel,
    TemplateSequenceModel,
    TemplateHashModelEx {
        private EmptyStringAndSequence() {
        }

        @Override
        public String getAsString() {
            return "";
        }

        @Override
        public TemplateModel get(int i) {
            return null;
        }

        @Override
        public TemplateModel get(String s) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public TemplateCollectionModel keys() {
            return EMPTY_COLLECTION;
        }

        @Override
        public TemplateCollectionModel values() {
            return EMPTY_COLLECTION;
        }
    }
}

