/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.Scope;
import freemarker.template.Template;
import freemarker.template.TemplateModel;

public abstract class AbstractScope
implements Scope {
    private final Scope enclosingScope;

    protected AbstractScope(Scope enclosingScope) {
        if (enclosingScope == null) {
            throw new IllegalArgumentException("enclosingScope == null");
        }
        this.enclosingScope = enclosingScope;
    }

    @Override
    public final Scope getEnclosingScope() {
        return this.enclosingScope;
    }

    @Override
    public Template getTemplate() {
        return this.enclosingScope.getTemplate();
    }

    @Override
    public Environment getEnvironment() {
        return this.enclosingScope.getEnvironment();
    }

    @Override
    public final TemplateModel resolveVariable(String key) {
        TemplateModel result = this.get(key);
        if (result == null) {
            return this.enclosingScope.resolveVariable(key);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() != 0;
    }
}

