/*
 * Decompiled with CFR 0.152.
 */
package org.parsers.csharp.ppline;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CancellationException;
import org.parsers.csharp.ppline.NonTerminalCall;
import org.parsers.csharp.ppline.PPDirectiveLineLexer;
import org.parsers.csharp.ppline.ParseException;
import org.parsers.csharp.ppline.Token;
import org.parsers.csharp.ppline.TokenSource;

public class PPDirectiveLineParser {
    private Set<String> symbols = new HashSet<String>();
    static final int UNLIMITED = Integer.MAX_VALUE;
    Token lastConsumedToken;
    private Token.TokenType nextTokenType;
    private Token currentLookaheadToken;
    private String currentlyParsedProduction;
    private String currentLookaheadProduction;
    EnumSet<Token.TokenType> outerFollowSet;
    private final Token DUMMY_START_TOKEN = new Token();
    private boolean cancelled;
    private PPDirectiveLineLexer token_source;
    private static HashMap<Token.TokenType[], EnumSet<Token.TokenType>> enumSetCache = new HashMap();
    private static final EnumSet<Token.TokenType> first_set$PPDirectiveLine_ccc$96$8 = PPDirectiveLineParser.tokenTypeSet(Token.TokenType.IF, Token.TokenType.ELIF, Token.TokenType.DEFINE, Token.TokenType.ELSE, Token.TokenType.ENDIF, Token.TokenType.IGNORED_DIRECTIVE, Token.TokenType.UNKNOWN_DIRECTIVE);
    private static final EnumSet<Token.TokenType> first_set$PPDirectiveLine_ccc$154$10 = PPDirectiveLineParser.tokenTypeSet(Token.TokenType.EQUALS, Token.TokenType.NOT_EQUALS);
    private static final EnumSet<Token.TokenType> first_set$PPDirectiveLine_ccc$193$7 = PPDirectiveLineParser.tokenTypeSet(Token.TokenType.TRUE, Token.TokenType.FALSE, Token.TokenType.IDENTIFIER, Token.TokenType.LPAREN);
    private ArrayList<NonTerminalCall> parsingStack = new ArrayList();
    private ArrayList<NonTerminalCall> lookaheadStack = new ArrayList();

    public static Info evaluate(String input, Set<String> symbols) {
        PPDirectiveLineParser parser = new PPDirectiveLineParser(input);
        parser.symbols = symbols;
        try {
            return parser.DirectiveLine();
        }
        catch (ParseException parseException) {
            return new Info(DirectiveType.UNKNOWN, false);
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setInputSource(String inputSource) {
        this.token_source.setInputSource(inputSource);
    }

    String getInputSource() {
        return this.token_source.getInputSource();
    }

    public PPDirectiveLineParser(String inputSource, CharSequence content) {
        this(new PPDirectiveLineLexer(inputSource, content));
    }

    public PPDirectiveLineParser(CharSequence content) {
        this("input", content);
    }

    public PPDirectiveLineParser(String inputSource, Path path) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path)));
    }

    public PPDirectiveLineParser(String inputSource, Path path, Charset charset) throws IOException {
        this(inputSource, TokenSource.stringFromBytes(Files.readAllBytes(path), charset));
    }

    public PPDirectiveLineParser(Path path) throws IOException {
        this(path.toString(), path);
    }

    public PPDirectiveLineParser(PPDirectiveLineLexer lexer) {
        this.token_source = lexer;
        this.lastConsumedToken = this.DUMMY_START_TOKEN;
        this.lastConsumedToken.setTokenSource(lexer);
    }

    public void setStartingPos(int startingLine, int startingColumn) {
        this.token_source.setStartingPos(startingLine, startingColumn);
    }

    private final Token nextToken(Token tok) {
        Token result = this.token_source.getNextToken(tok);
        while (result.isUnparsed()) {
            result = this.token_source.getNextToken(result);
        }
        this.nextTokenType = null;
        return result;
    }

    public final Token getNextToken() {
        return this.getToken(1);
    }

    public final Token getToken(int index) {
        int i;
        Token t = this.currentLookaheadToken == null ? this.lastConsumedToken : this.currentLookaheadToken;
        for (i = 0; i < index; ++i) {
            t = this.nextToken(t);
        }
        for (i = 0; i > index && (t = t.getPrevious()) != null; --i) {
        }
        return t;
    }

    private final Token.TokenType nextTokenType() {
        if (this.nextTokenType == null) {
            this.nextTokenType = this.nextToken(this.lastConsumedToken).getType();
        }
        return this.nextTokenType;
    }

    boolean activateTokenTypes(Token.TokenType ... types) {
        if (this.token_source.activeTokenTypes == null) {
            return false;
        }
        boolean result = false;
        for (Token.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.add(tt);
        }
        if (result) {
            this.token_source.reset(this.getToken(0));
            this.nextTokenType = null;
        }
        return result;
    }

    boolean deactivateTokenTypes(Token.TokenType ... types) {
        boolean result = false;
        if (this.token_source.activeTokenTypes == null) {
            this.token_source.activeTokenTypes = EnumSet.allOf(Token.TokenType.class);
        }
        for (Token.TokenType tt : types) {
            result |= this.token_source.activeTokenTypes.remove((Object)tt);
        }
        if (result) {
            this.token_source.reset(this.getToken(0));
            this.nextTokenType = null;
        }
        return result;
    }

    private static EnumSet<Token.TokenType> tokenTypeSet(Token.TokenType first, Token.TokenType ... rest) {
        Token.TokenType[] key = new Token.TokenType[1 + rest.length];
        key[0] = first;
        if (rest.length > 0) {
            System.arraycopy(rest, 0, key, 1, rest.length);
        }
        Arrays.sort((Object[])key);
        if (enumSetCache.containsKey(key)) {
            return enumSetCache.get(key);
        }
        EnumSet<Token.TokenType> result = rest.length == 0 ? EnumSet.of(first) : EnumSet.of(first, rest);
        enumSetCache.put(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Info DirectiveLine() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "DirectiveLine";
        boolean result = false;
        DirectiveType directiveType = DirectiveType.UNKNOWN;
        if (this.nextTokenType() == Token.TokenType.IF) {
            this.pushOntoCallStack("DirectiveLine", "examples/csharp/PPDirectiveLine.ccc", 96, 8);
            try {
                result = this.IfDirective();
            }
            finally {
                this.popCallStack();
            }
            directiveType = DirectiveType.IF;
        } else if (this.nextTokenType() == Token.TokenType.ELIF) {
            this.pushOntoCallStack("DirectiveLine", "examples/csharp/PPDirectiveLine.ccc", 98, 8);
            try {
                result = this.ElifDirective();
            }
            finally {
                this.popCallStack();
            }
            directiveType = DirectiveType.ELIF;
        } else if (this.nextTokenType() == Token.TokenType.ELSE) {
            this.consumeToken(Token.TokenType.ELSE);
            directiveType = DirectiveType.ELSE;
        } else if (this.nextTokenType() == Token.TokenType.ENDIF) {
            this.consumeToken(Token.TokenType.ENDIF);
            directiveType = DirectiveType.ENDIF;
        } else if (this.nextTokenType() == Token.TokenType.DEFINE) {
            this.pushOntoCallStack("DirectiveLine", "examples/csharp/PPDirectiveLine.ccc", 104, 8);
            try {
                this.DefineDirective();
            }
            finally {
                this.popCallStack();
            }
            directiveType = DirectiveType.DEFINE;
        } else if (this.nextTokenType() == Token.TokenType.DEFINE) {
            this.pushOntoCallStack("DirectiveLine", "examples/csharp/PPDirectiveLine.ccc", 106, 8);
            try {
                this.UndefDirective();
            }
            finally {
                this.popCallStack();
            }
            directiveType = DirectiveType.UNDEF;
        } else if (this.nextTokenType() == Token.TokenType.IGNORED_DIRECTIVE) {
            this.consumeToken(Token.TokenType.IGNORED_DIRECTIVE);
            directiveType = DirectiveType.IGNORED;
        } else if (this.nextTokenType() == Token.TokenType.UNKNOWN_DIRECTIVE) {
            this.consumeToken(Token.TokenType.UNKNOWN_DIRECTIVE);
            directiveType = DirectiveType.UNKNOWN;
        } else {
            this.pushOntoCallStack("DirectiveLine", "examples/csharp/PPDirectiveLine.ccc", 96, 8);
            throw new ParseException(this.lastConsumedToken, first_set$PPDirectiveLine_ccc$96$8, this.parsingStack);
        }
        return new Info(directiveType, result);
    }

    public final boolean IfDirective() {
        boolean result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "IfDirective";
        this.consumeToken(Token.TokenType.IF);
        this.pushOntoCallStack("IfDirective", "examples/csharp/PPDirectiveLine.ccc", 120, 5);
        try {
            result = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.EOL);
        return result;
    }

    public final void DefineDirective() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "DefineDirective";
        this.consumeToken(Token.TokenType.DEFINE);
        this.consumeToken(Token.TokenType.IDENTIFIER);
        this.symbols.add(this.lastConsumedToken.getImage());
    }

    public final void UndefDirective() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "UndefDirective";
        this.consumeToken(Token.TokenType.DEFINE);
        this.consumeToken(Token.TokenType.IDENTIFIER);
        this.symbols.remove(this.lastConsumedToken.getImage());
    }

    public final boolean ElifDirective() {
        boolean result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "ElifDirective";
        this.consumeToken(Token.TokenType.ELIF);
        this.pushOntoCallStack("ElifDirective", "examples/csharp/PPDirectiveLine.ccc", 142, 5);
        try {
            result = this.Expression();
        }
        finally {
            this.popCallStack();
        }
        this.consumeToken(Token.TokenType.EOL);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean Expression() {
        boolean result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "Expression";
        boolean inequality = false;
        this.pushOntoCallStack("Expression", "examples/csharp/PPDirectiveLine.ccc", 152, 5);
        try {
            result = this.OrExpression();
        }
        finally {
            this.popCallStack();
        }
        if (this.nextTokenType() == Token.TokenType.EQUALS || this.nextTokenType == Token.TokenType.NOT_EQUALS) {
            boolean result2;
            if (this.nextTokenType() == Token.TokenType.EQUALS) {
                this.consumeToken(Token.TokenType.EQUALS);
            } else if (this.nextTokenType() == Token.TokenType.NOT_EQUALS) {
                this.consumeToken(Token.TokenType.NOT_EQUALS);
                inequality = true;
            } else {
                this.pushOntoCallStack("Expression", "examples/csharp/PPDirectiveLine.ccc", 154, 10);
                throw new ParseException(this.lastConsumedToken, first_set$PPDirectiveLine_ccc$154$10, this.parsingStack);
            }
            this.pushOntoCallStack("Expression", "examples/csharp/PPDirectiveLine.ccc", 155, 9);
            try {
                result2 = this.OrExpression();
            }
            finally {
                this.popCallStack();
            }
            result = inequality ? result != result2 : result == result2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean OrExpression() {
        boolean result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "OrExpression";
        this.pushOntoCallStack("OrExpression", "examples/csharp/PPDirectiveLine.ccc", 163, 5);
        try {
            result = this.AndExpression();
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == Token.TokenType.OR) {
            boolean result2;
            this.consumeToken(Token.TokenType.OR);
            this.pushOntoCallStack("OrExpression", "examples/csharp/PPDirectiveLine.ccc", 166, 9);
            try {
                result2 = this.AndExpression();
            }
            finally {
                this.popCallStack();
            }
            result = result && result2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean AndExpression() {
        boolean result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "AndExpression";
        this.pushOntoCallStack("AndExpression", "examples/csharp/PPDirectiveLine.ccc", 174, 5);
        try {
            result = this.NotExpression();
        }
        finally {
            this.popCallStack();
        }
        while (this.nextTokenType() == Token.TokenType.AND) {
            boolean result2;
            this.consumeToken(Token.TokenType.AND);
            this.pushOntoCallStack("AndExpression", "examples/csharp/PPDirectiveLine.ccc", 177, 9);
            try {
                result2 = this.NotExpression();
            }
            finally {
                this.popCallStack();
            }
            result = result && result2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean NotExpression() {
        boolean result;
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "NotExpression";
        boolean notFlag = false;
        while (this.nextTokenType() == Token.TokenType.NOT) {
            this.consumeToken(Token.TokenType.NOT);
            notFlag = !notFlag;
        }
        this.pushOntoCallStack("NotExpression", "examples/csharp/PPDirectiveLine.ccc", 186, 5);
        try {
            result = this.PrimaryExpression();
        }
        finally {
            this.popCallStack();
        }
        return notFlag ? !result : result;
    }

    public final boolean PrimaryExpression() {
        if (this.cancelled) {
            throw new CancellationException();
        }
        String prevProduction = this.currentlyParsedProduction;
        this.currentlyParsedProduction = "PrimaryExpression";
        boolean result = false;
        if (this.nextTokenType() == Token.TokenType.IDENTIFIER) {
            this.consumeToken(Token.TokenType.IDENTIFIER);
            result = this.symbols.contains(this.lastConsumedToken.getImage());
        } else if (this.nextTokenType() == Token.TokenType.TRUE) {
            this.consumeToken(Token.TokenType.TRUE);
            result = true;
        } else if (this.nextTokenType() == Token.TokenType.FALSE) {
            this.consumeToken(Token.TokenType.FALSE);
            result = false;
        } else if (this.nextTokenType() == Token.TokenType.LPAREN) {
            this.consumeToken(Token.TokenType.LPAREN);
            this.pushOntoCallStack("PrimaryExpression", "examples/csharp/PPDirectiveLine.ccc", 199, 11);
            try {
                result = this.Expression();
            }
            finally {
                this.popCallStack();
            }
            this.consumeToken(Token.TokenType.RPAREN);
        } else {
            this.pushOntoCallStack("PrimaryExpression", "examples/csharp/PPDirectiveLine.ccc", 193, 7);
            throw new ParseException(this.lastConsumedToken, first_set$PPDirectiveLine_ccc$193$7, this.parsingStack);
        }
        return result;
    }

    private final void pushOntoCallStack(String methodName, String fileName, int line, int column) {
        this.parsingStack.add(new NonTerminalCall("PPDirectiveLineParser", this.token_source, fileName, methodName, line, column, null));
    }

    private final void popCallStack() {
        NonTerminalCall ntc = this.parsingStack.remove(this.parsingStack.size() - 1);
        this.currentlyParsedProduction = ntc.productionName;
    }

    void dumpLookaheadStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.lookaheadStack.listIterator(this.lookaheadStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpCallStack(PrintStream ps) {
        ListIterator<NonTerminalCall> it = this.parsingStack.listIterator(this.parsingStack.size());
        while (it.hasPrevious()) {
            it.previous().dump(ps);
        }
    }

    void dumpLookaheadCallStack(PrintStream ps) {
        ps.println("Current Parser Production is: " + this.currentlyParsedProduction);
        ps.println("Current Lookahead Production is: " + this.currentLookaheadProduction);
        ps.println("---Lookahead Stack---");
        this.dumpLookaheadStack(ps);
        ps.println("---Call Stack---");
        this.dumpCallStack(ps);
    }

    public boolean isParserTolerant() {
        return false;
    }

    public void setParserTolerant(boolean tolerantParsing) {
        if (tolerantParsing) {
            throw new UnsupportedOperationException("This parser was not built with that feature!");
        }
    }

    private Token consumeToken(Token.TokenType expectedType) {
        Token nextToken = this.nextToken(this.lastConsumedToken);
        if (nextToken.getType() != expectedType) {
            nextToken = this.handleUnexpectedTokenType(expectedType, nextToken);
        }
        this.lastConsumedToken = nextToken;
        this.nextTokenType = null;
        return this.lastConsumedToken;
    }

    private Token handleUnexpectedTokenType(Token.TokenType expectedType, Token nextToken) {
        throw new ParseException(nextToken, EnumSet.of(expectedType), this.parsingStack);
    }

    public boolean isTreeBuildingEnabled() {
        return false;
    }

    public static class Info {
        public final DirectiveType directiveType;
        public final boolean evaluationResult;

        Info(DirectiveType directiveType, boolean evaluationResult) {
            this.directiveType = directiveType;
            this.evaluationResult = evaluationResult;
        }
    }

    public static enum DirectiveType {
        IF,
        ELIF,
        ELSE,
        ENDIF,
        DEFINE,
        UNDEF,
        IGNORED,
        UNKNOWN;

    }
}

