/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.congocc.app.AppSettings;
import org.congocc.app.Errors;
import org.congocc.core.Grammar;
import org.congocc.parser.CongoCCLexer;
import org.congocc.parser.Node;
import org.congocc.parser.Token;
import org.congocc.parser.TokenSource;

public class BaseNode
implements Node {
    private Grammar grammar;
    private CongoCCLexer tokenSource;
    private static Class<? extends List> listClass;
    private Node parent;
    private List<Node> children = this.newList();
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;
    private Map<String, Node> namedChildMap;
    private Map<String, List<Node>> namedChildListMap;

    protected void setChildren(List<Node> children) {
        this.children = children;
    }

    @Override
    public Grammar getGrammar() {
        if (this.grammar == null) {
            if (this.parent != null) {
                this.grammar = this.parent.getGrammar();
            }
            if (this.grammar == null && !this.children.isEmpty()) {
                this.grammar = this.children.get(0).getGrammar();
            }
        }
        return this.grammar;
    }

    @Override
    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public AppSettings getAppSettings() {
        return this.getGrammar().getAppSettings();
    }

    public Errors getErrors() {
        return this.getGrammar().getErrors();
    }

    public String getSimpleName() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Node prevToken = null;
        for (Node.TerminalNode terminalNode : this.getAllTokens(true)) {
            if (prevToken != null && prevToken.getEndOffset() != terminalNode.getBeginOffset()) {
                buf.append(" ");
            }
            buf.append(terminalNode);
            prevToken = terminalNode;
        }
        return buf.toString();
    }

    @Override
    public String getInputSource() {
        return this.getTokenSource().getInputSource();
    }

    @Override
    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    @Override
    public int getBeginLine() {
        CongoCCLexer tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getLineFromOffset(this.getBeginOffset());
    }

    @Override
    public int getBeginColumn() {
        CongoCCLexer tokenSource = this.getTokenSource();
        return tokenSource == null ? 0 : tokenSource.getCodePointColumnFromOffset(this.getBeginOffset());
    }

    @Override
    public CongoCCLexer getTokenSource() {
        if (this.tokenSource == null) {
            for (Node child : this.children()) {
                if (child.getTokenSource() instanceof CongoCCLexer) {
                    this.tokenSource = (CongoCCLexer)child.getTokenSource();
                }
                if (this.tokenSource == null) continue;
                break;
            }
        }
        return this.tokenSource;
    }

    @Override
    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (CongoCCLexer)tokenSource;
    }

    public static void setListClass(Class<? extends List> listClass) {
        BaseNode.listClass = listClass;
    }

    private List<Node> newList() {
        if (listClass == null) {
            return new ArrayList<Node>();
        }
        try {
            return listClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isUnparsed() {
        return this.unparsed;
    }

    @Override
    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    @Override
    public void setParent(Node n) {
        this.parent = n;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    @Override
    public void addChild(Node n) {
        this.children.add(n);
        n.setParent(this);
    }

    @Override
    public void addChild(int i, Node n) {
        this.children.add(i, n);
        n.setParent(this);
    }

    @Override
    public Node getChild(int i) {
        return this.children.get(i);
    }

    @Override
    public void setChild(int i, Node n) {
        this.children.set(i, n);
        n.setParent(this);
    }

    @Override
    public Node removeChild(int i) {
        return this.children.remove(i);
    }

    @Override
    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public List<Node> children() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public int getBeginOffset() {
        return this.beginOffset;
    }

    @Override
    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public List<Token> getRealTokens() {
        return this.descendants(Token.class, t -> !t.isUnparsed());
    }

    @Override
    public Node getNamedChild(String name) {
        if (this.namedChildMap == null) {
            return null;
        }
        return this.namedChildMap.get(name);
    }

    @Override
    public void setNamedChild(String name, Node node) {
        if (this.namedChildMap == null) {
            this.namedChildMap = new HashMap<String, Node>();
        }
        if (this.namedChildMap.containsKey(name)) {
            String msg = String.format("Duplicate named child not allowed: {0}", name);
            throw new RuntimeException(msg);
        }
        this.namedChildMap.put(name, node);
    }

    @Override
    public List<Node> getNamedChildList(String name) {
        if (this.namedChildListMap == null) {
            return null;
        }
        return this.namedChildListMap.get(name);
    }

    @Override
    public void addToNamedChildList(String name, Node node) {
        List<Node> nodeList;
        if (this.namedChildListMap == null) {
            this.namedChildListMap = new HashMap<String, List<Node>>();
        }
        if ((nodeList = this.namedChildListMap.get(name)) == null) {
            nodeList = new ArrayList<Node>();
            this.namedChildListMap.put(name, nodeList);
        }
        nodeList.add(node);
    }
}

