/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.parser.python.ast;

import java.util.ArrayList;
import java.util.List;
import org.congocc.parser.python.PythonLexer;
import org.congocc.parser.python.PythonToken;

public class IndentToken
extends PythonToken {
    private List<Integer> indents;

    public static PythonToken makeIndentToken(PythonToken followingToken, PythonLexer tokenSource, List<Integer> indents) {
        IndentToken result = new IndentToken(PythonToken.TokenType.INDENT, tokenSource, 0, 0);
        result.indents = new ArrayList<Integer>(indents.size());
        result.indents.addAll(indents);
        followingToken.preInsert(result);
        return result;
    }

    @Override
    public List<Integer> getIndents() {
        return new ArrayList<Integer>(this.indents);
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public int getIndentAmount() {
        return this.indents.get(this.indents.size() - 1) - this.indents.get(this.indents.size() - 2);
    }

    public IndentToken(PythonToken.TokenType type, PythonLexer tokenSource, int beginOffset, int endOffset) {
        super(type, tokenSource, beginOffset, endOffset);
    }
}

