/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen.python;

import org.congocc.parser.Node;
import org.congocc.parser.python.PythonToken;
import org.congocc.parser.python.ast.DedentToken;
import org.congocc.parser.python.ast.IndentToken;
import org.congocc.parser.python.ast.Newline;
import org.congocc.parser.python.ast.PythonNode;

public class PythonFormatter
extends Node.Visitor {
    private static final String defaultIndent = "    ";
    private String currentIndent;
    private StringBuilder buffer;

    public PythonFormatter() {
        this.visitUnparsedTokens = true;
        this.currentIndent = "";
    }

    public String format(PythonNode code, int indentLevel) {
        this.buffer = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            this.currentIndent = this.currentIndent + defaultIndent;
        }
        this.visit(code);
        return this.buffer.toString();
    }

    public String format(PythonNode code) {
        return this.format(code, 0);
    }

    void visit(IndentToken it) {
        this.buffer.append(defaultIndent);
        this.currentIndent = this.currentIndent + defaultIndent;
    }

    void visit(DedentToken dt) {
        this.currentIndent = this.currentIndent.substring(0, this.currentIndent.length() - defaultIndent.length());
        this.buffer.setLength(this.buffer.length() - defaultIndent.length());
    }

    void visit(Newline nl) {
        this.buffer.append("\n");
        this.buffer.append(this.currentIndent);
    }

    void visit(PythonToken tok) {
        this.addSpaceIfNecessary();
        this.buffer.append(tok.getImage());
        this.addSpaceIfNecessary();
    }

    private void addSpaceIfNecessary() {
        if (this.buffer.length() == 0) {
            return;
        }
        int lastChar = this.buffer.codePointBefore(this.buffer.length());
        if (!Character.isWhitespace(lastChar)) {
            this.buffer.append(' ');
        }
    }
}

