/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.congocc.app.AppSettings;
import org.congocc.codegen.Sequencer;
import org.congocc.codegen.Translator;
import org.congocc.core.Grammar;
import org.congocc.core.LexerData;
import org.congocc.core.RegularExpression;
import org.congocc.parser.CongoCCParser;
import org.congocc.parser.Node;
import org.congocc.parser.tree.ClassDeclaration;
import org.congocc.parser.tree.ClassOrInterfaceBodyDeclaration;
import org.congocc.parser.tree.CodeBlock;
import org.congocc.parser.tree.ConstructorDeclaration;
import org.congocc.parser.tree.Delimiter;
import org.congocc.parser.tree.EnumDeclaration;
import org.congocc.parser.tree.FieldDeclaration;
import org.congocc.parser.tree.FormalParameter;
import org.congocc.parser.tree.FormalParameters;
import org.congocc.parser.tree.Identifier;
import org.congocc.parser.tree.ImportDeclaration;
import org.congocc.parser.tree.Initializer;
import org.congocc.parser.tree.MethodDeclaration;
import org.congocc.parser.tree.ObjectType;
import org.congocc.parser.tree.Statement;
import org.congocc.parser.tree.VariableDeclarator;

public class TemplateGlobals {
    private Grammar grammar;
    private LexerData lexerData;
    private AppSettings appSettings;
    private Translator translator;
    private List<String> nodeVariableNameStack = new ArrayList<String>();

    public TemplateGlobals(Grammar grammar) {
        this.grammar = grammar;
        this.lexerData = grammar.getLexerData();
        this.appSettings = grammar.getAppSettings();
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    public void pushNodeVariableName(String nodeName) {
        this.nodeVariableNameStack.add(nodeName);
    }

    public void popNodeVariableName() {
        this.nodeVariableNameStack.remove(this.nodeVariableNameStack.size() - 1);
    }

    public boolean nodeIsInterface(String nodeName) {
        return this.grammar.nodeIsInterface(nodeName);
    }

    public String addEscapes(String str) {
        StringBuilder retval = new StringBuilder();
        block10: for (int ch : str.codePoints().toArray()) {
            switch (ch) {
                case 8: {
                    retval.append("\\b");
                    continue block10;
                }
                case 9: {
                    retval.append("\\t");
                    continue block10;
                }
                case 10: {
                    retval.append("\\n");
                    continue block10;
                }
                case 12: {
                    retval.append("\\f");
                    continue block10;
                }
                case 13: {
                    retval.append("\\r");
                    continue block10;
                }
                case 34: {
                    retval.append("\\\"");
                    continue block10;
                }
                case 39: {
                    retval.append("\\'");
                    continue block10;
                }
                case 92: {
                    retval.append("\\\\");
                    continue block10;
                }
                default: {
                    if (Character.isISOControl(ch)) {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block10;
                    }
                    retval.appendCodePoint(ch);
                    continue block10;
                }
            }
        }
        return retval.toString();
    }

    public String getPreprocessorSymbol(String key, String defaultValue) {
        return this.grammar.getPreprocessorSymbols().getOrDefault(key, defaultValue);
    }

    public String displayChar(int ch) {
        if (ch == 39) {
            return "'\\''";
        }
        if (ch == 92) {
            return "'\\\\'";
        }
        if (ch == 9) {
            return "'\\t'";
        }
        if (ch == 13) {
            return "'\\r'";
        }
        if (ch == 10) {
            return "'\\n'";
        }
        if (ch == 12) {
            return "'\\f'";
        }
        if (ch == 32) {
            return "' '";
        }
        if (ch < 128 && !Character.isWhitespace(ch) && !Character.isISOControl(ch)) {
            return "'" + (char)ch + "'";
        }
        String s = "0x" + Integer.toHexString(ch);
        if (this.appSettings.getCodeLang().equals("python")) {
            s = String.format("as_chr(%s)", s);
        }
        return s;
    }

    public String displayChars(int[] char_array) {
        StringBuilder sb = new StringBuilder();
        int n = char_array.length;
        sb.append('[');
        for (int i = 0; i < n; ++i) {
            sb.append(this.displayChar(char_array[i]));
            if (i >= n - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> tokenSubClassInfo() {
        HashMap tokenClassMap = new HashMap();
        HashMap<Object, String> superClassMap = new HashMap<Object, String>();
        for (RegularExpression regularExpression : this.lexerData.getOrderedNamedTokens()) {
            void var6_8;
            if (regularExpression.isPrivate()) continue;
            String tokenClassName = regularExpression.getGeneratedClassName();
            String string = regularExpression.getGeneratedSuperClassName();
            if (string == null) {
                String string2 = "Token";
            } else if (!superClassMap.containsKey(string)) {
                superClassMap.put(string, null);
            }
            if (tokenClassMap.containsKey(tokenClassName)) continue;
            tokenClassMap.put(tokenClassName, var6_8);
        }
        String pkg = this.appSettings.getNodePackage();
        for (Object key : superClassMap.keySet()) {
            String string = String.format("%s.%s", pkg, key);
            List<ObjectType> extendsList = this.grammar.getInjector().getExtendsList(string);
            if (extendsList == null || extendsList.size() == 0) {
                superClassMap.put(key, "Token");
                continue;
            }
            superClassMap.put(key, extendsList.get(0).toString());
        }
        tokenClassMap.putAll(superClassMap);
        Sequencer sequencer = new Sequencer();
        for (Map.Entry entry : tokenClassMap.entrySet()) {
            sequencer.addNode((String)entry.getKey());
            sequencer.addNode((String)entry.getValue());
            sequencer.add((String)entry.getKey(), (String)entry.getValue());
        }
        List<String> sorted = sequencer.steps("Token");
        sorted.remove(0);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sortedNames", sorted);
        hashMap.put("tokenClassMap", tokenClassMap);
        return hashMap;
    }

    public String translateIdentifier(String ident) {
        return this.translator.translateIdentifier(ident, Translator.TranslationContext.METHOD);
    }

    public String startProduction() {
        Translator.SymbolTable symbols = new Translator.SymbolTable();
        this.translator.pushSymbols(symbols);
        return "";
    }

    public String endProduction() {
        this.translator.popSymbols();
        this.translator.clearParameterNames();
        return "";
    }

    public String translateParameters(String parameterList) {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        sb.append(parameterList);
        sb.append(')');
        CongoCCParser parser = new CongoCCParser(sb);
        parser.FormalParameters();
        List<FormalParameter> parameters = ((FormalParameters)parser.rootNode()).getParams();
        sb.setLength(0);
        this.translator.translateFormals(parameters, null, sb);
        return sb.toString();
    }

    public String translateExpression(Node expr) {
        StringBuilder result = new StringBuilder();
        this.translator.translateExpression(expr, result);
        return result.toString();
    }

    public String translateString(String expr) {
        CongoCCParser parser = new CongoCCParser(expr);
        parser.Expression();
        StringBuilder result = new StringBuilder();
        this.translator.translateExpression(parser.rootNode(), result);
        return result.toString();
    }

    private void translateStatements(Node node, int indent, StringBuilder result) {
        if (node instanceof Statement) {
            this.translator.translateStatement(node, indent, result);
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Node child = node.getChild(i);
                if (child instanceof Delimiter) continue;
                this.translator.translateStatement(child, indent, result);
            }
        }
    }

    public String translateCodeBlock(String cb, int indent) {
        StringBuilder result = new StringBuilder();
        if (cb != null) {
            if ((cb = cb.trim()).length() == 0) {
                this.translator.translateEmptyBlock(indent, result);
            } else {
                String block = "{" + cb + "}";
                CongoCCParser parser = new CongoCCParser(block);
                parser.Block();
                Node node = parser.rootNode();
                Translator.SymbolTable syms = new Translator.SymbolTable();
                this.translator.pushSymbols(syms);
                this.translateStatements(node, indent, result);
                this.translator.popSymbols();
            }
        }
        return result.toString();
    }

    public String translateNonterminalArgs(String args) {
        return args == null ? "" : this.translator.translateNonterminalArgs(args);
    }

    public String translateInjectedClass(String name) {
        this.translator.startClass(name, false, null);
        String result = this.translator.translateInjectedClass(this.grammar.getInjector(), name);
        this.translator.endClass(name, false, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String translateInjections(String className, boolean fields, boolean initializers) {
        StringBuilder result = new StringBuilder();
        if (fields) {
            this.translator.clearFields();
        }
        String cn = className.substring(className.lastIndexOf(46) + 1);
        this.translator.startClass(cn, fields, result);
        try {
            List<ClassOrInterfaceBodyDeclaration> declsToProcess = this.grammar.getInjector().getBodyDeclarations(className);
            if (declsToProcess != null) {
                int fieldIndent = this.translator.getFieldIndent();
                int methodIndent = this.translator.getMethodIndent();
                for (ClassOrInterfaceBodyDeclaration decl : declsToProcess) {
                    boolean process = fields == (decl instanceof FieldDeclaration || decl instanceof Initializer);
                    if (!process) continue;
                    if (decl instanceof FieldDeclaration || decl instanceof CodeBlock || decl instanceof Initializer) {
                        if (decl instanceof Initializer && !initializers) continue;
                        this.translator.translateStatement(decl, fieldIndent, result);
                        continue;
                    }
                    if (decl instanceof MethodDeclaration || decl instanceof ConstructorDeclaration || decl instanceof EnumDeclaration || decl instanceof ClassDeclaration) {
                        this.translator.translateStatement(decl, methodIndent, result);
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
            }
        }
        finally {
            this.translator.endClass(cn, fields, result);
        }
        return result.toString();
    }

    protected String translateInitializers(String className) {
        StringBuilder result = new StringBuilder();
        List<ClassOrInterfaceBodyDeclaration> declsToProcess = this.grammar.getInjector().getBodyDeclarations(className);
        if (declsToProcess != null) {
            int fieldIndent = this.translator.getFieldIndent();
            for (ClassOrInterfaceBodyDeclaration decl : declsToProcess) {
                if (!(decl instanceof Initializer)) continue;
                this.translator.translateStatement(decl, fieldIndent, result);
            }
        }
        return result.toString();
    }

    public List<String> injectedFieldNames(String className) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, List<ClassOrInterfaceBodyDeclaration>> bodyDeclarations = this.grammar.getInjector().getBodyDeclarations();
        List<ClassOrInterfaceBodyDeclaration> declsToProcess = bodyDeclarations.get(className);
        if (declsToProcess != null) {
            for (ClassOrInterfaceBodyDeclaration decl : declsToProcess) {
                if (decl instanceof MethodDeclaration || decl instanceof ConstructorDeclaration || decl instanceof Initializer || decl instanceof EnumDeclaration || decl instanceof ClassDeclaration) continue;
                if (decl instanceof FieldDeclaration) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (Node child : decl.children()) {
                        if (child instanceof Identifier) {
                            names.add(((Identifier)child).getImage());
                            continue;
                        }
                        if (!(child instanceof VariableDeclarator)) continue;
                        Identifier ident = child.firstChildOfType(Identifier.class);
                        if (ident == null) {
                            throw new UnsupportedOperationException();
                        }
                        names.add(ident.getImage());
                    }
                    if (names.size() == 0) {
                        throw new UnsupportedOperationException();
                    }
                    for (String name : names) {
                        result.add(this.translator.translateIdentifier(name, Translator.TranslationContext.VARIABLE));
                    }
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        return result;
    }

    public List<String> injectedTokenFieldNames() {
        String className = String.format("%s.Token", this.appSettings.getParserPackage());
        return this.injectedFieldNames(className);
    }

    public List<String> injectedLexerFieldNames() {
        String className = String.format("%s.%s", this.appSettings.getParserPackage(), this.appSettings.getLexerClassName());
        return this.injectedFieldNames(className);
    }

    public List<String> injectedParserFieldNames() {
        String className = String.format("%s.%s", this.appSettings.getParserPackage(), this.appSettings.getParserClassName());
        return this.injectedFieldNames(className);
    }

    public String translateNestedTypes(String className, boolean fields) {
        className = String.format("%s.%s", this.appSettings.getNodePackage(), className);
        return this.translateInjections(className, fields, false);
    }

    public String translateTokenInjections(boolean fields) {
        String className = String.format("%s.Token", this.appSettings.getParserPackage());
        return this.translateInjections(className, fields, fields && this.translator.isIncludeInitializers());
    }

    public String translateLexerInjections(boolean fields) {
        String className = String.format("%s.%s", this.appSettings.getParserPackage(), this.appSettings.getLexerClassName());
        return this.translateInjections(className, fields, fields && this.translator.isIncludeInitializers());
    }

    public String translateParserInjections(boolean fields) {
        String className = String.format("%s.%s", this.appSettings.getParserPackage(), this.appSettings.getParserClassName());
        return this.translateInjections(className, fields, fields && this.translator.isIncludeInitializers());
    }

    public String translateLexerInitializers() {
        String className = String.format("%s.%s", this.appSettings.getParserPackage(), this.appSettings.getLexerClassName());
        return this.translateInitializers(className);
    }

    public String translateParserInitializers() {
        String className = String.format("%s.%s", this.appSettings.getParserPackage(), this.appSettings.getParserClassName());
        return this.translateInitializers(className);
    }

    public String translateTokenSubclassInjections(String className, boolean fields) {
        className = String.format("%s.%s", this.appSettings.getNodePackage(), className);
        return this.translateInjections(className, fields, fields && this.translator.isIncludeInitializers());
    }

    public String translateType(String type) {
        return this.translator.translateTypeName(type);
    }

    public String translateModifiers(String modifiers) {
        return modifiers;
    }

    protected void processImports(Set<ImportDeclaration> imports, StringBuilder result) {
        String prefix = String.format("%s.", this.appSettings.getNodePackage());
        for (ImportDeclaration decl : imports) {
            String name = decl.getChild(1).toString();
            if (name.startsWith("java.") || name.startsWith(prefix)) continue;
            this.translator.translateImport(name, result);
        }
    }

    public String translateLexerImports() {
        StringBuilder result = new StringBuilder();
        String cn = String.format("%s.%s", this.appSettings.getParserPackage(), this.appSettings.getLexerClassName());
        Set<ImportDeclaration> imports = this.grammar.getInjector().getImportDeclarations(cn);
        if (imports != null) {
            this.processImports(imports, result);
        }
        return result.toString();
    }

    public String translateParserImports() {
        StringBuilder result = new StringBuilder();
        String cn = String.format("%s.%s", this.appSettings.getParserPackage(), this.appSettings.getParserClassName());
        Set<ImportDeclaration> imports = this.grammar.getInjector().getImportDeclarations(cn);
        if (imports != null) {
            this.processImports(imports, result);
        }
        return result.toString();
    }

    public List<String> getSortedNodeClassNames() {
        Sequencer seq = new Sequencer();
        String pkg = this.appSettings.getNodePackage();
        String bnn = this.appSettings.getBaseNodeClassName();
        seq.addNode(bnn);
        for (String cn : this.grammar.getNodeNames()) {
            String qn = String.format("%s.%s", pkg, cn);
            List<ObjectType> elist = this.grammar.getInjector().getExtendsList(qn);
            List<ObjectType> ilist = this.grammar.getInjector().getImplementsList(qn);
            ArrayList<String> preds = new ArrayList<String>();
            if (elist != null) {
                for (ObjectType ot : elist) {
                    preds.add(ot.toString());
                }
            }
            if (ilist != null) {
                for (ObjectType ot : ilist) {
                    preds.add(ot.toString());
                }
            }
            if (preds.isEmpty()) {
                preds.add(bnn);
            }
            for (String pn : preds) {
                seq.addNode(pn);
                seq.addNode(cn);
                seq.add(cn, pn);
            }
        }
        List<String> result = seq.steps(bnn);
        result.remove(0);
        return result;
    }

    public String getCurrentNodeVariableName() {
        if (this.nodeVariableNameStack.isEmpty()) {
            return "null";
        }
        return this.nodeVariableNameStack.get(this.nodeVariableNameStack.size() - 1);
    }
}

