/*
 * Decompiled with CFR 0.152.
 */
package org.congocc.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class Sequencer {
    private HashSet<String> nodes = new HashSet();
    private HashMap<String, HashSet<String>> preds = new HashMap();
    private HashMap<String, HashSet<String>> succs = new HashMap();
    private static HashSet<String> EMPTY_SET = new HashSet();

    public void addNode(String node) {
        this.nodes.add(node);
    }

    public void removeNode(String node) {
        this.removeNode(node, false);
    }

    public void removeNode(String node, boolean edges) {
        this.nodes.remove(node);
        if (edges) {
            for (String string : this.preds.getOrDefault(node, EMPTY_SET)) {
                this.remove(string, node);
            }
            for (String string : this.succs.getOrDefault(node, EMPTY_SET)) {
                this.remove(node, string);
            }
            for (Map.Entry entry : this.preds.entrySet()) {
                if (!((HashSet)entry.getValue()).isEmpty()) continue;
                this.preds.remove(entry.getKey());
            }
            for (Map.Entry entry : this.succs.entrySet()) {
                if (!((HashSet)entry.getValue()).isEmpty()) continue;
                this.succs.remove(entry.getKey());
            }
        }
    }

    public void add(String pred, String succ) {
        if (pred.equals(succ)) {
            throw new IllegalArgumentException(String.format("predecessor & successor can't be the same: %s", pred));
        }
        HashSet<String> set = this.preds.get(succ);
        if (set == null) {
            set = new HashSet();
            this.preds.put(succ, set);
        }
        set.add(pred);
        set = this.succs.get(pred);
        if (set == null) {
            set = new HashSet();
            this.succs.put(pred, set);
        }
        set.add(succ);
    }

    public void remove(String pred, String succ) {
        if (pred.equals(succ)) {
            throw new IllegalArgumentException(String.format("predecessor & successor can't be the same: %s", pred));
        }
        HashSet<String> p = this.preds.get(succ);
        HashSet<String> s = this.succs.get(pred);
        if (p == null || s == null) {
            throw new IllegalArgumentException(String.format("Not a successor of anything: %s", succ));
        }
        p.remove(pred);
        s.remove(succ);
    }

    public boolean isStep(String step) {
        return this.preds.containsKey(step) || this.succs.containsKey(step) || this.nodes.contains(step);
    }

    public List<String> steps(String upto) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> todo = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        todo.add(upto);
        while (!todo.isEmpty()) {
            String step = (String)todo.remove(0);
            if (seen.contains(step)) {
                if (step.equals(upto)) continue;
                result.remove(step);
                result.add(step);
                continue;
            }
            seen.add(step);
            result.add(step);
            HashSet<String> p = this.preds.getOrDefault(step, EMPTY_SET);
            todo.addAll(p);
        }
        return result;
    }
}

