/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.core.ast.ASTVisitor;
import freemarker.core.ast.TextBlock;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class PickyPunctuationASTVisitor
extends ASTVisitor
implements Cloneable {
    private boolean inSingleQuote;
    private boolean inDoubleQuote;
    private static Pattern posessivePattern = Pattern.compile("\\w+'\\w+");

    @Override
    public void visit(TextBlock block) {
        String text = block.getText();
        text = this.dealWithPossessives(text);
        text = text.replace("--", "&mdash;");
        text = text.replace("<==>", "&darr");
        text = text.replace("==>", "&rarr");
        text = text.replace("<==", "&larr;");
        text = this.useProperQuotationMarks(text);
        block.setText(text);
    }

    private String dealWithPossessives(String input) {
        StringBuilder buf = new StringBuilder();
        String[] seq = posessivePattern.split(input);
        for (int i = 0; i < seq.length; ++i) {
            String s = seq[i];
            buf.append(s);
            if (i == seq.length - 1) continue;
            buf.append("&rsquo;");
        }
        return buf.toString();
    }

    private String useProperQuotationMarks(String input) {
        StringTokenizer st = new StringTokenizer(input, "'\"", true);
        StringBuilder buf = new StringBuilder();
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("\"")) {
                if (this.inDoubleQuote) {
                    buf.append("&rdquo;");
                } else {
                    buf.append("&ldquo;");
                }
                this.inDoubleQuote = !this.inDoubleQuote;
                continue;
            }
            if (tok.equals("'")) {
                if (this.inDoubleQuote) {
                    buf.append("&rsquo;");
                } else {
                    buf.append("&lsquo;");
                }
                this.inSingleQuote = !this.inSingleQuote;
                continue;
            }
            buf.append(tok);
        }
        return buf.toString();
    }
}

