/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.script;

import freemarker.cache.TemplateLoader;
import freemarker.core.ast.StringLiteral;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.script.FreeMarkerScriptEngine;
import freemarker.template.Configuration;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;

public class FreeMarkerScriptEngineFactory
implements ScriptEngineFactory {
    private Configuration config = new Configuration();
    private static final TemplateLoader NOOP_TEMPLATE_LOADER = new TemplateLoader(){

        @Override
        public void closeTemplateSource(Object templateSource) {
        }

        @Override
        public Object findTemplateSource(String name) {
            return null;
        }

        @Override
        public long getLastModified(Object templateSource) {
            return 0L;
        }

        @Override
        public Reader getReader(Object templateSource, String encoding) {
            return null;
        }
    };
    private static final List<String> extensions = Collections.unmodifiableList(Arrays.asList("ftl", "fm"));
    private static final List<String> mimeTypes = Collections.unmodifiableList(Arrays.asList("application/freemarker", "text/freemarker", "application/vnd.freemarker", "text/vnd.freemarker"));
    private static final List<String> names = Collections.unmodifiableList(Arrays.asList("FreeMarker", "Freemarker", "freemarker", "ftl", "FTL"));

    public FreeMarkerScriptEngineFactory() {
        this.config.setTemplateLoader(NOOP_TEMPLATE_LOADER);
        this.config.setObjectWrapper(new BeansWrapper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(Configuration config) throws IllegalArgumentException, SecurityException {
        if (config == null) {
            throw new IllegalArgumentException("config == null");
        }
        FreeMarkerScriptEngineFactory freeMarkerScriptEngineFactory = this;
        synchronized (freeMarkerScriptEngineFactory) {
            this.config = config;
        }
    }

    @Override
    public String getEngineName() {
        return "FreeMarker";
    }

    @Override
    public String getEngineVersion() {
        return Configuration.getVersionNumber();
    }

    @Override
    public List<String> getExtensions() {
        return extensions;
    }

    @Override
    public String getLanguageName() {
        return "FreeMarker Template Language";
    }

    @Override
    public String getLanguageVersion() {
        return Configuration.getVersionNumber();
    }

    @Override
    public String getMethodCallSyntax(String object, String method, String ... args) {
        StringBuilder b = new StringBuilder();
        b.append("[@").append(object).append('.').append(method).append('(');
        if (args.length > 0) {
            b.append(args[0]);
            for (int i = 1; i < args.length; ++i) {
                b.append(", ").append(args[i]);
            }
        }
        return b.append(")/]").toString();
    }

    @Override
    public List<String> getMimeTypes() {
        return mimeTypes;
    }

    @Override
    public List<String> getNames() {
        return names;
    }

    @Override
    public String getOutputStatement(String string) {
        return "${r\"" + StringLiteral.escapeString(string) + "\"}";
    }

    @Override
    public Object getParameter(String param) {
        if ("javax.script.engine".equals(param)) {
            return this.getEngineName();
        }
        if ("javax.script.engine_version".equals(param)) {
            return this.getEngineVersion();
        }
        if ("javax.script.name".equals(param)) {
            return "FreeMarker";
        }
        if ("javax.script.language".equals(param)) {
            return this.getLanguageName();
        }
        if ("javax.script.language_version".equals(param)) {
            return this.getLanguageVersion();
        }
        if ("THREADING".equals(param)) {
            return "STATELESS";
        }
        return null;
    }

    @Override
    public String getProgram(String ... statements) {
        StringBuilder b = new StringBuilder();
        for (String statement : statements) {
            b.append(statement).append('\n');
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScriptEngine getScriptEngine() {
        Configuration config;
        FreeMarkerScriptEngineFactory freeMarkerScriptEngineFactory = this;
        synchronized (freeMarkerScriptEngineFactory) {
            config = this.config;
        }
        return new FreeMarkerScriptEngine(this, config);
    }
}

