/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.script;

import freemarker.ext.script.CompiledFreeMarkerScript;
import freemarker.ext.script.FreeMarkerScriptEngineFactory;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;

public class FreeMarkerScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private final FreeMarkerScriptEngineFactory factory;
    private Configuration config;

    FreeMarkerScriptEngine(FreeMarkerScriptEngineFactory factory, Configuration config) {
        this.factory = factory;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(Configuration config) {
        if (config == null) {
            throw new IllegalArgumentException("config == null");
        }
        FreeMarkerScriptEngine freeMarkerScriptEngine = this;
        synchronized (freeMarkerScriptEngine) {
            this.config = config;
        }
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public Object eval(Reader script, ScriptContext context) throws ScriptException {
        return this.compile(script).eval(context);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CompiledScript compile(Reader script) throws ScriptException {
        String name = (String)this.get("javax.script.filename");
        if (name == null) {
            name = "<unknown source>";
        }
        try {
            Configuration config;
            Object objConfig = this.get("freeMarker.configuration");
            if (objConfig != null) {
                if (objConfig instanceof Configuration) {
                    config = (Configuration)objConfig;
                    return new CompiledFreeMarkerScript(this, new Template(name, script, config));
                } else {
                    if (!(objConfig instanceof Properties)) throw new ScriptException("Engine property freeMarker.configuration is neither a Configuration nor Properties, it is " + objConfig.getClass().getName());
                    config = new Configuration();
                    config.setSettings((Properties)objConfig);
                }
                return new CompiledFreeMarkerScript(this, new Template(name, script, config));
            }
            FreeMarkerScriptEngine freeMarkerScriptEngine = this;
            synchronized (freeMarkerScriptEngine) {
                config = this.config;
                return new CompiledFreeMarkerScript(this, new Template(name, script, config));
            }
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (TemplateException e) {
            throw new ScriptException(e);
        }
    }
}

