/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class OverloadedMethodUtilities {
    static final Class<Object> OBJECT_CLASS = Object.class;

    OverloadedMethodUtilities() {
    }

    static Class<?> getMostSpecificCommonType(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return c1;
        }
        if (c2.isPrimitive()) {
            if (c2 == Byte.TYPE) {
                c2 = Byte.class;
            } else if (c2 == Short.TYPE) {
                c2 = Short.class;
            } else if (c2 == Character.TYPE) {
                c2 = Character.class;
            } else if (c2 == Integer.TYPE) {
                c2 = Integer.class;
            } else if (c2 == Float.TYPE) {
                c2 = Float.class;
            } else if (c2 == Long.TYPE) {
                c2 = Long.class;
            } else if (c2 == Double.TYPE) {
                c2 = Double.class;
            }
        }
        Set<Class<Class<?>>> a1 = OverloadedMethodUtilities.getAssignables(c1, c2);
        Set<Class<?>> a2 = OverloadedMethodUtilities.getAssignables(c2, c1);
        a1.retainAll(a2);
        if (a1.isEmpty()) {
            return Object.class;
        }
        ArrayList max = new ArrayList();
        block0: for (Class<?> clazz : a1) {
            Iterator maxiter = max.iterator();
            while (maxiter.hasNext()) {
                Class maxClazz = (Class)maxiter.next();
                if (OverloadedMethodUtilities.isMoreSpecific(maxClazz, clazz)) continue block0;
                if (!OverloadedMethodUtilities.isMoreSpecific(clazz, maxClazz)) continue;
                maxiter.remove();
            }
            max.add(clazz);
        }
        if (max.size() > 1) {
            return OBJECT_CLASS;
        }
        return (Class)max.get(0);
    }

    static boolean isMoreSpecific(Class<?> specific, Class<?> generic) {
        if (generic.isAssignableFrom(specific)) {
            return true;
        }
        if (generic.isPrimitive()) {
            if (generic == Short.TYPE && specific == Byte.TYPE) {
                return true;
            }
            if (generic == Integer.TYPE && (specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Long.TYPE && (specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Float.TYPE && (specific == Long.TYPE || specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
            if (generic == Double.TYPE && (specific == Float.TYPE || specific == Long.TYPE || specific == Integer.TYPE || specific == Short.TYPE || specific == Byte.TYPE)) {
                return true;
            }
        }
        return false;
    }

    private static Set<Class<?>> getAssignables(Class<?> c1, Class<?> c2) {
        HashSet s = new HashSet();
        OverloadedMethodUtilities.collectAssignables(c1, c2, s);
        return s;
    }

    private static void collectAssignables(Class<?> c1, Class<?> c2, Set<Class<?>> s) {
        Class<?> sc;
        if (c1.isAssignableFrom(c2)) {
            s.add(c1);
        }
        if ((sc = c1.getSuperclass()) != null) {
            OverloadedMethodUtilities.collectAssignables(sc, c2, s);
        }
        Class<?>[] itf = c1.getInterfaces();
        for (int i = 0; i < itf.length; ++i) {
            OverloadedMethodUtilities.collectAssignables(itf[i], c2, s);
        }
    }

    static Class<?>[] getParameterTypes(Member member) {
        if (member instanceof Method) {
            return ((Method)member).getParameterTypes();
        }
        if (member instanceof Constructor) {
            return ((Constructor)member).getParameterTypes();
        }
        throw new AssertionError();
    }
}

