/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.parser;

import freemarker.core.parser.FMLexer;
import freemarker.core.parser.TokenSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class Token {
    private FMLexer tokenSource;
    private TokenType type = TokenType.DUMMY;
    private int beginOffset;
    private int endOffset;
    private boolean unparsed;

    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public FMLexer getTokenSource() {
        return this.tokenSource;
    }

    public void setTokenSource(TokenSource tokenSource) {
        this.tokenSource = (FMLexer)tokenSource;
    }

    public TokenType getType() {
        return this.type;
    }

    protected void setType(TokenType type) {
        this.type = type;
    }

    public boolean isVirtual() {
        return this.type == TokenType.EOF;
    }

    public boolean isSkipped() {
        return false;
    }

    public int getBeginLine() {
        FMLexer flm = this.getTokenSource();
        return flm == null ? 0 : flm.getLineFromOffset(this.getBeginOffset());
    }

    public int getEndLine() {
        FMLexer flm = this.getTokenSource();
        return flm == null ? 0 : flm.getLineFromOffset(this.getEndOffset() - 1);
    }

    public int getBeginColumn() {
        FMLexer flm = this.getTokenSource();
        return flm == null ? 0 : flm.getCodePointColumnFromOffset(this.getBeginOffset());
    }

    public int getEndColumn() {
        FMLexer flm = this.getTokenSource();
        return flm == null ? 0 : flm.getCodePointColumnFromOffset(this.getEndOffset());
    }

    public String getInputSource() {
        FMLexer flm = this.getTokenSource();
        return flm != null ? flm.getInputSource() : "input";
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getImage() {
        return this.getSource();
    }

    public final Token getNext() {
        return this.getNextParsedToken();
    }

    public final Token getPrevious() {
        Token result;
        for (result = this.previousCachedToken(); result != null && result.isUnparsed(); result = result.previousCachedToken()) {
        }
        return result;
    }

    private Token getNextParsedToken() {
        Token result;
        for (result = this.nextCachedToken(); result != null && result.isUnparsed(); result = result.nextCachedToken()) {
        }
        return result;
    }

    public Token nextCachedToken() {
        if (this.getType() == TokenType.EOF) {
            return null;
        }
        FMLexer tokenSource = this.getTokenSource();
        return tokenSource != null ? tokenSource.nextCachedToken(this.getEndOffset()) : null;
    }

    public Token previousCachedToken() {
        if (this.getTokenSource() == null) {
            return null;
        }
        return this.getTokenSource().previousCachedToken(this.getBeginOffset());
    }

    Token getPreviousToken() {
        return this.previousCachedToken();
    }

    public Token replaceType(TokenType type) {
        Token result = Token.newToken(type, this.getTokenSource(), this.getBeginOffset(), this.getEndOffset());
        this.getTokenSource().cacheToken(result);
        return result;
    }

    public String getSource() {
        if (this.type == TokenType.EOF) {
            return "";
        }
        FMLexer flm = this.getTokenSource();
        return flm == null ? null : flm.getText(this.getBeginOffset(), this.getEndOffset());
    }

    protected Token() {
    }

    public Token(TokenType type, FMLexer tokenSource, int beginOffset, int endOffset) {
        this.type = type;
        this.tokenSource = tokenSource;
        this.beginOffset = beginOffset;
        this.endOffset = endOffset;
    }

    public boolean isUnparsed() {
        return this.unparsed;
    }

    public void setUnparsed(boolean unparsed) {
        this.unparsed = unparsed;
    }

    public void clearChildren() {
    }

    public String getNormalizedText() {
        if (this.getType() == TokenType.EOF) {
            return "EOF";
        }
        return this.getImage();
    }

    public String toString() {
        return this.getNormalizedText();
    }

    public Iterator<Token> precedingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.previousCachedToken() != null;
            }

            @Override
            public Token next() {
                Token previous = this.currentPoint.previousCachedToken();
                if (previous == null) {
                    throw new NoSuchElementException("No previous token!");
                }
                this.currentPoint = previous;
                return this.currentPoint;
            }
        };
    }

    public List<Token> precedingUnparsedTokens() {
        ArrayList<Token> result = new ArrayList<Token>();
        for (Token t = this.previousCachedToken(); t != null && t.isUnparsed(); t = t.previousCachedToken()) {
            result.add(t);
        }
        Collections.reverse(result);
        return result;
    }

    public Iterator<Token> followingTokens() {
        return new Iterator<Token>(){
            Token currentPoint;
            {
                this.currentPoint = Token.this;
            }

            @Override
            public boolean hasNext() {
                return this.currentPoint.nextCachedToken() != null;
            }

            @Override
            public Token next() {
                Token next = this.currentPoint.nextCachedToken();
                if (next == null) {
                    throw new NoSuchElementException("No next token!");
                }
                this.currentPoint = next;
                return this.currentPoint;
            }
        };
    }

    public void copyLocationInfo(Token from) {
        this.setTokenSource(from.getTokenSource());
        this.setBeginOffset(from.getBeginOffset());
        this.setEndOffset(from.getEndOffset());
    }

    public void copyLocationInfo(Token start, Token end) {
        this.setTokenSource(start.getTokenSource());
        if (this.tokenSource == null) {
            this.setTokenSource(end.getTokenSource());
        }
        this.setBeginOffset(start.getBeginOffset());
        this.setEndOffset(end.getEndOffset());
    }

    public static Token newToken(TokenType type, FMLexer tokenSource, int beginOffset, int endOffset) {
        return new Token(type, tokenSource, beginOffset, endOffset);
    }

    public String getLocation() {
        return this.getInputSource() + ":" + this.getBeginLine() + ":" + this.getBeginColumn();
    }

    public static enum TokenType {
        EOF,
        CLOSE_DIRECTIVE_BLOCK,
        _ATTEMPT,
        _RECOVER,
        BLOCKTRIM,
        BLOCKTRIML,
        BLOCKTRIMR,
        BLOCKNOTRIM,
        IF,
        ELSE_IF,
        LIST,
        FOREACH,
        SWITCH,
        CASE,
        ASSIGN,
        GLOBALASSIGN,
        LOCALASSIGN,
        SET,
        _INCLUDE,
        IMPORT,
        FUNCTION,
        MACRO,
        PARAM,
        TRANSFORM,
        VISIT,
        STOP,
        RETURN,
        CALL,
        SETTING,
        EMBED,
        VAR,
        COMPRESS,
        COMMENT,
        TERSE_COMMENT,
        NOPARSE,
        ELSE,
        BREAK,
        SIMPLE_RETURN,
        HALT,
        FLUSH,
        TRIM,
        LTRIM,
        RTRIM,
        NOTRIM,
        DEFAUL,
        SIMPLE_NESTED,
        NESTED,
        SIMPLE_RECURSE,
        RECURSE,
        FALLBACK,
        ESCAPE,
        NOESCAPE,
        UNIFIED_CALL,
        UNIFIED_CALL_END,
        FTL_HEADER,
        TRIVIAL_FTL_HEADER,
        UNKNOWN_DIRECTIVE,
        WHITESPACE,
        PRINTABLE_CHARS,
        OUTPUT_ESCAPE,
        NUMERICAL_ESCAPE,
        _TOKEN_61,
        _TOKEN_62,
        _TOKEN_63,
        _TOKEN_64,
        _TOKEN_65,
        STRING_LITERAL,
        RAW_STRING,
        FALSE,
        TRUE,
        NULL,
        INTEGER,
        DECIMAL,
        DOT,
        DOT_DOT,
        BUILT_IN,
        EXISTS,
        EQUALS,
        DOUBLE_EQUALS,
        NOT_EQUALS,
        GREATER_THAN,
        GREATER_THAN_EQUALS,
        EMPTY_DIRECTIVE_END,
        LESS_THAN,
        LESS_THAN_EQUALS,
        ESCAPED_GT,
        ESCAPED_GTE,
        PLUS,
        MINUS,
        TIMES,
        DOUBLE_STAR,
        ELLIPSIS,
        DIVIDE,
        PERCENT,
        AND,
        OR,
        EXCLAM,
        COMMA,
        SEMICOLON,
        COLON,
        OPEN_BRACKET,
        CLOSE_BRACKET,
        OPEN_PAREN,
        CLOSE_PAREN,
        OPEN_BRACE,
        CLOSE_BRACE,
        IN,
        AS,
        USING,
        TERMINATING_WHITESPACE,
        _TOKEN_110,
        TERSE_COMMENT_END,
        COMMENT_END,
        NOPARSE_END,
        DIRECTIVE_END,
        ID,
        DUMMY,
        INVALID;


        public boolean isUndefined() {
            return this == DUMMY;
        }

        public boolean isInvalid() {
            return this == INVALID;
        }

        public boolean isEOF() {
            return this == EOF;
        }
    }
}

