/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.helpers;

import freemarker.core.ast.ASTVisitor;
import freemarker.core.ast.AddConcatExpression;
import freemarker.core.ast.AndExpression;
import freemarker.core.ast.ArgsList;
import freemarker.core.ast.ArithmeticExpression;
import freemarker.core.ast.AssignmentInstruction;
import freemarker.core.ast.AttemptBlock;
import freemarker.core.ast.BlockAssignment;
import freemarker.core.ast.BodyInstruction;
import freemarker.core.ast.BooleanLiteral;
import freemarker.core.ast.BreakInstruction;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.BuiltinVariable;
import freemarker.core.ast.Case;
import freemarker.core.ast.Comment;
import freemarker.core.ast.ComparisonExpression;
import freemarker.core.ast.CompressedBlock;
import freemarker.core.ast.ConditionalBlock;
import freemarker.core.ast.DefaultToExpression;
import freemarker.core.ast.Dot;
import freemarker.core.ast.DynamicKeyName;
import freemarker.core.ast.EscapeBlock;
import freemarker.core.ast.ExistsExpression;
import freemarker.core.ast.Expression;
import freemarker.core.ast.FallbackInstruction;
import freemarker.core.ast.FlushInstruction;
import freemarker.core.ast.HashLiteral;
import freemarker.core.ast.Identifier;
import freemarker.core.ast.IfBlock;
import freemarker.core.ast.Include;
import freemarker.core.ast.Interpolation;
import freemarker.core.ast.IteratorBlock;
import freemarker.core.ast.LibraryLoad;
import freemarker.core.ast.ListLiteral;
import freemarker.core.ast.Macro;
import freemarker.core.ast.MethodCall;
import freemarker.core.ast.NamedArgsList;
import freemarker.core.ast.NoEscapeBlock;
import freemarker.core.ast.NoParseBlock;
import freemarker.core.ast.NotExpression;
import freemarker.core.ast.NullLiteral;
import freemarker.core.ast.NumberLiteral;
import freemarker.core.ast.NumericalOutput;
import freemarker.core.ast.OrExpression;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.ParentheticalExpression;
import freemarker.core.ast.PositionalArgsList;
import freemarker.core.ast.PropertySetting;
import freemarker.core.ast.Range;
import freemarker.core.ast.RecoveryBlock;
import freemarker.core.ast.RecurseNode;
import freemarker.core.ast.ReturnInstruction;
import freemarker.core.ast.StopInstruction;
import freemarker.core.ast.StringLiteral;
import freemarker.core.ast.SwitchBlock;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateHeaderElement;
import freemarker.core.ast.TemplateNode;
import freemarker.core.ast.TextBlock;
import freemarker.core.ast.TransformBlock;
import freemarker.core.ast.TrimBlock;
import freemarker.core.ast.TrimInstruction;
import freemarker.core.ast.UnaryPlusMinusExpression;
import freemarker.core.ast.UnifiedCall;
import freemarker.core.ast.VarDirective;
import freemarker.core.ast.VisitNode;
import freemarker.template.Template;
import freemarker.template.utility.StringUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultTreeDumper
extends ASTVisitor {
    String OPEN_BRACKET = "<";
    String CLOSE_BRACKET = ">";
    protected StringBuilder buffer = new StringBuilder();

    public String toString() {
        return this.buffer.toString();
    }

    public DefaultTreeDumper(boolean altSyntax) {
        if (altSyntax) {
            this.OPEN_BRACKET = "[";
            this.CLOSE_BRACKET = "]";
        }
    }

    public String render(Template template) {
        return this.render(template.getHeaderElement()) + this.render(template.getRootTreeNode());
    }

    public String render(TemplateNode node) {
        StringBuilder prevBuf = this.buffer;
        this.buffer = new StringBuilder();
        this.visit(node);
        String result = this.buffer.toString();
        this.buffer = prevBuf;
        return result;
    }

    protected void openDirective(String directiveName) {
        this.buffer.append(this.OPEN_BRACKET);
        this.buffer.append("#");
        this.buffer.append(directiveName);
    }

    protected void closeDirective(String directiveName) {
        this.buffer.append(this.OPEN_BRACKET);
        this.buffer.append("/#");
        this.buffer.append(directiveName);
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(TemplateHeaderElement header) {
        if (header == null) {
            return;
        }
        this.openDirective("ftl");
        for (String paramName : header.getParams().keySet()) {
            this.buffer.append(" ");
            this.buffer.append(paramName);
            this.buffer.append("=");
            this.visit(header.getParams().get(paramName));
        }
        this.buffer.append(this.CLOSE_BRACKET);
        this.buffer.append("\n");
    }

    @Override
    public void visit(AddConcatExpression node) {
        this.visit(node.getLeft());
        this.buffer.append("+");
        this.visit(node.getRight());
    }

    @Override
    public void visit(AndExpression node) {
        this.visit(node.getLeft());
        this.buffer.append("&&");
        this.visit(node.getRight());
    }

    @Override
    public void visit(ArithmeticExpression node) {
        String opString = null;
        switch (node.getOperation()) {
            case 2: {
                opString = "/";
                break;
            }
            case 3: {
                opString = "%";
                break;
            }
            case 1: {
                opString = "*";
                break;
            }
            case 0: {
                opString = "-";
            }
        }
        this.visit(node.getLeft());
        this.buffer.append(opString);
        this.visit(node.getRight());
    }

    @Override
    public void visit(AssignmentInstruction node) {
        switch (node.getType()) {
            case 2: {
                this.openDirective("global ");
                break;
            }
            case 3: {
                this.openDirective("local ");
                break;
            }
            case 0: {
                this.openDirective("set ");
                break;
            }
            case 1: {
                this.openDirective("assign ");
            }
        }
        List<String> varnames = node.getVarNames();
        List<Expression> values = node.getValues();
        for (int i = 0; i < varnames.size(); ++i) {
            if (i > 0) {
                this.buffer.append(", ");
            }
            String varname = varnames.get(i);
            Expression value = values.get(i);
            this.buffer.append(DefaultTreeDumper.quoteVarnameIfNecessary(varname));
            this.buffer.append(" = ");
            this.visit(value);
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(AttemptBlock node) {
        this.openDirective("attempt" + this.CLOSE_BRACKET);
        this.visit(node.getAttemptBlock());
        this.visit(node.getRecoverBlock());
    }

    @Override
    public void visit(BlockAssignment node) {
        String varname = StringUtil.quoteStringIfNecessary(node.getVarName());
        Expression nsExp = node.getNamespaceExpression();
        String instruction = null;
        switch (node.getType()) {
            case 2: {
                instruction = "global";
                break;
            }
            case 3: {
                instruction = "local";
                break;
            }
            case 1: {
                instruction = "assign";
                break;
            }
            case 0: {
                instruction = "set";
            }
        }
        this.openDirective(instruction);
        this.buffer.append(" ");
        this.buffer.append(varname);
        if (nsExp != null) {
            this.buffer.append(" in ");
            this.visit(nsExp);
        }
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        this.closeDirective(instruction);
    }

    @Override
    public void visit(BodyInstruction node) {
        this.openDirective("nested");
        ArgsList args = node.getArgs();
        if (args != null) {
            this.buffer.append(" ");
            this.visit(args);
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    public void visit(BooleanLiteral node) {
        this.buffer.append(node.getValue() ? "true" : "false");
    }

    @Override
    public void visit(BreakInstruction node) {
        this.openDirective("break");
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(BuiltInExpression node) {
        this.visit(node.getTarget());
        this.buffer.append("?");
        this.buffer.append(node.getName());
    }

    @Override
    public void visit(BuiltinVariable node) {
        this.buffer.append(".");
        this.buffer.append(node.getName());
    }

    @Override
    public void visit(Case node) {
        this.buffer.append(this.OPEN_BRACKET);
        if (node.isDefault()) {
            this.buffer.append("#default");
        } else {
            this.buffer.append("#case ");
            this.visit(node.getExpression());
        }
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
    }

    @Override
    public void visit(Comment node) {
        this.buffer.append(this.OPEN_BRACKET);
        this.buffer.append("#--");
        this.buffer.append(node.getText());
        this.buffer.append("--");
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(ComparisonExpression node) {
        this.visit(node.getLeft());
        boolean usingAltSyntax = this.CLOSE_BRACKET.equals("]");
        switch (node.getOperation()) {
            case 1: {
                this.buffer.append(" = ");
                break;
            }
            case 2: {
                this.buffer.append(" != ");
                break;
            }
            case 4: {
                if (usingAltSyntax) {
                    this.buffer.append(">");
                    break;
                }
                this.buffer.append("gt");
                break;
            }
            case 6: {
                if (usingAltSyntax) {
                    this.buffer.append(">=");
                    break;
                }
                this.buffer.append(" gte ");
                break;
            }
            case 3: {
                this.buffer.append("<");
                break;
            }
            case 5: {
                this.buffer.append("<=");
            }
        }
        this.visit(node.getRight());
    }

    @Override
    public void visit(CompressedBlock node) {
        this.openDirective("compress");
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        this.closeDirective("compress");
    }

    @Override
    public void visit(ConditionalBlock node) {
        this.buffer.append(this.OPEN_BRACKET);
        if (node.isFirst()) {
            this.buffer.append("#if ");
        } else if (node.getCondition() == null) {
            this.buffer.append("#else");
        } else {
            this.buffer.append("#elseif ");
        }
        this.visit(node.getCondition());
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        if (node.isLoneIfBlock()) {
            this.closeDirective("if");
        }
    }

    @Override
    public void visit(DefaultToExpression node) {
        this.visit(node.getLeft());
        this.buffer.append("!");
        this.visit(node.getLeft());
    }

    @Override
    public void visit(Interpolation node) {
        this.buffer.append("${");
        this.visit(node.getExpression());
        this.buffer.append("}");
    }

    @Override
    public void visit(Dot node) {
        this.visit(node.getTarget());
        this.buffer.append(".");
        this.buffer.append(node.getKey());
    }

    @Override
    public void visit(DynamicKeyName node) {
        this.visit(node.getTarget());
        this.buffer.append("[");
        this.visit(node.getNameExpression());
        this.buffer.append("]");
    }

    @Override
    public void visit(EscapeBlock node) {
        this.openDirective("escape ");
        this.buffer.append(node.getVariable());
        this.buffer.append(" as ");
        this.visit(node.getExpression());
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        this.closeDirective("escape");
    }

    @Override
    public void visit(ExistsExpression node) {
        this.visit(node.getExpression());
        this.buffer.append("??");
    }

    @Override
    public void visit(FallbackInstruction node) {
        this.openDirective("fallback");
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(FlushInstruction node) {
        this.openDirective("flush");
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(HashLiteral node) {
        this.buffer.append("{");
        List<Expression> keys = node.getKeys();
        List<Expression> values = node.getValues();
        for (int i = 0; i < keys.size(); ++i) {
            if (i > 0) {
                this.buffer.append(", ");
            }
            this.visit(keys.get(i));
            this.buffer.append(" : ");
            this.visit(values.get(i));
        }
        this.buffer.append("}");
    }

    @Override
    public void visit(Identifier node) {
        this.buffer.append(node.getName());
    }

    @Override
    public void visit(IfBlock node) {
        for (TemplateNode templateNode : node.getSubBlocks()) {
            this.visit(templateNode);
        }
        this.closeDirective("if");
    }

    @Override
    public void visit(Include node) {
        if (node.isFreshNamespace()) {
            this.openDirective("embed ");
        } else {
            this.openDirective("include ");
        }
        this.visit(node.getIncludedTemplateExpression());
        Expression parseExp = node.getParseExp();
        Expression encodingExp = node.getEncodingExp();
        if (parseExp != null || encodingExp != null) {
            this.buffer.append(" ;");
            if (encodingExp != null) {
                this.buffer.append(" ");
                this.buffer.append("encoding=");
                this.visit(encodingExp);
            }
            if (parseExp != null) {
                this.buffer.append(" ");
                this.buffer.append("parse=");
                this.visit(parseExp);
            }
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(IteratorBlock node) {
        this.openDirective("list ");
        this.visit(node.getListExpression());
        this.buffer.append(" as ");
        this.buffer.append(node.getIndexName());
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        this.closeDirective("list");
    }

    @Override
    public void visit(LibraryLoad node) {
        this.openDirective("import ");
        this.visit(node.getTemplateNameExpression());
        this.buffer.append(" as ");
        this.buffer.append(node.getNamespace());
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(ListLiteral node) {
        this.buffer.append("[");
        boolean firstElement = true;
        for (Expression exp : node.getElements()) {
            if (!firstElement) {
                this.buffer.append(", ");
            }
            firstElement = false;
            this.visit(exp);
        }
        this.buffer.append("]");
    }

    @Override
    public void visit(Macro node) {
        String paramsString;
        if (node.isFunction()) {
            this.openDirective("function ");
        } else {
            this.openDirective("macro ");
        }
        this.buffer.append(DefaultTreeDumper.quoteVarnameIfNecessary(node.getName()));
        ParameterList params = node.getParams();
        if (params != null && (paramsString = this.render(params).trim()).length() > 0) {
            this.buffer.append(" ");
            this.buffer.append(paramsString);
        }
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        if (node.isFunction()) {
            this.closeDirective("function");
        } else {
            this.closeDirective("macro");
        }
    }

    @Override
    public void visit(MethodCall node) {
        this.visit(node.getTarget());
        this.buffer.append("(");
        this.visit(node.getArgs());
        this.buffer.append(")");
    }

    @Override
    public void visit(NamedArgsList args) {
        boolean atFirstArg = true;
        for (Map.Entry<String, Expression> entry : args.getArgs().entrySet()) {
            if (!atFirstArg && this.buffer.charAt(this.buffer.length() - 1) == '!') {
                this.buffer.append(",");
            }
            if (!atFirstArg) {
                this.buffer.append(" ");
            }
            this.buffer.append(entry.getKey());
            this.buffer.append("=");
            this.visit(entry.getValue());
            atFirstArg = false;
        }
    }

    @Override
    public void visit(NoEscapeBlock node) {
        this.openDirective("noescape");
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        this.closeDirective("noescape");
    }

    @Override
    public void visit(NotExpression node) {
        this.buffer.append("!");
        this.visit(node.getTarget());
    }

    @Override
    public void visit(NullLiteral node) {
        this.buffer.append("null");
    }

    @Override
    public void visit(NumberLiteral node) {
        this.buffer.append(node.getValue().toString());
    }

    @Override
    public void visit(NumericalOutput node) {
        this.buffer.append("#{");
        this.visit(node.getExpression());
        String formatString = node.getFormatString();
        if (formatString != null) {
            this.buffer.append(" ; ");
            this.buffer.append(formatString);
        }
        this.buffer.append("}");
    }

    @Override
    public void visit(OrExpression exp) {
        this.visit(exp.getLeft());
        this.buffer.append(" || ");
        this.visit(exp.getRight());
    }

    @Override
    public void visit(ParameterList plist) {
        boolean atFirstParam = true;
        for (String paramName : plist.getParamNames()) {
            if (!atFirstParam) {
                this.buffer.append(" ");
            }
            this.buffer.append(paramName);
            Expression defaultExp = plist.getDefaultExpression(paramName);
            if (defaultExp != null) {
                this.buffer.append("=");
                this.visit(defaultExp);
            }
            atFirstParam = false;
        }
        String catchall = plist.getCatchAll();
        if (catchall != null) {
            if (!plist.getParamNames().isEmpty()) {
                this.buffer.append(" ");
            }
            this.buffer.append(catchall + "...");
        }
    }

    @Override
    public void visit(ParentheticalExpression node) {
        this.buffer.append("(");
        this.visit(node.getNested());
        this.buffer.append(")");
    }

    @Override
    public void visit(PositionalArgsList plist) {
        boolean atFirstArg = true;
        for (Expression exp : plist.getArgs()) {
            if (!atFirstArg) {
                this.buffer.append(", ");
            }
            this.visit(exp);
            atFirstArg = false;
        }
    }

    @Override
    public void visit(PropertySetting node) {
        this.openDirective("setting ");
        this.buffer.append(node.getKey());
        this.buffer.append(" = ");
        this.visit(node.getValue());
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(Range node) {
        this.visit(node.getLeft());
        this.buffer.append("..");
        if (node.getRight() != null) {
            String right = this.render(node.getRight());
            if (right.charAt(0) == '.') {
                this.buffer.append(" ");
            }
            this.buffer.append(right);
        }
    }

    @Override
    public void visit(RecoveryBlock node) {
        this.openDirective("recover");
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        this.closeDirective("attempt");
    }

    @Override
    public void visit(RecurseNode node) {
        this.openDirective("recurse ");
        this.visit(node.getTargetNode());
        if (node.getNamespaces() != null) {
            this.buffer.append(" using ");
            this.visit(node.getNamespaces());
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(ReturnInstruction node) {
        this.buffer.append(this.OPEN_BRACKET);
        this.buffer.append("#return");
        if (node.returnExp != null) {
            this.buffer.append(" ");
            this.buffer.append(this.render(node.returnExp));
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(VarDirective node) {
        this.openDirective("var ");
        Map<String, Expression> vars = node.getVariables();
        Iterator<Map.Entry<String, Expression>> it = vars.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Expression> entry = it.next();
            String varname = entry.getKey();
            varname = StringUtil.quoteStringIfNecessary(varname);
            Expression exp = entry.getValue();
            this.buffer.append(varname);
            if (exp != null) {
                this.buffer.append("=");
                this.visit(exp);
            }
            if (!it.hasNext()) continue;
            this.buffer.append(" ");
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(StopInstruction node) {
        this.openDirective("stop");
        if (node.message != null) {
            this.buffer.append(" ");
            this.visit(node.message);
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(StringLiteral node) {
        String result = node.getValue().indexOf(34) == -1 ? "\"" + node.getValue() + "\"" : (node.getValue().indexOf(39) == -1 ? "'" + node.getValue() + "'" : "\"" + node.getValue().replace("\"", "\\\"") + "\"");
        if (node.isRaw()) {
            result = "r" + result;
        }
        this.buffer.append(result);
    }

    @Override
    public void visit(SwitchBlock node) {
        this.openDirective("switch ");
        this.buffer.append(this.render(node.getTestExpression()));
        this.buffer.append(this.CLOSE_BRACKET);
        List<TemplateElement> cases = node.getCases();
        if (cases != null) {
            for (TemplateNode templateNode : node.getCases()) {
                this.visit(templateNode);
            }
        }
        this.closeDirective("switch");
    }

    @Override
    public void visit(TextBlock node) {
        this.buffer.append(node.getText());
    }

    @Override
    public void visit(NoParseBlock node) {
        this.openDirective("noparse");
        this.buffer.append(this.CLOSE_BRACKET);
        super.visit(node);
        this.closeDirective("noparse");
    }

    @Override
    public void visit(TransformBlock node) {
        this.openDirective("transform ");
        this.visit(node.getTransformExpression());
        Map args = node.getArgs();
        for (Map.Entry entry : args.entrySet()) {
            String varname = (String)entry.getKey();
            varname = StringUtil.quoteStringIfNecessary(varname);
            Expression value = (Expression)entry.getValue();
            this.buffer.append(" ");
            this.buffer.append(varname);
            this.buffer.append("=");
            this.visit(value);
        }
        this.buffer.append(this.CLOSE_BRACKET);
        this.visit(node.getNestedBlock());
        this.closeDirective("transform");
    }

    @Override
    public void visit(TrimInstruction node) {
        if (node.isLeft() && node.isRight()) {
            this.openDirective("t");
        } else if (node.isLeft()) {
            this.openDirective("lt");
        } else if (node.isRight()) {
            this.openDirective("rt");
        } else {
            this.openDirective("nt");
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    @Override
    public void visit(TrimBlock node) {
        String tagName = "nt_lines";
        if (node.isLeft() && node.isRight()) {
            tagName = "t_lines";
        } else if (node.isLeft()) {
            tagName = "lt_lines";
        } else if (node.isRight()) {
            tagName = "rt_lines";
        }
        this.openDirective(tagName);
        this.visit(node.getNestedBlock());
        this.closeDirective(tagName);
    }

    @Override
    public void visit(UnaryPlusMinusExpression node) {
        String op = node.isMinus() ? "-" : "+";
        this.buffer.append(op);
        this.visit(node.getTarget());
    }

    @Override
    public void visit(UnifiedCall node) {
        TemplateElement body;
        ParameterList bodyParameters;
        this.buffer.append(this.OPEN_BRACKET);
        this.buffer.append("@");
        this.visit(node.getNameExp());
        ArgsList args = node.getArgs();
        if (args != null) {
            this.buffer.append(" ");
            this.visit(args);
        }
        if ((bodyParameters = node.getBodyParameters()) != null) {
            this.buffer.append("; ");
            this.visit(bodyParameters);
        }
        if ((body = node.getNestedBlock()) == null) {
            this.buffer.append("/");
            this.buffer.append(this.CLOSE_BRACKET);
        } else {
            this.buffer.append(this.CLOSE_BRACKET);
            this.visit(body);
            this.buffer.append(this.OPEN_BRACKET);
            this.buffer.append("/@");
            if (node.getNameExp() instanceof Identifier) {
                this.buffer.append(node.getNameExp());
            }
            this.buffer.append(this.CLOSE_BRACKET);
        }
    }

    @Override
    public void visit(VisitNode node) {
        this.openDirective("visit ");
        this.visit(node.getTargetNode());
        if (node.getNamespaces() != null) {
            this.buffer.append(" using ");
            this.visit(node.getNamespaces());
        }
        this.buffer.append(this.CLOSE_BRACKET);
    }

    static String quoteVarnameIfNecessary(String varname) {
        if (StringUtil.isFTLIdentifier(varname)) {
            return varname;
        }
        return "\"" + StringUtil.FTLStringLiteralEnc(varname) + "\"";
    }
}

