/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.EvaluationUtil;
import freemarker.core.ast.TemplateNode;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.template.LazilyEvaluatableArguments;
import freemarker.template.Parameters;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDateModel;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;

public class stringBI
extends ExpressionEvaluatingBuiltIn {
    @Override
    public boolean isSideEffectFree() {
        return false;
    }

    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        if (model instanceof TemplateNumberModel) {
            return new NumberFormatter(EvaluationUtil.getNumber(model, caller.getTarget(), env), env);
        }
        if (model instanceof TemplateDateModel) {
            TemplateDateModel dm = (TemplateDateModel)model;
            int dateType = dm.getDateType();
            return new DateFormatter(EvaluationUtil.getDate(dm, caller.getTarget(), env), dateType, env);
        }
        if (model instanceof SimpleScalar) {
            return model;
        }
        if (model instanceof TemplateBooleanModel) {
            return new BooleanFormatter((TemplateBooleanModel)model, env);
        }
        if (model instanceof TemplateScalarModel) {
            return new SimpleScalar(((TemplateScalarModel)model).getAsString());
        }
        throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "number, date, or string");
    }

    static class NumberFormatter
    implements TemplateScalarModel,
    TemplateHashModel,
    TemplateMethodModel {
        private final Number number;
        private final Environment env;
        private final NumberFormat defaultFormat;
        private String cachedValue;

        NumberFormatter(Number number, Environment env) {
            this.number = number;
            this.env = env;
            this.defaultFormat = env.getNumberFormatObject(env.getNumberFormat());
        }

        @Override
        public String getAsString() {
            if (this.cachedValue == null) {
                this.cachedValue = this.defaultFormat.format(this.number);
            }
            return this.cachedValue;
        }

        @Override
        public TemplateModel get(String key) {
            return new SimpleScalar(this.env.getNumberFormatObject(key).format(this.number));
        }

        @Override
        @Parameters(value="format")
        public Object exec(List arguments) {
            if (arguments.size() != 1) {
                throw new TemplateModelException("number?string(...) requires exactly 1 argument.");
            }
            return this.get((String)arguments.get(0));
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    static class DateFormatter
    implements TemplateScalarModel,
    TemplateHashModel,
    TemplateMethodModel {
        private final Date date;
        private final int dateType;
        private final Environment env;
        private final DateFormat defaultFormat;
        private String cachedValue;

        DateFormatter(Date date, int dateType, Environment env) {
            this.date = date;
            this.dateType = dateType;
            this.env = env;
            this.defaultFormat = env.getDateFormatObject(dateType);
        }

        @Override
        public String getAsString() {
            if (this.dateType == 0) {
                throw new TemplateModelException("Can't convert the date to string, because it is not known which parts of the date variable are in use. Use ?date, ?time or ?datetime built-in, or ?string.<format> or ?string(format) built-in with this date.");
            }
            if (this.cachedValue == null) {
                this.cachedValue = this.defaultFormat.format(this.date);
            }
            return this.cachedValue;
        }

        @Override
        public TemplateModel get(String key) throws TemplateModelException {
            return new SimpleScalar(this.env.getDateFormatObject(this.dateType, key).format(this.date));
        }

        @Override
        public Object exec(List arguments) {
            if (arguments.size() != 1) {
                throw new TemplateModelException("date?string(...) requires exactly 1 argument.");
            }
            return this.get((String)arguments.get(0));
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    static class BooleanFormatter
    implements TemplateScalarModel,
    LazilyEvaluatableArguments {
        private final TemplateBooleanModel bool;
        private final Environment env;

        BooleanFormatter(TemplateBooleanModel bool, Environment env) {
            this.bool = bool;
            this.env = env;
        }

        @Override
        public String getAsString() {
            if (this.bool instanceof TemplateScalarModel) {
                return ((TemplateScalarModel)((Object)this.bool)).getAsString();
            }
            return this.env.getBooleanFormat(this.bool.getAsBoolean());
        }

        @Override
        public Object exec(List arguments) {
            if (arguments.size() != 2) {
                throw new TemplateModelException("boolean?string(...) requires exactly 2 arguments.");
            }
            return new SimpleScalar((String)arguments.get(this.bool.getAsBoolean() ? 0 : 1));
        }
    }
}

