/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.builtins;

import freemarker.core.Environment;
import freemarker.core.ast.BuiltInExpression;
import freemarker.core.ast.CollectionAndSequence;
import freemarker.core.ast.TemplateNode;
import freemarker.core.builtins.ExpressionEvaluatingBuiltIn;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateSequenceModel;

public abstract class HashBuiltin
extends ExpressionEvaluatingBuiltIn {
    @Override
    public TemplateModel get(Environment env, BuiltInExpression caller, TemplateModel model) {
        if (!(model instanceof TemplateHashModelEx)) {
            throw TemplateNode.invalidTypeException(model, caller.getTarget(), env, "extended hash");
        }
        TemplateCollectionModel result = this.apply((TemplateHashModelEx)model);
        if (!(result instanceof TemplateSequenceModel)) {
            return new CollectionAndSequence(result);
        }
        return result;
    }

    public abstract TemplateCollectionModel apply(TemplateHashModelEx var1) throws TemplateModelException;

    public static class Values
    extends HashBuiltin {
        @Override
        public TemplateCollectionModel apply(TemplateHashModelEx hash) {
            return hash.values();
        }
    }

    public static class Keys
    extends HashBuiltin {
        @Override
        public TemplateCollectionModel apply(TemplateHashModelEx hash) {
            return hash.keys();
        }
    }
}

