/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.ArgsList;
import freemarker.core.ast.Expression;
import freemarker.core.ast.Macro;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class UnifiedCall
extends TemplateElement {
    private Expression nameExp;
    private ArgsList args;
    private ParameterList bodyParameters;

    public ArgsList getArgs() {
        return this.args;
    }

    public void setArgs(ArgsList args) {
        this.args = args;
        args.parent = this;
    }

    public ParameterList getBodyParameters() {
        return this.bodyParameters;
    }

    public void setNameExp(Expression nameExp) {
        this.nameExp = nameExp;
    }

    public Expression getNameExp() {
        return this.nameExp;
    }

    public void setBodyParameters(ParameterList bodyParameters) {
        this.bodyParameters = bodyParameters;
        if (bodyParameters != null) {
            for (String paramName : bodyParameters.params) {
                this.declareVariable(paramName);
            }
            String catchallParam = bodyParameters.getCatchAll();
            if (catchallParam != null) {
                this.declareVariable(catchallParam);
            }
        }
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        TemplateModel tm = this.nameExp.getAsTemplateModel(env);
        if (tm == Macro.DO_NOTHING_MACRO) {
            return;
        }
        if (tm instanceof Macro) {
            Macro macro = (Macro)tm;
            if (macro.isFunction()) {
                throw new TemplateException("Routine " + macro.getName() + " is a function. A function can only be called within the evaluation of an expression.", env);
            }
            env.render(macro, this.args, this.bodyParameters, this.nestedBlock);
        } else if (tm instanceof TemplateDirectiveModel) {
            HashMap<String, TemplateModel> argMap = this.args != null ? this.args.getParameterMap(tm, env) : new HashMap<String, TemplateModel>();
            List<Object> paramNames = this.bodyParameters == null ? Collections.emptyList() : this.bodyParameters.getParamNames();
            env.render(this.nestedBlock, (TemplateDirectiveModel)tm, argMap, paramNames);
        } else if (tm instanceof TemplateTransformModel) {
            HashMap<String, TemplateModel> argMap = this.args != null ? this.args.getParameterMap(tm, env) : new HashMap<String, TemplateModel>();
            env.render(this.nestedBlock, (TemplateTransformModel)tm, argMap);
        } else {
            UnifiedCall.assertNonNull(tm, this.nameExp, env);
            throw new TemplateException(this.getStartLocation() + ": " + this.nameExp + " is not a user-defined directive.", env);
        }
    }

    @Override
    public String getDescription() {
        return "user-directive " + this.nameExp;
    }
}

