/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.ast.Expression;
import freemarker.core.ast.Identifier;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateNode;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TemplateHeaderElement
extends TemplateNode {
    private Map<String, Expression> params;
    private Map<String, TemplateModel> values = new HashMap<String, TemplateModel>();
    protected TemplateElement parent;

    public TemplateHeaderElement(Map<String, Expression> params) {
        this.params = params;
    }

    public Map<String, Expression> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public boolean hasParameter(String name) {
        return this.params.containsKey(name);
    }

    public void addParameter(String name, Expression exp) {
        this.params.put(name, exp);
        this.values.remove(name);
    }

    public TemplateModel getParameter(String name) {
        if (this.values.containsKey(name)) {
            return this.values.get(name);
        }
        Expression exp = this.params.get(name);
        try {
            TemplateModel tm = exp.getAsTemplateModel(null);
            this.values.put(name, tm);
            return tm;
        }
        catch (TemplateException te) {
            if (exp instanceof Identifier) {
                String s = ((Identifier)exp).getName();
                SimpleScalar result = new SimpleScalar(s);
                this.values.put(name, result);
                return result;
            }
            this.values.put(name, null);
            return null;
        }
    }

    public String getStringParameter(String name) {
        TemplateModel tm = this.getParameter(name);
        if (tm instanceof TemplateScalarModel) {
            try {
                return ((TemplateScalarModel)tm).getAsString();
            }
            catch (TemplateModelException tme) {
                throw new IllegalArgumentException(tme);
            }
        }
        throw new IllegalArgumentException("Parameter " + name + " is not a string.");
    }

    public boolean getBooleanParameter(String name) {
        TemplateModel tm = this.getParameter(name);
        if (tm == null) {
            throw new IllegalArgumentException("No parameter " + name);
        }
        if (tm instanceof TemplateBooleanModel) {
            try {
                return ((TemplateBooleanModel)tm).getAsBoolean();
            }
            catch (TemplateModelException te) {
                throw new IllegalArgumentException(te);
            }
        }
        if (tm instanceof TemplateScalarModel) {
            try {
                return StringUtil.getYesNo(((TemplateScalarModel)tm).getAsString());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("Parameter " + name + " is not a boolean type.");
    }

    public TemplateElement getParent() {
        return this.parent;
    }
}

