/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.BreakException;
import freemarker.core.Environment;
import freemarker.core.ast.Case;
import freemarker.core.ast.ComparisonExpression;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SwitchBlock
extends TemplateElement {
    private Expression testExpression;

    public SwitchBlock(Expression testExpression) {
        this.testExpression = testExpression;
        this.nestedElements = new LinkedList();
    }

    public void addCase(Case cas) {
        this.nestedElements.add(cas);
    }

    public List<TemplateElement> getCases() {
        return this.nestedElements;
    }

    public Expression getTestExpression() {
        return this.testExpression;
    }

    @Override
    public void execute(Environment env) throws TemplateException, IOException {
        boolean processedCase = false;
        Iterator iterator = this.nestedElements.iterator();
        try {
            Case defaultCase = null;
            while (iterator.hasNext()) {
                Case cas = (Case)iterator.next();
                boolean processCase = false;
                if (processedCase) {
                    processCase = true;
                } else if (cas.isDefault()) {
                    defaultCase = cas;
                } else {
                    ComparisonExpression equalsOp = new ComparisonExpression(this.testExpression, cas.getExpression(), "==");
                    processCase = equalsOp.isTrue(env);
                }
                if (!processCase) continue;
                env.render(cas);
                processedCase = true;
            }
            if (!processedCase && defaultCase != null) {
                env.render(defaultCase);
            }
        }
        catch (BreakException breakException) {
            // empty catch block
        }
    }

    @Override
    public String getDescription() {
        return "switch " + this.testExpression;
    }
}

