/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.TemplateElement;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;

public class PropertySetting
extends TemplateElement {
    private String key;
    private Expression value;

    public PropertySetting(String key, Expression value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public void execute(Environment env) {
        TemplateModel mval = this.value.getAsTemplateModel(env);
        String strval = mval instanceof TemplateScalarModel ? ((TemplateScalarModel)mval).getAsString() : (mval instanceof TemplateBooleanModel ? (((TemplateBooleanModel)mval).getAsBoolean() ? "true" : "false") : (mval instanceof TemplateNumberModel ? ((TemplateNumberModel)mval).getAsNumber().toString() : this.value.getStringValue(env)));
        env.setSetting(this.key, strval);
    }

    @Override
    public String getDescription() {
        return "setting " + this.key + " set to \"" + this.value + "\" [" + this.getStartLocation() + "]";
    }
}

