/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.MixedContent;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.TemplateElement;
import freemarker.core.ast.TemplateNode;
import freemarker.core.ast.TextBlock;
import freemarker.core.ast.VarDirective;
import freemarker.template.TemplateModel;
import freemarker.template.utility.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Map;

public final class Macro
extends TemplateElement
implements TemplateModel,
Cloneable {
    private String name;
    private ParameterList params;
    private boolean isFunction;
    public static final Macro DO_NOTHING_MACRO = new Macro();

    public void setName(String name) {
        this.name = name;
    }

    Macro createCurriedMacro(ParameterList curriedParams, Environment env) {
        try {
            Macro curried = (Macro)super.clone();
            curried.params = curriedParams;
            env.setCurriedMacroNamespace(curried, this);
            return curried;
        }
        catch (CloneNotSupportedException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void setParams(ParameterList params) {
        this.params = params;
        for (String paramName : params.params) {
            this.declareVariable(paramName);
        }
        String catchallVar = params.getCatchAll();
        if (catchallVar != null) {
            this.declareVariable(catchallVar);
        }
    }

    public ParameterList getParams() {
        return this.params;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    public void setFunction(boolean b) {
        this.isFunction = b;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void execute(Environment env) {
        env.visitMacroDef(this);
    }

    @Override
    public String getDescription() {
        return (this.isFunction() ? "function " : "macro ") + this.name;
    }

    public void canonicalizeAssignments() {
        if (this.createsScope() && this.nestedBlock instanceof MixedContent) {
            MixedContent block = (MixedContent)this.nestedBlock;
            VarDirective varDirective = null;
            HashSet<String> variables = new HashSet<String>();
            variables.addAll(this.params.getParamNames());
            for (TemplateNode templateNode : block.getNestedElements()) {
                if (!(templateNode instanceof VarDirective)) continue;
                VarDirective sdir = (VarDirective)templateNode;
                if (varDirective == null) {
                    varDirective = sdir;
                }
                Map<String, Expression> vars = sdir.getVariables();
                for (String varname : vars.keySet()) {
                    variables.add(varname);
                }
            }
            for (String string : this.declaredVariables) {
                if (variables.contains(string)) continue;
                if (varDirective == null) {
                    varDirective = new VarDirective();
                    block.prependElement(varDirective);
                }
                varDirective.addVar(string);
            }
        }
    }

    static {
        DO_NOTHING_MACRO.setName(".pass");
        DO_NOTHING_MACRO.setNestedBlock(TextBlock.EMPTY_BLOCK);
    }
}

