/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.Expression;
import freemarker.core.ast.OOParamElement;
import freemarker.core.ast.ParameterList;
import freemarker.core.ast.TemplateNode;
import freemarker.core.parser.FMLexer;
import freemarker.core.parser.FMParser;
import freemarker.core.parser.ParseException;
import freemarker.ext.beans.SimpleMethodModel;
import freemarker.template.Parameters;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateTransformModel;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ArgsList
extends TemplateNode {
    private static Map<String, ParameterList> parameterListCache = new ConcurrentHashMap<String, ParameterList>();
    private static final ParameterList NO_PARAM_LIST = new ParameterList();

    abstract Map<String, TemplateModel> getParameterMap(TemplateModel var1, Environment var2) throws TemplateException;

    abstract List getParameterSequence(TemplateModel var1, Environment var2) throws TemplateException;

    static final ParameterList getParameterList(TemplateModel target) {
        ParameterList result;
        String keyName = target.getClass().getName();
        if (target instanceof SimpleMethodModel) {
            keyName = target.toString();
        }
        if ((result = parameterListCache.get(keyName)) == NO_PARAM_LIST) {
            return null;
        }
        if (result != null) {
            return result;
        }
        Parameters params = ArgsList.getAnnotatedParameters(target);
        if (params != null) {
            String paramString = params.value();
            if ("".equals(paramString)) {
                result = new ParameterList();
            } else {
                try {
                    result = ArgsList.getParameterList(paramString);
                }
                catch (Exception pe) {
                    throw new TemplateException("Can't parse parameter list [" + paramString + "] on " + target, pe, Environment.getCurrentEnvironment());
                }
            }
            parameterListCache.put(keyName, result);
            return result;
        }
        parameterListCache.put(keyName, NO_PARAM_LIST);
        return null;
    }

    private static ParameterList getParameterList(String s) {
        FMLexer token_source = new FMLexer(s);
        token_source.switchTo(FMLexer.LexicalState.EXPRESSION);
        FMParser parser = new FMParser(token_source);
        return parser.ParameterList();
    }

    private static Parameters getAnnotatedParameters(TemplateModel target) {
        Parameters params = null;
        Method keyMethod = null;
        if (target instanceof TemplateTransformModel) {
            try {
                keyMethod = target.getClass().getMethod("getWriter", Writer.class, Map.class);
            }
            catch (Exception e) {
                throw new InternalError(e.getMessage());
            }
        }
        if (target instanceof SimpleMethodModel) {
            params = ((SimpleMethodModel)target).getParametersAnnotation();
        } else if (target instanceof TemplateMethodModel) {
            try {
                keyMethod = target.getClass().getMethod("exec", List.class);
            }
            catch (Exception e) {
                throw new InternalError(e.getMessage());
            }
        }
        if (keyMethod != null) {
            params = keyMethod.getAnnotation(Parameters.class);
        }
        if (params == null) {
            params = target.getClass().getAnnotation(Parameters.class);
        }
        return params;
    }

    public void setLocationInfoIfAbsent(TemplateNode invoker) {
        if (this.getBeginLine() == 0) {
            this.copyLocationFrom(invoker);
        }
    }

    abstract ArgsList deepClone(String var1, Expression var2);

    abstract void addOOParamArg(OOParamElement var1) throws ParseException;

    abstract int size();
}

