/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core.ast;

import freemarker.core.Environment;
import freemarker.core.ast.BooleanExpression;
import freemarker.core.ast.Expression;

public class AndExpression
extends BooleanExpression {
    private Expression left;
    private Expression right;

    public AndExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        left.parent = this;
        right.parent = this;
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    @Override
    boolean isTrue(Environment env) {
        return this.left.isTrue(env) && this.right.isTrue(env);
    }

    @Override
    boolean isLiteral() {
        return this.constantValue != null || this.left.isLiteral() && this.right.isLiteral();
    }

    @Override
    Expression _deepClone(String name, Expression subst) {
        return new AndExpression(this.left.deepClone(name, subst), this.right.deepClone(name, subst));
    }
}

