/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc;

import com.clickhouse.client.api.data_formats.ClickHouseBinaryFormatWriter;
import com.clickhouse.client.api.data_formats.RowBinaryFormatWriter;
import com.clickhouse.client.api.insert.InsertResponse;
import com.clickhouse.client.api.insert.InsertSettings;
import com.clickhouse.client.api.metadata.TableSchema;
import com.clickhouse.data.ClickHouseColumn;
import com.clickhouse.data.ClickHouseFormat;
import com.clickhouse.jdbc.ConnectionImpl;
import com.clickhouse.jdbc.PreparedStatementImpl;
import com.clickhouse.jdbc.internal.ExceptionUtils;
import com.clickhouse.jdbc.internal.ParsedPreparedStatement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public class WriterStatementImpl
extends PreparedStatementImpl
implements PreparedStatement {
    private ByteArrayOutputStream out;
    private ClickHouseBinaryFormatWriter writer;
    private final TableSchema tableSchema;

    public WriterStatementImpl(ConnectionImpl connection, String originalSql, TableSchema tableSchema, ParsedPreparedStatement parsedStatement) throws SQLException {
        super(connection, originalSql, parsedStatement);
        if (parsedStatement.getInsertColumns() != null) {
            ArrayList<ClickHouseColumn> insertColumns = new ArrayList<ClickHouseColumn>();
            for (String column : parsedStatement.getInsertColumns()) {
                insertColumns.add(tableSchema.getColumnByName(column));
            }
            this.tableSchema = new TableSchema(tableSchema.getTableName(), tableSchema.getQuery(), tableSchema.getDatabaseName(), insertColumns);
        } else {
            this.tableSchema = tableSchema;
        }
        try {
            this.resetWriter();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private void resetWriter() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
        this.out = new ByteArrayOutputStream();
        this.writer = new RowBinaryFormatWriter((OutputStream)this.out, this.tableSchema, this.tableSchema.hasDefaults() ? ClickHouseFormat.RowBinaryWithDefaults : ClickHouseFormat.RowBinary);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.ensureOpen();
        throw new UnsupportedOperationException("bug. This PreparedStatement implementation should not be used with queries");
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return null;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.ensureOpen();
        try {
            this.writer.commitRow();
        }
        catch (Exception e) {
            this.handleSocketTimeoutException(e);
            throw new SQLException(e);
        }
        int updateCount = 0;
        ByteArrayInputStream in = new ByteArrayInputStream(this.out.toByteArray());
        InsertSettings settings = new InsertSettings();
        try (InsertResponse response = this.queryTimeout == 0 ? (InsertResponse)this.connection.getClient().insert(this.tableSchema.getTableName(), (InputStream)in, this.writer.getFormat(), settings).get() : (InsertResponse)this.connection.getClient().insert(this.tableSchema.getTableName(), (InputStream)in, this.writer.getFormat(), settings).get(this.queryTimeout, TimeUnit.SECONDS);){
            updateCount = Math.max(0, (int)response.getWrittenRows());
            this.lastQueryId = response.getQueryId();
        }
        catch (Exception e) {
            this.handleSocketTimeoutException(e);
            throw ExceptionUtils.toSqlState(e);
        }
        finally {
            try {
                this.resetWriter();
            }
            catch (Exception exception) {}
        }
        return updateCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ensureOpen();
        this.writer.setValue(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ensureOpen();
        this.writer.setValue(parameterIndex, (Object)x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        this.writer.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        this.writer.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        this.writer.setInteger(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        this.writer.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        this.writer.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        this.writer.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
        this.writer.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        this.writer.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, int length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        this.writer.clearRow();
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeLargeUpdate();
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        try {
            this.writer.commitRow();
        }
        catch (Exception e) {
            this.handleSocketTimeoutException(e);
            throw new SQLException(e);
        }
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.ensureOpen();
        this.setClob(parameterIndex, x.getCharacterStream());
    }

    @Override
    public void setClob(int parameterIndex, Reader x) throws SQLException {
        this.ensureOpen();
        this.setClob(parameterIndex, x, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
        this.writer.setReader(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.ensureOpen();
        this.setBlob(parameterIndex, x.getBinaryStream(), x.length());
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x, long length) throws SQLException {
        this.ensureOpen();
        this.writer.setInputStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.ensureOpen();
        this.writer.setInputStream(parameterIndex, inputStream, -1L);
    }

    @Override
    public void setNClob(int parameterIndex, Reader x, long length) throws SQLException {
        this.ensureOpen();
        this.writer.setReader(parameterIndex, x, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob x) throws SQLException {
        this.ensureOpen();
        this.setNClob(parameterIndex, x.getCharacterStream(), x.length());
    }

    @Override
    public void setNClob(int parameterIndex, Reader x) throws SQLException {
        this.ensureOpen();
        this.setNClob(parameterIndex, x, -1L);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML x) throws SQLException {
        this.ensureOpen();
        this.writer.setReader(parameterIndex, x.getCharacterStream(), -1L);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.ensureOpen();
        this.writer.setValue(parameterIndex, x.getArray());
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ensureOpen();
        this.writer.setValue(parameterIndex, (Object)this.sqlDateToInstant(x, cal));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ensureOpen();
        this.writer.setValue(parameterIndex, (Object)this.sqlTimeToInstant(x, cal));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ensureOpen();
        this.writer.setDateTime(parameterIndex, this.sqlTimestampToZDT(x, cal));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        this.writer.setValue(parameterIndex, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.ensureOpen();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.ensureOpen();
        throw new SQLException("ROWID is not supported", "0A000");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.ensureOpen();
        this.writer.setString(parameterIndex, value);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        throw new SQLException("This form of setObject is not supported yet", "0A000");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ensureOpen();
        throw new SQLException("This form of setObject is not supported yet", "0A000");
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        this.writer.setValue(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.ensureOpen();
        throw new SQLException("This form of setObject is not supported yet", "0A000");
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        throw new SQLException("This form of setObject is not supported yet", "0A000");
    }

    @Override
    public void close() throws SQLException {
        super.close();
        try {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            this.writer = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.resetWriter();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureOpen();
        int batchSize = this.writer.getRowCount();
        long rowsInserted = this.executeLargeUpdate();
        int[] results = new int[batchSize];
        Arrays.fill(results, (long)batchSize == rowsInserted ? 1 : -2);
        return results;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.ensureOpen();
        int batchSize = this.writer.getRowCount();
        long rowsInserted = this.executeLargeUpdate();
        long[] results = new long[batchSize];
        Arrays.fill(results, (long)batchSize == rowsInserted ? 1L : -2L);
        return results;
    }
}

