/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api;

import com.clickhouse.client.api.data_formats.internal.BinaryStreamReader;
import com.clickhouse.data.ClickHouseDataType;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Objects;

public class DataTypeUtils {
    public static DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");
    public static DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd");
    public static DateTimeFormatter DATETIME_WITH_NANOS_FORMATTER = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
    private static final DateTimeFormatter INSTANT_FORMATTER;
    public static final DateTimeFormatter TIME_WITH_NANOS_FORMATTER;
    public static final DateTimeFormatter TIME_FORMATTER;

    public static String formatInstant(Instant instant) {
        return DataTypeUtils.formatInstant(instant, null);
    }

    public static String formatInstant(Instant instant, ClickHouseDataType dataTypeHint) {
        return DataTypeUtils.formatInstant(instant, dataTypeHint, null);
    }

    public static String formatInstant(Instant instant, ClickHouseDataType dataTypeHint, ZoneId timeZone) {
        Objects.requireNonNull(instant, "Instant required for formatInstant");
        if (dataTypeHint == null) {
            return DataTypeUtils.formatInstantDefault(instant);
        }
        switch (dataTypeHint) {
            case Date: 
            case Date32: {
                Objects.requireNonNull(timeZone, "TimeZone required for formatting Instant for '" + dataTypeHint + "' use");
                return DATE_FORMATTER.format(instant.atZone(timeZone).toLocalDate());
            }
            case DateTime: 
            case DateTime32: {
                return String.valueOf(instant.getEpochSecond());
            }
        }
        return DataTypeUtils.formatInstantDefault(instant);
    }

    private static String formatInstantDefault(Instant instant) {
        return INSTANT_FORMATTER.format(instant);
    }

    public static Instant instantFromTime64Integer(int precision, long value) {
        int nanoSeconds = 0;
        if (precision > 0) {
            int factor = BinaryStreamReader.BASES[precision];
            nanoSeconds = (int)(value % (long)factor);
            value /= (long)factor;
            if (nanoSeconds < 0) {
                nanoSeconds += factor;
                --value;
            }
            if ((long)nanoSeconds > 0L) {
                nanoSeconds *= BinaryStreamReader.BASES[9 - precision];
            }
        }
        return Instant.ofEpochSecond(value, nanoSeconds);
    }

    static {
        TIME_WITH_NANOS_FORMATTER = INSTANT_FORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.INSTANT_SECONDS).appendFraction(ChronoField.NANO_OF_SECOND, 9, 9, true).toFormatter();
        TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    }
}

